/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveForLoopIndicesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "()V", "WITH_INDEX_FQ_NAMES", "", "", "WITH_INDEX_NAME", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class RemoveForLoopIndicesIntention
extends SelfTargetingRangeIntention<KtForExpression> {
    private final String WITH_INDEX_NAME = "withIndex";
    private final Set<String> WITH_INDEX_FQ_NAMES;

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtForExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getLoopRange();
        if (!(ktExpression instanceof KtDotQualifiedExpression)) {
            ktExpression = null;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression;
        if (ktDotQualifiedExpression == null) {
            return null;
        }
        KtDotQualifiedExpression loopRange = ktDotQualifiedExpression;
        KtDestructuringDeclaration ktDestructuringDeclaration = element3.getDestructuringDeclaration();
        if (ktDestructuringDeclaration == null) {
            return null;
        }
        KtDestructuringDeclaration multiParameter = ktDestructuringDeclaration;
        if (multiParameter.getEntries().size() != 2) {
            return null;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(loopRange, bindingContext2);
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (!CollectionsKt.contains((Iterable)this.WITH_INDEX_FQ_NAMES, resolvedCall3 != null && (resolvedCall3 = resolvedCall3.getResultingDescriptor()) != null && (resolvedCall3 = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((Object)resolvedCall3))) != null ? ((FqNameUnsafe)((Object)resolvedCall3)).asString() : null)) {
            return null;
        }
        KtDestructuringDeclarationEntry indexVar = multiParameter.getEntries().get(0);
        if (CollectionsKt.any((Iterable)((Iterable)ReferencesSearch.search((PsiElement)indexVar)))) {
            return null;
        }
        PsiElement psiElement2 = indexVar.getNameIdentifier();
        return psiElement2 != null ? FixersUtilKt.getRange(psiElement2) : null;
    }

    @Override
    public void applyTo(@NotNull KtForExpression element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtDestructuringDeclaration ktDestructuringDeclaration = element3.getDestructuringDeclaration();
        if (ktDestructuringDeclaration == null) {
            Intrinsics.throwNpe();
        }
        KtDestructuringDeclaration multiParameter = ktDestructuringDeclaration;
        KtExpression ktExpression = element3.getLoopRange();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
        }
        KtDotQualifiedExpression loopRange = (KtDotQualifiedExpression)ktExpression;
        KtDestructuringDeclarationEntry elementVar = multiParameter.getEntries().get(1);
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        Object[] objectArray = new Object[1];
        String string = elementVar.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"elementVar.text");
        objectArray[0] = string;
        KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "for ($0 in _) {}", objectArray, false, 4, null);
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
        }
        KtForExpression loop = (KtForExpression)ktExpression2;
        KtParameter ktParameter = element3.getLoopParameter();
        if (ktParameter == null) {
            Intrinsics.throwNpe();
        }
        KtParameter ktParameter2 = loop.getLoopParameter();
        if (ktParameter2 == null) {
            Intrinsics.throwNpe();
        }
        ktParameter.replace(ktParameter2);
        loopRange.replace((PsiElement)loopRange.getReceiverExpression());
    }

    /*
     * WARNING - void declaration
     */
    public RemoveForLoopIndicesIntention() {
        super(KtForExpression.class, "Remove indices in 'for' loop", null, 4, null);
        void var3_4;
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = CollectionsKt.listOf((Object[])new String[]{"collections", "sequences", "text", "ranges"});
        RemoveForLoopIndicesIntention removeForLoopIndicesIntention = this;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            String string2 = "kotlin." + (String)it + '.' + this.WITH_INDEX_NAME;
            collection.add(string2);
        }
        collection = (List)var3_4;
        removeForLoopIndicesIntention.WITH_INDEX_FQ_NAMES = CollectionsKt.toSet((Iterable)collection);
    }
}

