/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinJavaMavenConfigurator;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinTestJUnitInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "ReplaceToKotlinTest", "idea-maven"})
public final class KotlinTestJUnitInspection
extends DomElementsInspection<MavenDomProjectModel> {
    /*
     * WARNING - void declaration
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean hasJunit;
        Object element$iv2;
        block10: {
            boolean bl;
            if (domFileElement == null || holder == null) {
                return;
            }
            Module module = domFileElement.getModule();
            if (module == null) {
                return;
            }
            Module module2 = module;
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module2.getProject());
            if (mavenProjectsManager == null) {
                return;
            }
            MavenProjectsManager manager = mavenProjectsManager;
            MavenProject mavenProject = manager.findProject(module2);
            if (mavenProject == null) {
                return;
            }
            MavenProject mavenProject2 = mavenProject;
            Iterable $receiver$iv2 = mavenProject2.getDependencies();
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $receiver$iv2) {
                    MavenArtifact it = (MavenArtifact)element$iv2;
                    if (!(Intrinsics.areEqual((Object)it.getGroupId(), (Object)"junit") && Intrinsics.areEqual((Object)it.getArtifactId(), (Object)"junit"))) continue;
                    bl = true;
                    break block10;
                }
                bl = hasJunit = false;
            }
        }
        if (!hasJunit) {
            return;
        }
        Iterable iterable = ((MavenDomProjectModel)domFileElement.getRootElement()).getDependencies().getDependencies();
        element$iv2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            MavenDomDependency it = (MavenDomDependency)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.getGroupId().getRawText(), (Object)KotlinMavenConfigurator.Companion.getGROUP_ID()) && Intrinsics.areEqual((Object)it.getArtifactId().getRawText(), (Object)KotlinJavaMavenConfigurator.Companion.getTEST_LIB_ID()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List kotlinTestDependencies = (List)destination$iv$iv;
        $receiver$iv = kotlinTestDependencies;
        for (Object element$iv3 : $receiver$iv) {
            MavenDomDependency it = (MavenDomDependency)element$iv3;
            DomElement domElement = (DomElement)it.getArtifactId();
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
            MavenDomDependency mavenDomDependency = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenDomDependency, (String)"it");
            localQuickFixArray[0] = new ReplaceToKotlinTest(mavenDomDependency);
            holder.createProblem(domElement, HighlightSeverity.WEAK_WARNING, "kotlin-test-junit is better with junit", localQuickFixArray);
        }
    }

    public KotlinTestJUnitInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinTestJUnitInspection$ReplaceToKotlinTest;", "Lcom/intellij/codeInspection/LocalQuickFix;", "dependency", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "(Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;)V", "getDependency", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea-maven"})
    private static final class ReplaceToKotlinTest
    implements LocalQuickFix {
        @NotNull
        private final MavenDomDependency dependency;

        @NotNull
        public String getName() {
            return "Replace with kotlin-test-junit";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            if (this.dependency.isValid()) {
                this.dependency.getArtifactId().setStringValue("kotlin-test-junit");
            }
        }

        @NotNull
        public final MavenDomDependency getDependency() {
            return this.dependency;
        }

        public ReplaceToKotlinTest(@NotNull MavenDomDependency dependency) {
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            this.dependency = dependency;
        }
    }
}

