/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.ImportFixBase;
import org.jetbrains.kotlin.idea.quickfix.OrdinaryImportFixBase;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ArrayAccessorImportFix;", "Lorg/jetbrains/kotlin/idea/quickfix/OrdinaryImportFixBase;", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "element", "importNames", "", "Lorg/jetbrains/kotlin/name/Name;", "showHint", "", "(Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;Ljava/util/Collection;Z)V", "getImportNames", "()Ljava/util/Collection;", "getCallTypeAndReceiver", "Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver$OPERATOR;", "editor", "Lcom/intellij/openapi/editor/Editor;", "MyFactory", "idea"})
public class ArrayAccessorImportFix
extends OrdinaryImportFixBase<KtArrayAccessExpression> {
    @NotNull
    private final Collection<Name> importNames;
    private final boolean showHint;
    public static final MyFactory MyFactory = new MyFactory(null);

    @Nullable
    protected CallTypeAndReceiver.OPERATOR getCallTypeAndReceiver() {
        CallTypeAndReceiver.OPERATOR oPERATOR;
        KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)this.getElement();
        if (ktArrayAccessExpression != null) {
            KtArrayAccessExpression ktArrayAccessExpression2;
            KtArrayAccessExpression it = ktArrayAccessExpression2 = ktArrayAccessExpression;
            KtExpression ktExpression = it.getArrayExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"it.arrayExpression!!");
            oPERATOR = new CallTypeAndReceiver.OPERATOR(ktExpression);
        } else {
            oPERATOR = null;
        }
        return oPERATOR;
    }

    @Override
    public boolean showHint(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return this.showHint && super.showHint(editor);
    }

    @Override
    @NotNull
    protected Collection<Name> getImportNames() {
        return this.importNames;
    }

    public ArrayAccessorImportFix(@NotNull KtArrayAccessExpression element3, @NotNull Collection<Name> importNames, boolean showHint2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(importNames, (String)"importNames");
        super((KtExpression)element3, MyFactory);
        this.importNames = importNames;
        this.showHint = showHint2;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ArrayAccessorImportFix$MyFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$Factory;", "()V", "createImportAction", "Lorg/jetbrains/kotlin/idea/quickfix/ArrayAccessorImportFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "importName", "Lorg/jetbrains/kotlin/name/Name;", "idea"})
    public static final class MyFactory
    extends ImportFixBase.Factory {
        private final Name importName(Diagnostic diagnostic) {
            Name name2;
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual(diagnosticFactory, Errors.NO_GET_METHOD)) {
                name2 = OperatorNameConventions.GET;
            } else if (Intrinsics.areEqual(diagnosticFactory, Errors.NO_SET_METHOD)) {
                name2 = OperatorNameConventions.SET;
            } else {
                throw (Throwable)new IllegalStateException("Shouldn't be called for other diagnostics");
            }
            return name2;
        }

        @Nullable
        public ArrayAccessorImportFix createImportAction(@NotNull Diagnostic diagnostic) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory<?> factory2 = diagnostic.getFactory();
            boolean bl2 = bl = Intrinsics.areEqual(factory2, Errors.NO_GET_METHOD) || Intrinsics.areEqual(factory2, Errors.NO_SET_METHOD);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiElement element3 = diagnostic.getPsiElement();
            if (element3 instanceof KtArrayAccessExpression && ((KtArrayAccessExpression)element3).getArrayExpression() != null) {
                return new ArrayAccessorImportFix((KtArrayAccessExpression)element3, CollectionsKt.listOf((Object)this.importName(diagnostic)), true);
            }
            return null;
        }

        private MyFactory() {
        }

        public /* synthetic */ MyFactory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

