/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.BaseJavaApplicationCommandLineState;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.run.JetRunConfigurationEditor;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationProducer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class JetRunConfiguration
extends ModuleBasedConfiguration<RunConfigurationModule>
implements CommonJavaRunConfigurationParameters,
RefactoringListenerProvider {
    public String MAIN_CLASS_NAME;
    public String VM_PARAMETERS;
    public String PROGRAM_PARAMETERS;
    public String WORKING_DIRECTORY;
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    private Map<String, String> myEnvs = new LinkedHashMap<String, String>();
    public boolean PASS_PARENT_ENVS = true;

    public JetRunConfiguration(String name2, RunConfigurationModule runConfigurationModule, ConfigurationFactory factory2) {
        super(name2, runConfigurationModule, factory2);
        runConfigurationModule.init();
    }

    public Collection<Module> getValidModules() {
        return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
    }

    @Nullable
    public GlobalSearchScope getSearchScope() {
        return SearchScopeProvider.createSearchScope((Module[])this.getModules());
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new JetRunConfigurationEditor(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public void readExternal(Element element3) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element3);
        super.readExternal(element3);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element3);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element3);
        this.readModule(element3);
        EnvironmentVariablesComponent.readExternal((Element)element3, this.getEnvs());
    }

    public void writeExternal(Element element3) throws WriteExternalException {
        super.writeExternal(element3);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element3);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element3);
        this.writeModule(element3);
        EnvironmentVariablesComponent.writeExternal((Element)element3, this.getEnvs());
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element3);
    }

    public void setVMParameters(String value2) {
        this.VM_PARAMETERS = value2;
    }

    public String getVMParameters() {
        return this.VM_PARAMETERS;
    }

    public void setProgramParameters(String value2) {
        this.PROGRAM_PARAMETERS = value2;
    }

    public String getProgramParameters() {
        return this.PROGRAM_PARAMETERS;
    }

    public void setWorkingDirectory(String value2) {
        this.WORKING_DIRECTORY = ExternalizablePath.urlValue((String)value2);
    }

    public String getWorkingDirectory() {
        return ExternalizablePath.localPathValue((String)this.WORKING_DIRECTORY);
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.PASS_PARENT_ENVS = passParentEnvs;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map2 = this.myEnvs;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "getEnvs"));
        }
        return map2;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "setEnvs"));
        }
        this.myEnvs = envs;
    }

    public boolean isPassParentEnvs() {
        return this.PASS_PARENT_ENVS;
    }

    public String getRunClass() {
        return this.MAIN_CLASS_NAME;
    }

    public void setRunClass(String value2) {
        this.MAIN_CLASS_NAME = value2;
    }

    public String getPackage() {
        return null;
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String path) {
        this.ALTERNATIVE_JRE_PATH = path;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this);
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)this.getConfigurationModule().getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
        Module module = this.getConfigurationModule().getModule();
        if (module == null) {
            throw new RuntimeConfigurationError("Module not specified");
        }
        if (StringUtil.isEmpty((String)this.MAIN_CLASS_NAME)) {
            throw new RuntimeConfigurationError("No main class specified");
        }
        PsiClass psiClass2 = JavaExecutionUtil.findMainClass((Module)module, (String)this.MAIN_CLASS_NAME);
        if (psiClass2 == null) {
            throw new RuntimeConfigurationWarning("Class '" + this.MAIN_CLASS_NAME + "' not found in module " + this.getConfigurationModule().getModuleName());
        }
        if (JetRunConfiguration.findMainFun(psiClass2) == null) {
            throw new RuntimeConfigurationWarning("The class " + this.MAIN_CLASS_NAME + " has no main method");
        }
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "getState"));
        }
        if (executionEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionEnvironment", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "getState"));
        }
        return new MyJavaCommandLineState(this, executionEnvironment);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element3) {
        String fqNameBeingRenamed = element3 instanceof KtDeclarationContainer ? KotlinRunConfigurationProducer.Companion.getStartClassFqName((KtDeclarationContainer)element3) : (element3 instanceof PsiPackage ? ((PsiPackage)element3).getQualifiedName() : null);
        if (fqNameBeingRenamed == null || !this.MAIN_CLASS_NAME.equals(fqNameBeingRenamed) && !this.MAIN_CLASS_NAME.startsWith(fqNameBeingRenamed + ".")) {
            return null;
        }
        if (element3 instanceof KtDeclarationContainer) {
            return new RefactoringElementAdapter(){

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$1", "undoElementMovedOrRenamed"));
                    }
                    if (oldQualifiedName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$1", "undoElementMovedOrRenamed"));
                    }
                    JetRunConfiguration.this.updateMainClassName(newElement);
                }

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$1", "elementRenamedOrMoved"));
                    }
                    JetRunConfiguration.this.updateMainClassName(newElement);
                }
            };
        }
        final String nameSuffix = this.MAIN_CLASS_NAME.substring(fqNameBeingRenamed.toString().length());
        return new RefactoringElementAdapter(){

            protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                if (newElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$2", "elementRenamedOrMoved"));
                }
                JetRunConfiguration.this.updateMainClassNameWithSuffix(newElement, nameSuffix);
            }

            public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                if (newElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$2", "undoElementMovedOrRenamed"));
                }
                if (oldQualifiedName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$2", "undoElementMovedOrRenamed"));
                }
                JetRunConfiguration.this.updateMainClassNameWithSuffix(newElement, nameSuffix);
            }
        };
    }

    private void updateMainClassName(PsiElement element3) {
        KtDeclarationContainer container2 = KotlinRunConfigurationProducer.Companion.getEntryPointContainer(element3);
        String name2 = KotlinRunConfigurationProducer.Companion.getStartClassFqName(container2);
        if (name2 != null) {
            this.MAIN_CLASS_NAME = name2;
        }
    }

    private void updateMainClassNameWithSuffix(PsiElement element3, String suffix) {
        if (element3 instanceof PsiPackage) {
            this.MAIN_CLASS_NAME = ((PsiPackage)element3).getQualifiedName() + suffix;
        }
    }

    public String suggestedName() {
        if (StringUtil.isEmpty((String)this.MAIN_CLASS_NAME)) {
            return null;
        }
        return this.MAIN_CLASS_NAME;
    }

    @NotNull
    private static Collection<KtNamedFunction> getMainFunCandidates(@NotNull PsiClass psiClass2) {
        if (psiClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "getMainFunCandidates"));
        }
        List list2 = CollectionsKt.filterNotNull((Iterable)ArraysKt.map((Object[])psiClass2.getAllMethods(), (Function1)new Function1<PsiMethod, KtNamedFunction>(){

            public KtNamedFunction invoke(PsiMethod method) {
                if (!(method instanceof KtLightMethod)) {
                    return null;
                }
                if (!method.getName().equals("main")) {
                    return null;
                }
                KtDeclaration declaration2 = (KtDeclaration)((KtLightMethod)method).getKotlinOrigin();
                return declaration2 instanceof KtNamedFunction ? (KtNamedFunction)declaration2 : null;
            }
        }));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "getMainFunCandidates"));
        }
        return list2;
    }

    @Nullable
    private static KtNamedFunction findMainFun(@NotNull PsiClass psiClass2) {
        if (psiClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/idea/run/JetRunConfiguration", "findMainFun"));
        }
        for (KtNamedFunction function2 : JetRunConfiguration.getMainFunCandidates(psiClass2)) {
            BindingContext bindingContext2 = ResolutionUtils.analyze(function2, BodyResolveMode.FULL);
            MainFunctionDetector mainFunctionDetector2 = new MainFunctionDetector(bindingContext2);
            if (!mainFunctionDetector2.isMain(function2)) continue;
            return function2;
        }
        return null;
    }

    private static class MyJavaCommandLineState
    extends BaseJavaApplicationCommandLineState<JetRunConfiguration> {
        public MyJavaCommandLineState(@NotNull JetRunConfiguration configuration2, ExecutionEnvironment environment2) {
            if (configuration2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "<init>"));
            }
            super(environment2, (RunConfigurationBase)configuration2);
        }

        protected JavaParameters createJavaParameters() throws ExecutionException {
            JavaParameters params2 = new JavaParameters();
            RunConfigurationModule module = ((JetRunConfiguration)this.myConfiguration).getConfigurationModule();
            int classPathType = this.getClasspathType(module);
            String jreHome = ((JetRunConfiguration)this.myConfiguration).ALTERNATIVE_JRE_PATH_ENABLED ? ((JetRunConfiguration)this.myConfiguration).ALTERNATIVE_JRE_PATH : null;
            JavaParametersUtil.configureModule((RunConfigurationModule)module, (JavaParameters)params2, (int)classPathType, (String)jreHome);
            this.setupJavaParameters(params2);
            params2.setMainClass(((JetRunConfiguration)this.myConfiguration).getRunClass());
            return params2;
        }

        private int getClasspathType(RunConfigurationModule configurationModule) throws CantRunException {
            VirtualFile virtualFileForMainFun;
            Module module = configurationModule.getModule();
            if (module == null) {
                throw CantRunException.noModuleConfigured((String)configurationModule.getModuleName());
            }
            String runClass = ((JetRunConfiguration)this.myConfiguration).getRunClass();
            if (runClass == null) {
                throw new CantRunException(String.format("Run class should be defined for configuration '%s'", ((JetRunConfiguration)this.myConfiguration).getName()));
            }
            PsiClass psiClass2 = JavaExecutionUtil.findMainClass((Module)module, (String)runClass);
            if (psiClass2 == null) {
                throw CantRunException.classNotFound((String)runClass, (Module)module);
            }
            KtNamedFunction mainFun = JetRunConfiguration.findMainFun(psiClass2);
            if (mainFun == null) {
                throw new CantRunException(this.noFunctionFoundMessage(psiClass2));
            }
            Module classModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)mainFun);
            if (classModule == null) {
                classModule = module;
            }
            if ((virtualFileForMainFun = mainFun.getContainingFile().getVirtualFile()) == null) {
                throw new CantRunException(this.noFunctionFoundMessage(psiClass2));
            }
            ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)classModule).getFileIndex();
            if (fileIndex.isInSourceContent(virtualFileForMainFun)) {
                if (fileIndex.isInTestSourceContent(virtualFileForMainFun)) {
                    return 7;
                }
                return 3;
            }
            List entriesForFile = fileIndex.getOrderEntriesForFile(virtualFileForMainFun);
            for (OrderEntry entry : entriesForFile) {
                if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.TEST) continue;
                return 7;
            }
            return 3;
        }

        @NotNull
        private String noFunctionFoundMessage(@NotNull PsiClass psiClass2) {
            if (psiClass2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "noFunctionFoundMessage"));
            }
            FqName classFqName = new FqName(psiClass2.getQualifiedName());
            if (psiClass2 instanceof KtLightClassForSourceDeclaration) {
                String string = String.format("Function 'main' not found in class '%s'", classFqName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "noFunctionFoundMessage"));
                }
                return string;
            }
            String string = String.format("Top-level function 'main' not found in package '%s'", classFqName.parent());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfiguration$MyJavaCommandLineState", "noFunctionFoundMessage"));
            }
            return string;
        }
    }
}

