/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/run/LocalFileHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "path", "", "line", "", "column", "(Ljava/lang/String;II)V", "getColumn", "()I", "getLine", "getPath", "()Ljava/lang/String;", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
public final class LocalFileHyperlinkInfo
implements HyperlinkInfo {
    @NotNull
    private final String path;
    private final int line;
    private final int column;

    public void navigate(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile f = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)this.path));
        if (f != null) {
            new OpenFileDescriptor(project, f, this.line, this.column).navigate(true);
        }
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    public LocalFileHyperlinkInfo(@NotNull String path, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.path = path;
        this.line = line;
        this.column = column;
    }
}

