/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.ImpreciseResolveResult;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.search.PsiBasedClassResolver;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinAnnotatedElementsSearcher;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinAnnotatedElementsSearcher$Companion$getKotlinAnnotationCandidates$1$$special$;
import org.jetbrains.kotlin.idea.stubindex.KotlinAnnotationsIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAnnotatedElementsSearcher;", "Lcom/intellij/util/QueryExecutor;", "Lcom/intellij/psi/PsiModifierListOwner;", "Lcom/intellij/psi/search/searches/AnnotatedElementsSearch$Parameters;", "()V", "execute", "", "p", "consumer", "Lcom/intellij/util/Processor;", "Companion", "idea"})
public final class KotlinAnnotatedElementsSearcher
implements QueryExecutor<PsiModifierListOwner, AnnotatedElementsSearch.Parameters> {
    private static final Logger LOG;
    public static final Companion Companion;

    public boolean execute(@NotNull AnnotatedElementsSearch.Parameters p, @NotNull Processor<PsiModifierListOwner> consumer2) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        PsiClass psiClass2 = p.getAnnotationClass();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"p.annotationClass");
        SearchScope searchScope2 = p.getScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"p.scope");
        return org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinAnnotatedElementsSearcher$Companion.processAnnotatedMembers$default(Companion, psiClass2, searchScope2, null, (Function1)new Function1<KtDeclaration, Boolean>(consumer2){
            final /* synthetic */ Processor $consumer;

            public final boolean invoke(@NotNull KtDeclaration declaration2) {
                boolean bl;
                block10: {
                    Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                    KtDeclaration ktDeclaration = declaration2;
                    if (ktDeclaration instanceof KtClass) {
                        KtLightClass lightClass2 = LightClassUtilsKt.toLightClass((KtClassOrObject)declaration2);
                        bl = this.$consumer.process((Object)lightClass2);
                    } else if (ktDeclaration instanceof KtNamedFunction || ktDeclaration instanceof KtConstructor) {
                        PsiMethod wrappedMethod = LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)declaration2);
                        bl = this.$consumer.process((Object)wrappedMethod);
                    } else if (ktDeclaration instanceof KtProperty) {
                        PsiField backingField = LightClassUtil.INSTANCE.getLightClassBackingField(declaration2);
                        if (backingField != null) {
                            return this.$consumer.process((Object)backingField);
                        }
                        Iterable $receiver$iv = LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)declaration2);
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $receiver$iv) {
                                PsiMethod it = (PsiMethod)element$iv;
                                if (this.$consumer.process((Object)it)) continue;
                                bl = false;
                                break block10;
                            }
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
                return bl;
            }
            {
                this.$consumer = processor2;
                super(1);
            }
        }, 4, null);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.AnnotatedMembersSearcher");
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J@\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f0\u0013R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAnnotatedElementsSearcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getKotlinAnnotationCandidates", "", "Lcom/intellij/psi/PsiElement;", "annClass", "Lcom/intellij/psi/PsiClass;", "useScope", "Lcom/intellij/psi/search/SearchScope;", "notKtAnnotationEntry", "", "found", "processAnnotatedMembers", "preFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "consumer", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "idea"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        public final boolean processAnnotatedMembers(@NotNull PsiClass annClass, @NotNull SearchScope useScope2, @NotNull Function1<? super KtAnnotationEntry, Boolean> preFilter, @NotNull Function1<? super KtDeclaration, Boolean> consumer2) {
            Intrinsics.checkParameterIsNotNull((Object)annClass, (String)"annClass");
            Intrinsics.checkParameterIsNotNull((Object)useScope2, (String)"useScope");
            Intrinsics.checkParameterIsNotNull(preFilter, (String)"preFilter");
            Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
            boolean bl = annClass.isAnnotationType();
            if (_Assertions.ENABLED && !bl) {
                String string = "Annotation type should be passed to annotated members search";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiBasedClassResolver psiBasedClassResolver = new PsiBasedClassResolver(annClass);
            String string = annClass.getQualifiedName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String annotationFQN = string;
            Collection<PsiElement> candidates2 = this.getKotlinAnnotationCandidates(annClass, useScope2);
            for (PsiElement elt : candidates2) {
                boolean result2;
                if (this.notKtAnnotationEntry(elt) || (result2 = ((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(elt, preFilter, psiBasedClassResolver, annotationFQN, consumer2){
                    final /* synthetic */ PsiElement $elt;
                    final /* synthetic */ Function1 $preFilter;
                    final /* synthetic */ PsiBasedClassResolver $psiBasedClassResolver;
                    final /* synthetic */ String $annotationFQN;
                    final /* synthetic */ Function1 $consumer;

                    public final boolean invoke() {
                        ImpreciseResolveResult psiBasedResolveResult;
                        ImpreciseResolveResult impreciseResolveResult;
                        if (!(this.$elt instanceof KtAnnotationEntry)) {
                            return true;
                        }
                        if (!((Boolean)this.$preFilter.invoke((Object)this.$elt)).booleanValue()) {
                            return true;
                        }
                        PsiElement $receiver$iv = this.$elt;
                        KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclaration.class, (boolean)true);
                        if (ktDeclaration == null) {
                            return true;
                        }
                        KtDeclaration declaration2 = ktDeclaration;
                        KtExpression ktExpression = ((KtAnnotationEntry)this.$elt).getCalleeExpression();
                        if (ktExpression != null && (ktExpression = ktExpression.getConstructorReferenceExpression()) != null) {
                            KtExpression $i$f$getStrictParentOfType;
                            KtExpression ref;
                            KtExpression ktExpression2 = ref = ($i$f$getStrictParentOfType = ktExpression);
                            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ref");
                            impreciseResolveResult = this.$psiBasedClassResolver.canBeTargetReference((KtSimpleNameExpression)ktExpression2);
                        } else {
                            impreciseResolveResult = psiBasedResolveResult = null;
                        }
                        if (Intrinsics.areEqual(psiBasedResolveResult, (Object)((Object)ImpreciseResolveResult.NO_MATCH))) {
                            return true;
                        }
                        if (Intrinsics.areEqual(psiBasedResolveResult, (Object)((Object)ImpreciseResolveResult.UNSURE))) {
                            BindingContext context = ResolutionUtils.analyze((KtElement)this.$elt, BodyResolveMode.PARTIAL);
                            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context.get(BindingContext.ANNOTATION, this.$elt);
                            if (annotationDescriptor == null) {
                                return true;
                            }
                            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                            FqName fqName2 = annotationDescriptor2.getFqName();
                            if (fqName2 == null) {
                                return true;
                            }
                            FqName fqName3 = fqName2;
                            if (Intrinsics.areEqual((Object)fqName3.asString(), (Object)this.$annotationFQN) ^ true) {
                                return true;
                            }
                        }
                        return (Boolean)this.$consumer.invoke((Object)declaration2) != false;
                    }
                    {
                        this.$elt = psiElement2;
                        this.$preFilter = function1;
                        this.$psiBasedClassResolver = psiBasedClassResolver;
                        this.$annotationFQN = string;
                        this.$consumer = function12;
                        super(0);
                    }
                })).booleanValue())) continue;
                return false;
            }
            return true;
        }

        public static /* bridge */ /* synthetic */ boolean processAnnotatedMembers$default(Companion companion, PsiClass psiClass2, SearchScope searchScope2, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = processAnnotatedMembers.1.INSTANCE;
            }
            return companion.processAnnotatedMembers(psiClass2, searchScope2, (Function1<? super KtAnnotationEntry, Boolean>)function1, (Function1<? super KtDeclaration, Boolean>)function12);
        }

        private final Collection<PsiElement> getKotlinAnnotationCandidates(PsiClass annClass, SearchScope useScope2) {
            return (Collection)ApplicationUtilsKt.runReadAction((Function0)new Function0<Collection<? extends PsiElement>>(useScope2, annClass){
                final /* synthetic */ SearchScope $useScope;
                final /* synthetic */ PsiClass $annClass;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Collection<PsiElement> invoke() {
                    void var3_5;
                    void $receiver$iv$iv;
                    Object[] $receiver$iv;
                    if (this.$useScope instanceof GlobalSearchScope) {
                        String string = this.$annClass.getName();
                        if (string == null) {
                            return CollectionsKt.emptyList();
                        }
                        String name2 = string;
                        GlobalSearchScope globalSearchScope = (GlobalSearchScope)this.$useScope;
                        Project project = this.$annClass.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"annClass.project");
                        GlobalSearchScope scope2 = KotlinSourceFilterScope.Companion.sourcesAndLibraries(globalSearchScope, project);
                        Collection<KtAnnotationEntry> collection = KotlinAnnotationsIndex.getInstance().get(name2, this.$annClass.getProject(), scope2);
                        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinAnnotationsIndex.g\u2026 annClass.project, scope)");
                        return collection;
                    }
                    SearchScope searchScope2 = this.$useScope;
                    if (searchScope2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.search.LocalSearchScope");
                    }
                    Object[] scope2 = $receiver$iv = (Object[])((LocalSearchScope)searchScope2).getScope();
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                        void $receiver$iv$iv$iv;
                        PsiElement it;
                        void element$iv$iv = $receiver$iv$iv[i];
                        PsiElement $receiver$iv2 = it = (PsiElement)element$iv$iv;
                        Function1 predicate$iv = Companion$getKotlinAnnotationCandidates$1$$special$$inlined$collectDescendantsOfType$1.INSTANCE;
                        PsiElement $receiver$iv$iv2 = $receiver$iv2;
                        ArrayList<E> result$iv$iv = new ArrayList<E>();
                        PsiElement psiElement2 = $receiver$iv$iv2;
                        Function1 action$iv$iv$iv = (Function1)new Function1<KtAnnotationEntry, Unit>(predicate$iv, result$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ ArrayList $result;
                            {
                                this.$predicate = function1;
                                this.$result = arrayList;
                                super(1);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public final void invoke(@NotNull PsiElement it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                                    this.$result.add(it);
                                }
                            }
                        };
                        $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
                            final /* synthetic */ Function1 $action;
                            {
                                this.$action = $captured_local_variable$1;
                            }

                            public void visitElement(@NotNull PsiElement element3) {
                                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                                PsiElement it = element3;
                                super.visitElement(element3);
                                if (element3 instanceof KtAnnotationEntry) {
                                    this.$action.invoke((Object)element3);
                                }
                            }
                        });
                        Iterable list$iv$iv = result$iv$iv;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    return (List)var3_5;
                }
                {
                    this.$useScope = searchScope2;
                    this.$annClass = psiClass2;
                    super(0);
                }
            });
        }

        private final boolean notKtAnnotationEntry(PsiElement found2) {
            if (found2 instanceof KtAnnotationEntry) {
                return false;
            }
            VirtualFile faultyContainer = PsiUtilCore.getVirtualFile((PsiElement)found2);
            this.getLOG().error("Non annotation in annotations list: " + faultyContainer + "; element:" + found2);
            if (faultyContainer != null && faultyContainer.isValid()) {
                FileBasedIndex.getInstance().requestReindex(faultyContainer);
            }
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

