/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.common.Symbol;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsLabel
extends SourceInfoAwareJsNode
implements JsStatement,
HasName {
    private JsName label;
    private JsStatement statement;

    public JsLabel(JsName label2) {
        this.label = label2;
    }

    public JsLabel(JsName label2, JsStatement statement2) {
        this.label = label2;
        this.statement = statement2;
    }

    @Override
    public JsName getName() {
        return this.label;
    }

    @Override
    public void setName(JsName name2) {
        this.label = name2;
    }

    @Override
    public Symbol getSymbol() {
        return this.label;
    }

    public JsStatement getStatement() {
        return this.statement;
    }

    public void setStatement(JsStatement statement2) {
        this.statement = statement2;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitLabel(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.statement);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.statement = v.acceptStatement(this.statement);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsLabel deepCopy() {
        JsLabel jsLabel = new JsLabel(this.label, AstUtil.deepCopy(this.statement)).withMetadataFrom(this);
        if (jsLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsLabel", "deepCopy"));
        }
        return jsLabel;
    }
}

