/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import com.intellij.util.SmartList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;

public class JsVisitorWithContextImpl
extends JsVisitorWithContext {
    protected final Stack<JsContext<JsStatement>> statementContexts = new Stack();

    private static void checkReplacement(JsNode origNode, JsNode newNode) {
        if (newNode == null) {
            throw new RuntimeException("Cannot replace with null");
        }
    }

    @Override
    protected <T extends JsNode> T doAccept(T node) {
        return new NodeContext<T>().traverse(node);
    }

    @Override
    protected JsExpression doAcceptLvalue(JsExpression expr2) {
        return new LvalueContext().traverse(expr2);
    }

    @Override
    protected <T extends JsStatement> JsStatement doAcceptStatement(T statement2) {
        SmartList statements = new SmartList(statement2);
        this.doAcceptStatementList((List<JsStatement>)statements);
        if (statements.size() == 1) {
            return (JsStatement)statements.get(0);
        }
        return new JsBlock((List<JsStatement>)statements);
    }

    @Override
    protected void doAcceptStatementList(List<JsStatement> statements) {
        ListContext<JsStatement> context = new ListContext<JsStatement>();
        this.statementContexts.push(context);
        context.traverse(statements);
        this.statementContexts.pop();
    }

    @Override
    protected <T extends JsNode> void doAcceptList(List<T> collection) {
        new ListContext<T>().traverse(collection);
    }

    @NotNull
    protected JsContext<JsStatement> getLastStatementLevelContext() {
        JsContext<JsStatement> jsContext = this.statementContexts.peek();
        if (jsContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl", "getLastStatementLevelContext"));
        }
        return jsContext;
    }

    @Override
    protected <T extends JsNode> void doTraverse(T node, JsContext ctx) {
        node.traverse(this, ctx);
    }

    private class NodeContext<T extends JsNode>
    extends JsContext<T> {
        protected T node;

        private NodeContext() {
        }

        @Override
        public void removeMe() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <R extends T> void replaceMe(R node) {
            JsVisitorWithContextImpl.checkReplacement(this.node, node);
            this.node = node;
        }

        @Override
        @Nullable
        public T getCurrentNode() {
            return this.node;
        }

        protected T traverse(T node) {
            this.node = node;
            JsVisitorWithContextImpl.this.doTraverse(node, this);
            return this.node;
        }
    }

    private class LvalueContext
    extends NodeContext<JsExpression> {
        private LvalueContext() {
        }
    }

    public class ListContext<T extends JsNode>
    extends JsContext<T> {
        private List<T> nodes;
        private int index;
        private final List<T> previous = new SmartList();
        private final List<T> next = new SmartList();
        private boolean removed = false;

        @Override
        public <R extends T> void addPrevious(R node) {
            this.previous.add(node);
        }

        @Override
        public <R extends T> void addNext(R node) {
            this.next.add(node);
        }

        @Override
        public void removeMe() {
            this.removed = true;
        }

        @Override
        public <R extends T> void replaceMe(R node) {
            JsVisitorWithContextImpl.checkReplacement((JsNode)this.nodes.get(this.index), node);
            this.nodes.set(this.index, node);
            this.removed = false;
        }

        @Override
        @Nullable
        public T getCurrentNode() {
            if (!this.removed && this.index < this.nodes.size()) {
                return (T)((JsNode)this.nodes.get(this.index));
            }
            return null;
        }

        public void traverse(List<T> nodes) {
            assert (this.previous.isEmpty()) : "addPrevious() was called before traverse()";
            assert (this.next.isEmpty()) : "addNext() was called before traverse()";
            this.nodes = nodes;
            this.index = 0;
            while (this.index < nodes.size()) {
                this.removed = false;
                this.previous.clear();
                this.next.clear();
                JsVisitorWithContextImpl.this.doTraverse(this.getCurrentNode(), this);
                if (!this.previous.isEmpty()) {
                    nodes.addAll(this.index, this.previous);
                    this.index += this.previous.size();
                }
                if (this.removed) {
                    nodes.remove(this.index);
                    --this.index;
                }
                if (!this.next.isEmpty()) {
                    nodes.addAll(this.index + 1, this.next);
                    this.index += this.next.size();
                }
                ++this.index;
            }
            this.previous.clear();
            this.next.clear();
        }
    }
}

