/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public final class ClassId {
    private final FqName packageFqName;
    private final FqName relativeClassName;
    private final boolean local;

    @NotNull
    public static ClassId topLevel(@NotNull FqName topLevelFqName) {
        if (topLevelFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelFqName", "org/jetbrains/kotlin/name/ClassId", "topLevel"));
        }
        ClassId classId = new ClassId(topLevelFqName.parent(), topLevelFqName.shortName());
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "topLevel"));
        }
        return classId;
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull FqName relativeClassName2, boolean local) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/name/ClassId", "<init>"));
        }
        if (relativeClassName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeClassName", "org/jetbrains/kotlin/name/ClassId", "<init>"));
        }
        this.packageFqName = packageFqName;
        assert (!relativeClassName2.isRoot()) : "Class name must not be root: " + packageFqName + (local ? " (local)" : "");
        this.relativeClassName = relativeClassName2;
        this.local = local;
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull Name topLevelName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/name/ClassId", "<init>"));
        }
        if (topLevelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelName", "org/jetbrains/kotlin/name/ClassId", "<init>"));
        }
        this(packageFqName, FqName.topLevel(topLevelName), false);
    }

    @NotNull
    public FqName getPackageFqName() {
        FqName fqName2 = this.packageFqName;
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "getPackageFqName"));
        }
        return fqName2;
    }

    @NotNull
    public FqName getRelativeClassName() {
        FqName fqName2 = this.relativeClassName;
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "getRelativeClassName"));
        }
        return fqName2;
    }

    @NotNull
    public Name getShortClassName() {
        Name name2 = this.relativeClassName.shortName();
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "getShortClassName"));
        }
        return name2;
    }

    public boolean isLocal() {
        return this.local;
    }

    @NotNull
    public ClassId createNestedClassId(@NotNull Name name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/name/ClassId", "createNestedClassId"));
        }
        ClassId classId = new ClassId(this.getPackageFqName(), this.relativeClassName.child(name2), this.local);
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "createNestedClassId"));
        }
        return classId;
    }

    @Nullable
    public ClassId getOuterClassId() {
        FqName parent2 = this.relativeClassName.parent();
        return parent2.isRoot() ? null : new ClassId(this.getPackageFqName(), parent2, this.local);
    }

    public boolean isNestedClass() {
        return !this.relativeClassName.parent().isRoot();
    }

    @NotNull
    public FqName asSingleFqName() {
        if (this.packageFqName.isRoot()) {
            FqName fqName2 = this.relativeClassName;
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "asSingleFqName"));
            }
            return fqName2;
        }
        FqName fqName3 = new FqName(this.packageFqName.asString() + "." + this.relativeClassName.asString());
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "asSingleFqName"));
        }
        return fqName3;
    }

    public boolean startsWith(@NotNull Name segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "org/jetbrains/kotlin/name/ClassId", "startsWith"));
        }
        return this.packageFqName.startsWith(segment);
    }

    @NotNull
    public String asString() {
        if (this.packageFqName.isRoot()) {
            String string = this.relativeClassName.asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "asString"));
            }
            return string;
        }
        String string = this.packageFqName.asString().replace('.', '/') + "/" + this.relativeClassName.asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "asString"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassId id = (ClassId)o;
        return this.packageFqName.equals(id.packageFqName) && this.relativeClassName.equals(id.relativeClassName) && this.local == id.local;
    }

    public int hashCode() {
        int result2 = this.packageFqName.hashCode();
        result2 = 31 * result2 + this.relativeClassName.hashCode();
        result2 = 31 * result2 + Boolean.valueOf(this.local).hashCode();
        return result2;
    }

    public String toString() {
        return this.packageFqName.isRoot() ? "/" + this.asString() : this.asString();
    }
}

