/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.annotations;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\n\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\n\u001a\n\u0010\f\u001a\u00020\r*\u00020\n\u001a\n\u0010\u000e\u001a\u00020\r*\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"JVM_STATIC_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "JVM_SYNTHETIC_ANNOTATION_FQ_NAME", "STRICTFP_ANNOTATION_FQ_NAME", "argumentValue", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "parameterName", "", "findJvmSyntheticAnnotation", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findStrictfpAnnotation", "hasJvmStaticAnnotation", "", "hasJvmSyntheticAnnotation", "frontend"})
public final class AnnotationUtilKt {
    private static final FqName JVM_STATIC_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmStatic");
    private static final FqName JVM_SYNTHETIC_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmSynthetic");
    private static final FqName STRICTFP_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Strictfp");

    public static final boolean hasJvmStaticAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getAnnotations().findAnnotation(JVM_STATIC_ANNOTATION_FQ_NAME) != null;
    }

    public static final boolean hasJvmSyntheticAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return AnnotationUtilKt.findJvmSyntheticAnnotation($receiver) != null;
    }

    @Nullable
    public static final AnnotationDescriptor findJvmSyntheticAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtils.getAnnotationByFqName($receiver.getAnnotations(), JVM_SYNTHETIC_ANNOTATION_FQ_NAME);
    }

    @Nullable
    public static final AnnotationDescriptor findStrictfpAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtils.getAnnotationByFqName($receiver.getAnnotations(), STRICTFP_ANNOTATION_FQ_NAME);
    }

    @Nullable
    public static final Object argumentValue(@NotNull AnnotationDescriptor $receiver, @NotNull String parameterName) {
        ConstantValue<?> constantValue;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)parameterName, (String)"parameterName");
        ConstantValue<?> it = constantValue = $receiver.getAllValueArguments().get(Name.identifier(parameterName));
        ConstantValue<Object> constantValue2 = !(it instanceof ErrorValue) ? constantValue : null;
        return constantValue2 != null ? constantValue2.getValue() : null;
    }
}

