/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.impl.VirtualFileBoundJavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J.\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleResolver", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "diagnosticFor", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "targetClassOrPackage", "Lorg/jetbrains/kotlin/descriptors/ClassOrPackageFragmentDescriptor;", "originalDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;", "fileFromOurModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "findVirtualFile", "descriptor", "ClassifierUsage", "frontend.java"})
public final class JvmModuleAccessibilityChecker
implements CallChecker {
    private final JavaModuleResolver moduleResolver;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        block1: {
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object descriptor2 = resolvedCall2.getResultingDescriptor();
            ClassOrPackageFragmentDescriptor classOrPackageFragmentDescriptor = DescriptorUtils.getParentOfType((DeclarationDescriptor)descriptor2, ClassOrPackageFragmentDescriptor.class);
            if (classOrPackageFragmentDescriptor == null) {
                return;
            }
            ClassOrPackageFragmentDescriptor targetDescriptor = classOrPackageFragmentDescriptor;
            KtFile ktFile = DescriptorToSourceUtils.getContainingFile(context.getScope().getOwnerDescriptor());
            VirtualFile fileFromOurModule = ktFile != null ? ktFile.getVirtualFile() : null;
            ClassOrPackageFragmentDescriptor classOrPackageFragmentDescriptor2 = targetDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)classOrPackageFragmentDescriptor2, (String)"targetDescriptor");
            Diagnostic diagnostic = this.diagnosticFor(classOrPackageFragmentDescriptor2, (DeclarationDescriptorWithSource)descriptor2, fileFromOurModule, reportOn);
            if (diagnostic == null) break block1;
            Diagnostic diagnostic2 = diagnostic;
            BindingTrace bindingTrace = context.getTrace();
            Diagnostic p1 = diagnostic2;
            bindingTrace.report(p1);
        }
    }

    private final Diagnostic diagnosticFor(ClassOrPackageFragmentDescriptor targetClassOrPackage, DeclarationDescriptorWithSource originalDescriptor, VirtualFile fileFromOurModule, PsiElement reportOn) {
        Diagnostic diagnostic;
        JavaModuleResolver.AccessError diagnostic2;
        VirtualFile virtualFile2 = this.findVirtualFile(targetClassOrPackage, originalDescriptor);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile referencedFile = virtualFile2;
        PackageFragmentDescriptor packageFragmentDescriptor = DescriptorUtils.getParentOfType(targetClassOrPackage, PackageFragmentDescriptor.class, false);
        FqName referencedPackageFqName = packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null;
        JavaModuleResolver.AccessError accessError = diagnostic2 = this.moduleResolver.checkAccessibility(fileFromOurModule, referencedFile, referencedPackageFqName);
        if (accessError instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule) {
            diagnostic = ErrorsJvm.JAVA_MODULE_DOES_NOT_READ_UNNAMED_MODULE.on(reportOn);
        } else if (accessError instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadModule) {
            diagnostic = ErrorsJvm.JAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE.on(reportOn, ((JavaModuleResolver.AccessError.ModuleDoesNotReadModule)diagnostic2).getDependencyModuleName());
        } else if (accessError instanceof JavaModuleResolver.AccessError.ModuleDoesNotExportPackage) {
            String string = ((JavaModuleResolver.AccessError.ModuleDoesNotExportPackage)diagnostic2).getDependencyModuleName();
            FqName fqName2 = referencedPackageFqName;
            if (fqName2 == null) {
                Intrinsics.throwNpe();
            }
            diagnostic = ErrorsJvm.JAVA_MODULE_DOES_NOT_EXPORT_PACKAGE.on(reportOn, string, fqName2.asString());
        } else {
            diagnostic = null;
        }
        return diagnostic;
    }

    private final VirtualFile findVirtualFile(ClassOrPackageFragmentDescriptor descriptor2, DeclarationDescriptorWithSource originalDescriptor) {
        PsiElement psiElement2;
        SourceElement source = descriptor2.getSource();
        SourceElement sourceElement = source;
        if (sourceElement instanceof KotlinJvmBinarySourceElement) {
            VirtualFileKotlinClass virtualFileKotlinClass;
            KotlinJvmBinaryClass kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            if (!(kotlinJvmBinaryClass instanceof VirtualFileKotlinClass)) {
                kotlinJvmBinaryClass = null;
            }
            if ((virtualFileKotlinClass = (VirtualFileKotlinClass)kotlinJvmBinaryClass) != null && (virtualFileKotlinClass = virtualFileKotlinClass.getFile()) != null) {
                VirtualFileKotlinClass virtualFileKotlinClass2;
                VirtualFileKotlinClass it = virtualFileKotlinClass2 = virtualFileKotlinClass;
                return it;
            }
        } else if (sourceElement instanceof JavaSourceElement) {
            VirtualFileBoundJavaClass virtualFileBoundJavaClass;
            JavaElement javaElement = ((JavaSourceElement)source).getJavaElement();
            if (!(javaElement instanceof VirtualFileBoundJavaClass)) {
                javaElement = null;
            }
            if ((virtualFileBoundJavaClass = (VirtualFileBoundJavaClass)javaElement) != null && (virtualFileBoundJavaClass = virtualFileBoundJavaClass.getVirtualFile()) != null) {
                VirtualFileBoundJavaClass virtualFileBoundJavaClass2;
                VirtualFileBoundJavaClass it = virtualFileBoundJavaClass2 = virtualFileBoundJavaClass;
                return it;
            }
        } else if (sourceElement instanceof KotlinJvmBinaryPackageSourceElement && originalDescriptor instanceof DeserializedMemberDescriptor) {
            VirtualFileKotlinClass virtualFileKotlinClass;
            KotlinJvmBinaryClass kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedMemberDescriptor)originalDescriptor);
            if (!(kotlinJvmBinaryClass instanceof VirtualFileKotlinClass)) {
                kotlinJvmBinaryClass = null;
            }
            if ((virtualFileKotlinClass = (VirtualFileKotlinClass)kotlinJvmBinaryClass) != null && (virtualFileKotlinClass = virtualFileKotlinClass.getFile()) != null) {
                VirtualFileKotlinClass virtualFileKotlinClass3;
                VirtualFileKotlinClass it = virtualFileKotlinClass3 = virtualFileKotlinClass;
                return it;
            }
        }
        if ((psiElement2 = KotlinSourceElementKt.getPsi(source)) != null && (psiElement2 = psiElement2.getContainingFile()) != null && (psiElement2 = psiElement2.getVirtualFile()) != null) {
            SourceElement it = sourceElement = psiElement2;
            return it;
        }
        Object object = originalDescriptor;
        return object != null && (object = object.getSource()) != null && (object = KotlinSourceElementKt.getPsi((SourceElement)object)) != null && (object = object.getContainingFile()) != null ? object.getVirtualFile() : null;
    }

    public JvmModuleAccessibilityChecker(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.moduleResolver = JavaModuleResolver.SERVICE.getInstance(project);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "(Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker;)V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lcom/intellij/psi/PsiElement;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend.java"})
    public final class ClassifierUsage
    implements ClassifierUsageChecker {
        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element3, @NotNull LanguageVersionSettings languageVersionSettings) {
            block6: {
                ClassDescriptor expandedClass;
                ClassifierDescriptor classifierDescriptor;
                ClassifierDescriptor classifierDescriptor2;
                VirtualFile virtualFile2;
                block5: {
                    Diagnostic diagnostic;
                    Intrinsics.checkParameterIsNotNull((Object)targetDescriptor, (String)"targetDescriptor");
                    Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
                    virtualFile2 = element3.getContainingFile().getVirtualFile();
                    classifierDescriptor2 = targetDescriptor;
                    if (!(classifierDescriptor2 instanceof ClassDescriptor)) break block5;
                    Diagnostic diagnostic2 = JvmModuleAccessibilityChecker.this.diagnosticFor((ClassOrPackageFragmentDescriptor)((Object)targetDescriptor), targetDescriptor, virtualFile2, element3);
                    if (diagnostic2 == null) break block6;
                    Diagnostic p1 = diagnostic = diagnostic2;
                    trace.report(p1);
                    break block6;
                }
                if (!(classifierDescriptor2 instanceof TypeAliasDescriptor)) break block6;
                ClassOrPackageFragmentDescriptor containingClassOrPackage = DescriptorUtils.getParentOfType(targetDescriptor, ClassOrPackageFragmentDescriptor.class);
                if (containingClassOrPackage != null) {
                    Diagnostic diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor(containingClassOrPackage, targetDescriptor, virtualFile2, element3);
                    if (diagnostic != null) {
                        Diagnostic p1;
                        Diagnostic p12 = p1 = diagnostic;
                        trace.report(p12);
                    }
                }
                if (!((classifierDescriptor = ((TypeAliasDescriptor)targetDescriptor).getExpandedType().getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                if ((expandedClass = (ClassDescriptor)classifierDescriptor) != null) {
                    Diagnostic diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor(expandedClass, expandedClass, virtualFile2, element3);
                    if (diagnostic != null) {
                        Diagnostic diagnostic3;
                        Diagnostic p1 = diagnostic3 = diagnostic;
                        trace.report(p1);
                    }
                }
            }
        }
    }
}

