/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.lang.xpath.xslt.XsltConfig;
import org.intellij.lang.xpath.xslt.impl.XsltFormattingModelBuilder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="XSLT-Support.Configuration", storages={@Storage(value="other.xml")})
class XsltConfigImpl
extends XsltConfig
implements PersistentStateComponent<XsltConfigImpl>,
ApplicationComponent {
    public boolean SHOW_LINKED_FILES = true;

    XsltConfigImpl() {
    }

    @Nullable
    public XsltConfigImpl getState() {
        return this;
    }

    public void loadState(XsltConfigImpl state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public void initComponent() {
        Language xmlLang = StdFileTypes.XML.getLanguage();
        XsltFormattingModelBuilder builder = new XsltFormattingModelBuilder((FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(xmlLang));
        LanguageFormatting.INSTANCE.addExplicitExtension((Object)xmlLang, (Object)builder);
        try {
            AnAction introduceParameter = ActionManager.getInstance().getAction("IntroduceParameter");
            if (introduceParameter != null) {
                introduceParameter.setInjectedContext(true);
            }
        }
        catch (Exception e) {
            Logger.getInstance((String)XsltConfigImpl.class.getName()).error((Throwable)e);
        }
    }

    @Override
    public boolean isShowLinkedFiles() {
        return this.SHOW_LINKED_FILES;
    }

    public static class UIImpl
    extends JPanel
    implements SearchableConfigurable {
        private final JCheckBox myShowLinkedFiles;
        private final XsltConfigImpl myConfig;

        public UIImpl(XsltConfigImpl config) {
            this.myConfig = config;
            this.setLayout(new BoxLayout(this, 1));
            this.myShowLinkedFiles = new JCheckBox("Show Associated Files in Project View");
            this.myShowLinkedFiles.setMnemonic('A');
            this.myShowLinkedFiles.setSelected(this.myConfig.SHOW_LINKED_FILES);
            this.add(this.myShowLinkedFiles);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(Box.createVerticalGlue(), "Center");
            JPanel panel = new JPanel(new FlowLayout(1));
            jPanel.add((Component)panel, "South");
            jPanel.setAlignmentX(0.0f);
            this.add(jPanel);
        }

        @Nls
        public String getDisplayName() {
            return "XSLT";
        }

        @NotNull
        @NonNls
        public String getHelpTopic() {
            if ("settings.xslt" == null) {
                UIImpl.$$$reportNull$$$0(0);
            }
            return "settings.xslt";
        }

        public void disposeUIResources() {
        }

        public JComponent createComponent() {
            return this;
        }

        public boolean isModified() {
            return this.myConfig.SHOW_LINKED_FILES != this.myShowLinkedFiles.isSelected();
        }

        public void apply() {
            boolean oldValue = this.myConfig.SHOW_LINKED_FILES;
            this.myConfig.SHOW_LINKED_FILES = this.myShowLinkedFiles.isSelected();
            if (oldValue != this.myConfig.SHOW_LINKED_FILES) {
                Project[] projects;
                for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                    ProjectView.getInstance((Project)project).refresh();
                }
            }
        }

        public void reset() {
            this.myShowLinkedFiles.setSelected(this.myConfig.SHOW_LINKED_FILES);
        }

        @NotNull
        public String getId() {
            String string = this.getHelpTopic();
            if (string == null) {
                UIImpl.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/intellij/lang/xpath/xslt/impl/XsltConfigImpl$UIImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHelpTopic";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

