/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ImportLayoutPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;

public class PackagePanel {
    private static void addPackageToPackages(JBTable table, PackageEntryTable list2) {
        int selected = table.getSelectedRow() + 1;
        if (selected < 0) {
            selected = list2.getEntryCount();
        }
        PackageEntry entry = new PackageEntry(false, "", true);
        list2.insertEntryAt(entry, selected);
        ImportLayoutPanel.refreshTableModel(selected, table);
    }

    private static void removeEntryFromPackages(JBTable table, PackageEntryTable list2) {
        int selected = table.getSelectedRow();
        if (selected < 0) {
            return;
        }
        TableUtil.stopEditing((JTable)table);
        list2.removeEntryAt(selected);
        AbstractTableModel model = (AbstractTableModel)table.getModel();
        model.fireTableRowsDeleted(selected, selected);
        if (selected >= list2.getEntryCount()) {
            --selected;
        }
        if (selected >= 0) {
            table.setRowSelectionInterval(selected, selected);
        }
    }

    public static JPanel createPackagesPanel(final JBTable packageTable, final PackageEntryTable packageList) {
        JPanel panel2 = ToolbarDecorator.createDecorator((JTable)packageTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PackagePanel.addPackageToPackages(packageTable, packageList);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PackagePanel.removeEntryFromPackages(packageTable, packageList);
            }
        }).disableUpDownActions().setPreferredSize(new Dimension(-1, 100)).createPanel();
        UIUtil.addBorder((JComponent)panel2, (Border)IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.packages.to.use.import.with", (Object[])new Object[0]), (boolean)false));
        return panel2;
    }
}

