/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.util;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntObjectMap<V> {
    @NotNull
    private Object[] myData;
    private int myMaxUsed = -1;
    private int mySize;

    public IntObjectMap() {
        this(16);
    }

    public IntObjectMap(int initialCapacity) {
        this.myData = new Object[initialCapacity];
    }

    @Nullable
    public V get(int key2) {
        if (key2 < 0 || key2 >= this.myData.length) {
            return null;
        }
        return (V)this.myData[key2];
    }

    public void set(int key2, @NotNull V value2) {
        if (value2 == null) {
            IntObjectMap.$$$reportNull$$$0(0);
        }
        if (key2 >= this.myData.length) {
            int newCapacity;
            for (newCapacity = this.myData.length; newCapacity <= key2; newCapacity <<= 1) {
            }
            this.myData = Arrays.copyOf(this.myData, newCapacity);
        }
        if (this.myData[key2] == null) {
            ++this.mySize;
        }
        this.myData[key2] = value2;
        this.myMaxUsed = Math.max(this.myMaxUsed, key2);
    }

    public void remove(int key2) {
        if (key2 < 0 || key2 >= this.myData.length) {
            return;
        }
        if (this.myData[key2] != null) {
            --this.mySize;
        }
        this.myData[key2] = null;
        if (key2 == this.myMaxUsed) {
            for (int i = this.myMaxUsed; i >= 0; --i) {
                if (this.myData[i] == null) continue;
                this.myMaxUsed = i;
                return;
            }
            this.myMaxUsed = -1;
        }
    }

    public void clear() {
        this.myData = new Object[this.myData.length];
        this.myMaxUsed = -1;
        this.mySize = 0;
    }

    public void shiftKeys(int from, int shift) {
        int i;
        if (shift == 0 || from > this.myMaxUsed) {
            return;
        }
        int newEnd = this.myMaxUsed + shift;
        if (newEnd >= this.myData.length) {
            int newCapacity;
            int minCapacity = newEnd + 1;
            for (newCapacity = this.myData.length; newCapacity < minCapacity; newCapacity <<= 1) {
            }
            this.myData = Arrays.copyOf(this.myData, newCapacity);
        }
        int effectiveFrom = from;
        while (this.myData[effectiveFrom] == null) {
            if (++effectiveFrom < this.myData.length) continue;
            return;
        }
        System.arraycopy(this.myData, effectiveFrom, this.myData, effectiveFrom + shift, this.myMaxUsed - effectiveFrom + 1);
        if (shift > 0) {
            int max = effectiveFrom + shift;
            for (i = effectiveFrom; i < max; ++i) {
                this.myData[i] = null;
            }
        } else {
            int min = this.myMaxUsed + shift;
            for (i = this.myMaxUsed; i > min; --i) {
                this.myData[i] = null;
            }
        }
        this.myMaxUsed += shift;
    }

    public int size() {
        return this.mySize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/application/options/codeStyle/arrangement/util/IntObjectMap", "set"));
    }
}

