/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class BuildContentManagerImpl
implements BuildContentManager,
ContentManagerListener {
    public static final String Build = "Build";
    public static final String Sync = "Sync";
    public static final String Run = "Run";
    public static final String Debug = "Debug";
    private static final String[] ourPresetOrder = new String[]{"Build", "Sync", "Run", "Debug"};
    private Project myProject;
    private ToolWindow myToolWindow;
    private final List<Runnable> myPostponedRunnables = new ArrayList<Runnable>();
    private Map<Content, Pair<Icon, AtomicInteger>> liveContentsMap = ContainerUtil.newConcurrentMap();

    public BuildContentManagerImpl(Project project2) {
        this.init(project2);
    }

    private void init(Project project2) {
        this.myProject = project2;
        if (project2.isDefault()) {
            return;
        }
        StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).registerToolWindow(ToolWindowId.BUILD, true, ToolWindowAnchor.BOTTOM, (Disposable)project2, true);
            toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
            toolWindow.setIcon(AllIcons.Actions.Compile);
            toolWindow.setAvailable(true, null);
            toolWindow.hide(null);
            this.myToolWindow = toolWindow;
            this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)this);
            for (Runnable postponedRunnable : this.myPostponedRunnables) {
                postponedRunnable.run();
            }
            this.myPostponedRunnables.clear();
        });
    }

    public Promise<Void> runWhenInitialized(Runnable runnable2) {
        if (this.myToolWindow != null) {
            runnable2.run();
            return Promises.resolvedPromise(null);
        }
        AsyncPromise promise2 = new AsyncPromise();
        this.myPostponedRunnables.add(() -> {
            if (!this.myProject.isDisposed()) {
                runnable2.run();
                promise2.setResult(null);
            }
        });
        return promise2;
    }

    @Override
    public void addContent(Content content) {
        this.runWhenInitialized(() -> {
            if (!this.myToolWindow.isAvailable()) {
                this.myToolWindow.setAvailable(true, null);
            }
            ContentManager contentManager = this.myToolWindow.getContentManager();
            String name2 = content.getTabName();
            String category = StringUtil.trimEnd((String)((String)StringUtil.split((String)name2, (String)" ").get(0)), (char)':');
            int idx = -1;
            for (int i = 0; i < ourPresetOrder.length; ++i) {
                String s = ourPresetOrder[i];
                if (!s.equals(category)) continue;
                idx = i;
                break;
            }
            Content[] existingContents = contentManager.getContents();
            if (idx != -1) {
                Content[] existingCategoriesNames = MultiMap.createSmart();
                Content[] contentArray = existingContents;
                int n = contentArray.length;
                for (int i = 0; i < n; ++i) {
                    Content existingContent = contentArray[i];
                    String tabName = existingContent.getTabName();
                    existingCategoriesNames.putValue((Object)StringUtil.trimEnd((String)((String)StringUtil.split((String)tabName, (String)" ").get(0)), (char)':'), (Object)tabName);
                }
                int place = 0;
                for (int i = 0; i < idx; ++i) {
                    String key2 = ourPresetOrder[i];
                    Collection tabNames = existingCategoriesNames.get((Object)key2);
                    if (key2.equals(category)) continue;
                    place += tabNames.size();
                }
                contentManager.addContent(content, place);
            } else {
                contentManager.addContent(content);
            }
            for (Content existingContent : existingContents) {
                existingContent.setDisplayName(existingContent.getTabName());
            }
            String tabName = content.getTabName();
            this.updateTabDisplayName(content, tabName);
        });
    }

    public void updateTabDisplayName(Content content, String tabName) {
        this.runWhenInitialized(() -> {
            String displayName;
            ContentManager contentManager = this.myToolWindow.getContentManager();
            Content firstContent = contentManager.getContent(0);
            assert (firstContent != null);
            if (!Build.equals(firstContent.getTabName())) {
                if (contentManager.getContentCount() > 1) {
                    this.setIdLabelHidden(false);
                    displayName = tabName;
                } else {
                    displayName = "Build: " + tabName;
                }
            } else {
                displayName = tabName;
                this.setIdLabelHidden(true);
            }
            if (!displayName.equals(content.getDisplayName())) {
                content.setTabName(tabName);
                content.setDisplayName(displayName);
            }
        });
    }

    @Override
    public void removeContent(Content content) {
        this.runWhenInitialized(() -> {
            ContentManager contentManager = this.myToolWindow.getContentManager();
            if (contentManager != null && !contentManager.isDisposed()) {
                contentManager.removeContent(content, true);
            }
        });
    }

    @Override
    public ActionCallback setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus, boolean activate, @Nullable Runnable activationCallback) {
        if (content == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(0);
        }
        ActionCallback actionCallback = new ActionCallback();
        Disposer.register((Disposable)content, (Disposable)actionCallback);
        this.runWhenInitialized(() -> {
            if (content == null) {
                BuildContentManagerImpl.$$$reportNull$$$0(8);
            }
            if (!this.myToolWindow.isAvailable()) {
                actionCallback.setRejected();
                return;
            }
            if (activate) {
                this.myToolWindow.show(activationCallback);
            }
            ActionCallback callback = this.myToolWindow.getContentManager().setSelectedContent(content, requestFocus, forcedFocus, false);
            callback.notify(actionCallback);
        });
        return actionCallback;
    }

    @Override
    public Content addTabbedContent(@NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, @Nullable Icon icon, @Nullable Disposable childDisposable) {
        TabbedContent tabbedContent;
        if (contentComponent == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(1);
        }
        if (groupPrefix == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(2);
        }
        if (tabName == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(3);
        }
        ContentManager contentManager = this.myToolWindow.getContentManager();
        ContentUtilEx.addTabbedContent(contentManager, contentComponent, groupPrefix, tabName, false, childDisposable);
        Content content = contentManager.findContent(ContentUtilEx.getFullName(groupPrefix, tabName));
        if (icon != null && (tabbedContent = ContentUtilEx.findTabbedContent(contentManager, groupPrefix)) != null) {
            tabbedContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            tabbedContent.setIcon(icon);
        }
        return content;
    }

    public void startBuildNotified(@NotNull Content content) {
        if (content == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(4);
        }
        this.runWhenInitialized(() -> {
            if (content == null) {
                BuildContentManagerImpl.$$$reportNull$$$0(7);
            }
            Pair pair2 = this.liveContentsMap.computeIfAbsent(content, c -> Pair.pair((Object)c.getIcon(), (Object)new AtomicInteger(0)));
            ((AtomicInteger)pair2.second).incrementAndGet();
            content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            content.setIcon(ExecutionUtil.getLiveIndicator((Icon)((Icon)pair2.first)));
            JComponent component = content.getComponent();
            if (component != null) {
                component.invalidate();
            }
            this.myToolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)AllIcons.Actions.Compile));
        });
    }

    public void finishBuildNotified(@NotNull Content content) {
        if (content == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(5);
        }
        this.runWhenInitialized(() -> {
            Pair<Icon, AtomicInteger> pair2;
            if (content == null) {
                BuildContentManagerImpl.$$$reportNull$$$0(6);
            }
            if ((pair2 = this.liveContentsMap.get(content)) != null && ((AtomicInteger)pair2.second).decrementAndGet() == 0) {
                content.setIcon((Icon)pair2.first);
                if (pair2.first == null) {
                    content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.FALSE);
                }
                this.liveContentsMap.remove(content);
                if (this.liveContentsMap.isEmpty()) {
                    this.myToolWindow.setIcon(AllIcons.Actions.Compile);
                }
            }
        });
    }

    private void setIdLabelHidden(boolean hide) {
        JComponent component = this.myToolWindow.getComponent();
        Object oldValue = component.getClientProperty("HideIdLabel");
        String newValue = hide ? "true" : null;
        component.putClientProperty("HideIdLabel", newValue);
        if (this.myToolWindow instanceof ToolWindowImpl) {
            ((ToolWindowImpl)this.myToolWindow).getContentUI().propertyChange(new PropertyChangeEvent(this, "HideIdLabel", oldValue, newValue));
        }
    }

    public void contentAdded(ContentManagerEvent event) {
    }

    public void contentRemoved(ContentManagerEvent event) {
        ContentManager contentManager = this.myToolWindow.getContentManager();
        if (contentManager.getContentCount() == 0) {
            this.myToolWindow.setAvailable(false, null);
        }
    }

    public void contentRemoveQuery(ContentManagerEvent event) {
    }

    public void selectionChanged(ContentManagerEvent event) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/build/BuildContentManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedContent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addTabbedContent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startBuildNotified";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "finishBuildNotified";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$finishBuildNotified$8";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$startBuildNotified$7";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setSelectedContent$5";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

