/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildConsoleView;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.CompositeView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.actions.PinActiveTabAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildView
extends CompositeView<BuildConsoleView, ComponentContainer>
implements DataProvider {
    private final ComponentContainer myComponentContainer;
    private final StartBuildEvent myEvent;

    public BuildView(Project project2, ComponentContainer componentContainer, StartBuildEvent event, String selectionStateKey, boolean isConsoleEnabledByDefault) {
        super(new BuildTreeConsoleView(project2, new DefaultBuildDescriptor(event.getId(), event.getBuildTitle(), event.getWorkingDir(), event.getEventTime())), componentContainer, selectionStateKey, !isConsoleEnabledByDefault);
        this.myComponentContainer = componentContainer;
        this.myEvent = event;
    }

    @Override
    @NotNull
    public AnAction[] createConsoleActions() {
        DefaultActionGroup rerunActionGroup = new DefaultActionGroup();
        StopProcessAction stopAction = null;
        if (this.myEvent.getProcessHandler() != null) {
            stopAction = new StopProcessAction("Stop", "Stop", this.myEvent.getProcessHandler());
            AnAction generalStopAction = ActionManager.getInstance().getAction("Stop");
            if (generalStopAction != null) {
                stopAction.copyFrom(generalStopAction);
                stopAction.registerCustomShortcutSet(generalStopAction.getShortcutSet(), this);
            }
        }
        DefaultActionGroup consoleActionGroup = new DefaultActionGroup(){

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setVisible(!BuildView.this.isPrimaryViewEnabled());
            }
        };
        if (this.myComponentContainer instanceof BuildConsoleView) {
            AnAction[] consoleActions;
            for (AnAction anAction : consoleActions = ((BuildConsoleView)this.myComponentContainer).createConsoleActions()) {
                if (anAction instanceof StopAction) {
                    if (stopAction != null) continue;
                    stopAction = anAction;
                    continue;
                }
                if (anAction instanceof FakeRerunAction || anAction instanceof PinActiveTabAction || anAction instanceof CloseAction) continue;
                consoleActionGroup.add(anAction);
            }
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (AnAction anAction : this.myEvent.getRestartActions()) {
            rerunActionGroup.add(anAction);
        }
        if (stopAction != null) {
            rerunActionGroup.add((AnAction)stopAction);
        }
        actionGroup.add((AnAction)rerunActionGroup);
        actionGroup.addSeparator();
        AnAction[] actions = super.createConsoleActions();
        actionGroup.addAll(actions);
        if (actions.length > 0) {
            actionGroup.addSeparator();
        }
        AnAction[] anActionArray = new AnAction[]{actionGroup, consoleActionGroup};
        if (anActionArray == null) {
            BuildView.$$$reportNull$$$0(0);
        }
        return anActionArray;
    }

    @Override
    @Nullable
    public Object getData(String dataId) {
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        if (LangDataKeys.RUN_PROFILE.is(dataId)) {
            ExecutionEnvironment environment = this.myEvent.getExecutionEnvironment();
            return environment == null ? null : environment.getRunProfile();
        }
        if (LangDataKeys.EXECUTION_ENVIRONMENT.is(dataId)) {
            return this.myEvent.getExecutionEnvironment();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/build/BuildView", "createConsoleActions"));
    }
}

