/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeView<S extends ComponentContainer, T extends ComponentContainer>
extends JPanel
implements ComponentContainer,
DataProvider {
    private static final String PRIMARY_PANEL = "PRIMARY_PANEL";
    private static final String SECONDARY_PANEL = "SECONDARY_PANEL";
    @NotNull
    private final S myPrimaryView;
    @NotNull
    private final T mySecondaryView;
    private final String mySelectionStateKey;
    private final boolean myPrimaryViewEnabledByDefault;
    private boolean myPrimary;
    @NotNull
    private final SwitchViewAction mySwitchViewAction;

    public CompositeView(@NotNull S primaryView, @NotNull T secondaryView, String selectionStateKey, boolean isPrimaryViewEnabledByDefault) {
        if (primaryView == null) {
            CompositeView.$$$reportNull$$$0(0);
        }
        if (secondaryView == null) {
            CompositeView.$$$reportNull$$$0(1);
        }
        super(new CardLayout());
        this.myPrimaryView = primaryView;
        this.mySecondaryView = secondaryView;
        this.mySelectionStateKey = selectionStateKey;
        this.add((Component)this.myPrimaryView.getComponent(), PRIMARY_PANEL);
        this.add((Component)this.mySecondaryView.getComponent(), SECONDARY_PANEL);
        this.mySwitchViewAction = new SwitchViewAction();
        this.myPrimary = true;
        this.myPrimaryViewEnabledByDefault = isPrimaryViewEnabledByDefault;
        this.enableView(this.getStoredState());
        Disposer.register((Disposable)this, this.myPrimaryView);
        Disposer.register((Disposable)this, this.mySecondaryView);
    }

    public void enableView(boolean primary) {
        if (primary != this.myPrimary) {
            CardLayout cl = (CardLayout)this.getLayout();
            cl.show(this, primary ? PRIMARY_PANEL : SECONDARY_PANEL);
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getView(primary).getPreferredFocusableComponent(), true));
        this.myPrimary = primary;
    }

    public boolean isPrimaryViewEnabled() {
        return this.myPrimary;
    }

    @NotNull
    public S getPrimaryView() {
        S s = this.myPrimaryView;
        if (s == null) {
            CompositeView.$$$reportNull$$$0(2);
        }
        return s;
    }

    @NotNull
    public T getSecondaryView() {
        T t = this.mySecondaryView;
        if (t == null) {
            CompositeView.$$$reportNull$$$0(3);
        }
        return t;
    }

    public ComponentContainer getView(boolean primary) {
        return primary ? this.getPrimaryView() : this.getSecondaryView();
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        ConsoleHistoryController controller;
        ArrayList actions = ContainerUtil.newArrayList();
        actions.add(this.mySwitchViewAction);
        LanguageConsoleView langConsole = (LanguageConsoleView)ContainerUtil.findInstance(Arrays.asList(this.myPrimaryView, this.mySecondaryView), LanguageConsoleView.class);
        ConsoleHistoryController consoleHistoryController = controller = langConsole != null ? ConsoleHistoryController.getController(langConsole) : null;
        if (controller != null) {
            actions.add(controller.getBrowseHistory());
        }
        AnAction[] anActionArray = (AnAction[])ArrayUtil.toObjectArray((Collection)actions, AnAction.class);
        if (anActionArray == null) {
            CompositeView.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    public JComponent getComponent() {
        return this;
    }

    public JComponent getPreferredFocusableComponent() {
        return this;
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        ComponentContainer consoleView = this.getView(this.isPrimaryViewEnabled());
        return consoleView instanceof DataProvider ? ((DataProvider)consoleView).getData(dataId) : null;
    }

    private void setStoredState(boolean primary) {
        if (this.mySelectionStateKey != null) {
            PropertiesComponent.getInstance().setValue(this.mySelectionStateKey, primary, this.myPrimaryViewEnabledByDefault);
        }
    }

    private boolean getStoredState() {
        if (this.mySelectionStateKey == null) {
            return false;
        }
        return PropertiesComponent.getInstance().getBoolean(this.mySelectionStateKey, this.myPrimaryViewEnabledByDefault);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryView";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/CompositeView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/CompositeView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SwitchViewAction
    extends ToggleAction
    implements DumbAware {
        public SwitchViewAction() {
            super("Toggle view", null, AllIcons.Actions.ChangeView);
        }

        public boolean isSelected(AnActionEvent event) {
            return !CompositeView.this.isPrimaryViewEnabled();
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            CompositeView.this.enableView(!flag);
            CompositeView.this.setStoredState(!flag);
            ApplicationManager.getApplication().invokeLater(() -> this.update(event));
        }
    }
}

