/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.ExecutionNodeProgressAnimator;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.NotificationData;
import com.intellij.build.events.SkippedResult;
import com.intellij.build.events.impl.FailureImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionNode
extends CachingSimpleNode {
    private final List<ExecutionNode> myChildrenList = ContainerUtil.newSmartList();
    private long startTime;
    private long endTime;
    @Nullable
    private String myTitle;
    @Nullable
    private String myTooltip;
    @Nullable
    private String myHint;
    @Nullable
    private EventResult myResult;
    private boolean myAutoExpandNode;
    @Nullable
    private Navigatable myNavigatable;
    @Nullable
    private NullableLazyValue<Icon> myPreferredIconValue;
    private final AtomicInteger myErrors = new AtomicInteger();
    private final AtomicInteger myWarnings = new AtomicInteger();

    public ExecutionNode(Project aProject, ExecutionNode parentNode) {
        super(aProject, (NodeDescriptor)parentNode);
    }

    protected SimpleNode[] buildChildren() {
        return this.myChildrenList.size() == 0 ? NO_CHILDREN : (SimpleNode[])ContainerUtil.toArray(this.myChildrenList, (Object[])new ExecutionNode[this.myChildrenList.size()]);
    }

    protected void update(PresentationData presentation) {
        this.setIcon(this.getCurrentIcon());
        presentation.setPresentableText(this.myName);
        presentation.setIcon(this.getIcon());
        if (this.myTitle != null) {
            presentation.addText(this.myTitle + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        String hint = this.getCurrentHint();
        if (this.myTitle != null || hint != null) {
            presentation.addText(this.myName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (hint != null) {
            presentation.addText("  " + hint, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.myTooltip != null) {
            presentation.setTooltip(this.myTooltip);
        }
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name2) {
        this.myName = name2;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(@Nullable String title) {
        this.myTitle = title;
    }

    @Nullable
    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(@Nullable String tooltip) {
        this.myTooltip = tooltip;
    }

    @Nullable
    public String getHint() {
        return this.myHint;
    }

    public void setHint(@Nullable String hint) {
        this.myHint = hint;
    }

    public void add(ExecutionNode node) {
        this.myChildrenList.add(node);
        this.cleanUpCache();
    }

    public void add(int index, ExecutionNode node) {
        this.myChildrenList.add(index, node);
        this.cleanUpCache();
    }

    void removeChildren() {
        this.myChildrenList.clear();
        this.cleanUpCache();
    }

    @Nullable
    public String getDuration() {
        if (this.startTime == this.endTime) {
            return null;
        }
        if (this.isRunning()) {
            long duration = this.startTime == 0L ? 0L : System.currentTimeMillis() - this.startTime;
            return "Running for " + StringUtil.formatDuration((long)duration);
        }
        return this.isSkipped() ? null : StringUtil.formatDuration((long)(this.endTime - this.startTime));
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean isFailed() {
        return this.myResult instanceof FailureResult;
    }

    public boolean isSkipped() {
        return this.myResult instanceof SkippedResult;
    }

    public boolean isRunning() {
        return this.endTime <= 0L && !this.isSkipped() && !this.isFailed();
    }

    public void setResult(@Nullable EventResult result2) {
        this.myResult = result2;
    }

    @Nullable
    public EventResult getResult() {
        return this.myResult;
    }

    public boolean isAutoExpandNode() {
        return this.myAutoExpandNode;
    }

    public void setAutoExpandNode(boolean autoExpandNode) {
        this.myAutoExpandNode = autoExpandNode;
    }

    public void setNavigatable(@Nullable Navigatable navigatable) {
        this.myNavigatable = navigatable;
    }

    @NotNull
    public List<Navigatable> getNavigatables() {
        if (this.myNavigatable != null) {
            List<Navigatable> list2 = Collections.singletonList(this.myNavigatable);
            if (list2 == null) {
                ExecutionNode.$$$reportNull$$$0(0);
            }
            return list2;
        }
        if (this.myResult == null) {
            List<Navigatable> list3 = Collections.emptyList();
            if (list3 == null) {
                ExecutionNode.$$$reportNull$$$0(1);
            }
            return list3;
        }
        if (this.myResult instanceof FailureResult) {
            SmartList result2 = new SmartList();
            for (Failure failure : ((FailureResult)this.myResult).getFailures()) {
                NotificationData notificationData = ((FailureImpl)failure).getNotificationData();
                if (notificationData == null) continue;
                ContainerUtil.addIfNotNull((Collection)result2, (Object)notificationData.getNavigatable());
            }
            SmartList smartList = result2;
            if (smartList == null) {
                ExecutionNode.$$$reportNull$$$0(2);
            }
            return smartList;
        }
        List<Navigatable> list4 = Collections.emptyList();
        if (list4 == null) {
            ExecutionNode.$$$reportNull$$$0(3);
        }
        return list4;
    }

    public void setIconProvider(final Supplier<Icon> iconProvider) {
        this.myPreferredIconValue = new NullableLazyValue<Icon>(){

            @Nullable
            protected Icon compute() {
                return (Icon)iconProvider.get();
            }
        };
    }

    public void reportChildMessageKind(MessageEvent.Kind kind2) {
        if (kind2 == MessageEvent.Kind.ERROR) {
            this.myErrors.incrementAndGet();
        } else if (kind2 == MessageEvent.Kind.WARNING) {
            this.myWarnings.incrementAndGet();
        }
    }

    private String getCurrentHint() {
        String hint = this.myHint;
        int warnings = this.myWarnings.get();
        int errors = this.myErrors.get();
        if (warnings > 0 || errors > 0) {
            if (hint == null) {
                hint = "";
            }
            hint = hint + (this.getParent() == null ? (this.isRunning() ? "   " : "   with ") : " (");
            if (errors > 0) {
                hint = hint + errors + " " + StringUtil.pluralize((String)"error", (int)errors);
                if (warnings > 0) {
                    hint = hint + ", ";
                }
            }
            if (warnings > 0) {
                hint = hint + warnings + " " + StringUtil.pluralize((String)"warning", (int)warnings);
            }
            if (this.getParent() != null) {
                hint = hint + ")";
            }
        }
        return hint;
    }

    private Icon getCurrentIcon() {
        if (this.myPreferredIconValue != null) {
            return (Icon)this.myPreferredIconValue.getValue();
        }
        if (this.myResult instanceof MessageEventResult) {
            return ExecutionNode.getIcon(((MessageEventResult)this.myResult).getKind());
        }
        return this.isRunning() ? ExecutionNodeProgressAnimator.getCurrentFrame() : (this.isFailed() ? AllIcons.Process.State.RedExcl : (this.isSkipped() ? AllIcons.Process.State.YellowStr : AllIcons.Process.State.GreenOK));
    }

    private static Icon getIcon(MessageEvent.Kind kind2) {
        switch (kind2) {
            case ERROR: {
                return AllIcons.General.Error;
            }
            case WARNING: {
                return AllIcons.General.Warning;
            }
            case INFO: {
                return AllIcons.General.Information;
            }
            case STATISTICS: {
                return AllIcons.General.Mdot_empty;
            }
            case SIMPLE: {
                return AllIcons.General.Mdot_empty;
            }
        }
        return AllIcons.General.Mdot_empty;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/build/ExecutionNode", "getNavigatables"));
    }
}

