/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.output;

import com.intellij.build.FilePosition;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavacOutputParser
implements BuildOutputParser {
    private static final String COMPILER_MESSAGES_GROUP = "Java compiler";
    private static final char COLON = ':';
    private static final String WARNING_PREFIX = "warning:";

    @Override
    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<MessageEvent> messageConsumer) {
        int colonIndex1;
        if (line == null) {
            JavacOutputParser.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            JavacOutputParser.$$$reportNull$$$0(1);
        }
        if (messageConsumer == null) {
            JavacOutputParser.$$$reportNull$$$0(2);
        }
        if ((colonIndex1 = line.indexOf(58)) == 1) {
            colonIndex1 = line.indexOf(58, colonIndex1 + 1);
        }
        if (colonIndex1 >= 0) {
            String part1 = line.substring(0, colonIndex1).trim();
            if (part1.equalsIgnoreCase("error") || part1.equalsIgnoreCase("Caused by")) {
                String text2 = line.substring(colonIndex1 + 1).trim();
                messageConsumer.accept(new MessageEventImpl(reader.getBuildId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP, text2));
                return true;
            }
            if (part1.equalsIgnoreCase("warning")) {
                String text3 = line.substring(colonIndex1 + 1).trim();
                messageConsumer.accept(new MessageEventImpl(reader.getBuildId(), MessageEvent.Kind.WARNING, COMPILER_MESSAGES_GROUP, text3));
                return true;
            }
            if (part1.equalsIgnoreCase("javac")) {
                messageConsumer.accept(new MessageEventImpl(reader.getBuildId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP, line));
                return true;
            }
            int colonIndex2 = line.indexOf(58, colonIndex1 + 1);
            if (colonIndex2 >= 0) {
                File file2 = new File(part1);
                if (!file2.isFile()) {
                    return false;
                }
                try {
                    int column;
                    int lineNumber = Integer.parseInt(line.substring(colonIndex1 + 1, colonIndex2).trim());
                    String text4 = line.substring(colonIndex2 + 1).trim();
                    MessageEvent.Kind kind2 = MessageEvent.Kind.ERROR;
                    if (text4.startsWith(WARNING_PREFIX)) {
                        text4 = text4.substring(WARNING_PREFIX.length()).trim();
                        kind2 = MessageEvent.Kind.WARNING;
                    }
                    if (!file2.getPath().endsWith(".java")) {
                        return false;
                    }
                    List<Object> messageList = ContainerUtil.newArrayList();
                    messageList.add(text4);
                    String prevLine = null;
                    while (true) {
                        String nextLine;
                        if ((nextLine = reader.readLine()) == null) {
                            return false;
                        }
                        if (nextLine.trim().equals("^")) {
                            column = nextLine.indexOf(94);
                            String messageEnd = reader.readLine();
                            while (JavacOutputParser.isMessageEnd(messageEnd)) {
                                messageList.add(messageEnd.trim());
                                messageEnd = reader.readLine();
                            }
                            if (messageEnd == null) break;
                            reader.pushBack();
                            break;
                        }
                        if (prevLine != null) {
                            messageList.add(prevLine);
                        }
                        prevLine = nextLine;
                    }
                    if (column >= 0) {
                        messageList = JavacOutputParser.convertMessages(messageList);
                        String msgText = StringUtil.join((Collection)messageList, (String)SystemProperties.getLineSeparator());
                        messageConsumer.accept(new FileMessageEventImpl(reader.getBuildId(), kind2, COMPILER_MESSAGES_GROUP, msgText, new FilePosition(file2, lineNumber - 1, column)));
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (line.endsWith("java.lang.OutOfMemoryError")) {
            messageConsumer.accept(new MessageEventImpl(reader.getBuildId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP, "Out of memory."));
            return true;
        }
        return false;
    }

    private static void addMessage(@NotNull MessageEvent message2, @NotNull List<MessageEvent> messages) {
        if (message2 == null) {
            JavacOutputParser.$$$reportNull$$$0(3);
        }
        if (messages == null) {
            JavacOutputParser.$$$reportNull$$$0(4);
        }
        boolean duplicatesPrevious = false;
        int messageCount = messages.size();
        if (messageCount > 0) {
            MessageEvent lastMessage = messages.get(messageCount - 1);
            duplicatesPrevious = lastMessage.equals(message2);
        }
        if (!duplicatesPrevious) {
            messages.add(message2);
        }
    }

    @Contract(value="null -> false")
    private static boolean isMessageEnd(@Nullable String line) {
        return line != null && line.length() > 0 && Character.isWhitespace(line.charAt(0));
    }

    @NotNull
    private static List<String> convertMessages(@NotNull List<String> messages) {
        String part1;
        if (messages == null) {
            JavacOutputParser.$$$reportNull$$$0(5);
        }
        if (messages.size() <= 1) {
            List<String> list2 = messages;
            if (list2 == null) {
                JavacOutputParser.$$$reportNull$$$0(6);
            }
            return list2;
        }
        String line0 = messages.get(0);
        String line1 = messages.get(1);
        int colonIndex = line1.indexOf(58);
        if (colonIndex > 0 && "symbol".equals(part1 = line1.substring(0, colonIndex).trim())) {
            String symbol = line1.substring(colonIndex + 1).trim();
            messages.remove(1);
            if (messages.size() >= 2) {
                messages.remove(1);
            }
            messages.set(0, line0 + " " + symbol);
        }
        List<String> list3 = messages;
        if (list3 == null) {
            JavacOutputParser.$$$reportNull$$$0(7);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/output/JavacOutputParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/output/JavacOutputParser";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertMessages";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

