/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoPopupController
implements Disposable {
    public static final Key<Boolean> ALWAYS_AUTO_POPUP = Key.create((String)"Always Show Completion Auto-Popup");
    public static final Key<Boolean> NO_ADS = Key.create((String)"Show Completion Auto-Popup without Ads");
    public static final Key<Boolean> AUTO_POPUP_ON_FOCUS_GAINED = Key.create((String)"Show Completion Auto-Popup On Focus Gained");
    private final Project myProject;
    private final Alarm myAlarm;

    public static AutoPopupController getInstance(Project project2) {
        return (AutoPopupController)ServiceManager.getService((Project)project2, AutoPopupController.class);
    }

    public AutoPopupController(Project project2) {
        this.myProject = project2;
        this.myAlarm = new Alarm((Disposable)this);
        this.setupListeners();
    }

    private void setupListeners() {
        ActionManagerEx.getInstanceEx().addAnActionListener(new AnActionListener(){

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                AutoPopupController.this.cancelAllRequest();
            }

            public void beforeEditorTyping(char c, DataContext dataContext) {
                AutoPopupController.this.cancelAllRequest();
            }

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            }
        }, (Disposable)this);
        IdeEventQueue.getInstance().addActivityListener(() -> this.cancelAllRequest(), this);
    }

    public void autoPopupMemberLookup(Editor editor, @Nullable Condition<PsiFile> condition2) {
        this.autoPopupMemberLookup(editor, CompletionType.BASIC, condition2);
    }

    public void autoPopupMemberLookup(Editor editor, CompletionType completionType, @Nullable Condition<PsiFile> condition2) {
        this.scheduleAutoPopup(editor, completionType, condition2);
    }

    public void scheduleAutoPopup(Editor editor, CompletionType completionType, @Nullable Condition<PsiFile> condition2) {
        boolean alwaysAutoPopup;
        if (ApplicationManager.getApplication().isUnitTestMode() && !CompletionAutoPopupHandler.ourTestingAutopopup) {
            return;
        }
        boolean bl = alwaysAutoPopup = editor != null && Boolean.TRUE.equals(editor.getUserData(ALWAYS_AUTO_POPUP));
        if (!CodeInsightSettings.getInstance().AUTO_POPUP_COMPLETION_LOOKUP && !alwaysAutoPopup) {
            return;
        }
        if (PowerSaveMode.isEnabled()) {
            return;
        }
        if (!CompletionServiceImpl.isPhase(CompletionPhase.CommittingDocuments.class, CompletionPhase.NoCompletion.getClass())) {
            return;
        }
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (currentCompletion != null) {
            currentCompletion.closeAndFinish(true);
        }
        CompletionPhase.CommittingDocuments phase = new CompletionPhase.CommittingDocuments(null, editor);
        CompletionServiceImpl.setCompletionPhase(phase);
        phase.ignoreCurrentDocumentChange();
        AutoPopupController.runTransactionWithEverythingCommitted(this.myProject, () -> {
            if (phase.checkExpired()) {
                return;
            }
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
            if (file2 != null && condition2 != null && !condition2.value((Object)file2)) {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                return;
            }
            CompletionAutoPopupHandler.invokeCompletion(completionType, true, this.myProject, editor, 0, false);
        });
    }

    public void scheduleAutoPopup(Editor editor) {
        this.scheduleAutoPopup(editor, CompletionType.BASIC, null);
    }

    private void addRequest(Runnable request, int delay) {
        Runnable runnable2 = () -> {
            if (!this.myAlarm.isDisposed()) {
                this.myAlarm.addRequest(request, delay);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    private void cancelAllRequest() {
        this.myAlarm.cancelAllRequests();
    }

    public void autoPopupParameterInfo(@NotNull Editor editor, @Nullable PsiElement highlightedMethod) {
        if (editor == null) {
            AutoPopupController.$$$reportNull$$$0(0);
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        if (PowerSaveMode.isEnabled()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (settings.AUTO_POPUP_PARAMETER_INFO) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            PsiFile file2 = documentManager.getPsiFile(editor.getDocument());
            if (file2 == null) {
                return;
            }
            if (!documentManager.isUncommited(editor.getDocument()) && (file2 = documentManager.getPsiFile(InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file2).getDocument())) == null) {
                return;
            }
            Runnable request = () -> {
                if (editor == null) {
                    AutoPopupController.$$$reportNull$$$0(8);
                }
                if (!(this.myProject.isDisposed() || DumbService.isDumb((Project)this.myProject) || editor.isDisposed() || !ApplicationManager.getApplication().isUnitTestMode() && !editor.getComponent().isShowing())) {
                    int lbraceOffset = editor.getCaretModel().getOffset() - 1;
                    try {
                        PsiFile file1 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
                        if (file1 != null) {
                            ShowParameterInfoHandler.invoke(this.myProject, editor, file1, lbraceOffset, highlightedMethod, false, true);
                        }
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                }
            };
            this.addRequest(() -> documentManager.performLaterWhenAllCommitted(request), settings.PARAMETER_INFO_DELAY);
        }
    }

    public void dispose() {
    }

    public static void runTransactionWithEverythingCommitted(@NotNull Project project2, @NotNull Runnable runnable2) {
        if (project2 == null) {
            AutoPopupController.$$$reportNull$$$0(1);
        }
        if (runnable2 == null) {
            AutoPopupController.$$$reportNull$$$0(2);
        }
        TransactionGuard guard = TransactionGuard.getInstance();
        TransactionId id = guard.getContextTransaction();
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)project2);
        pdm.performLaterWhenAllCommitted(() -> {
            if (project2 == null) {
                AutoPopupController.$$$reportNull$$$0(4);
            }
            if (runnable2 == null) {
                AutoPopupController.$$$reportNull$$$0(5);
            }
            guard.submitTransaction((Disposable)project2, id, () -> {
                if (project2 == null) {
                    AutoPopupController.$$$reportNull$$$0(6);
                }
                if (runnable2 == null) {
                    AutoPopupController.$$$reportNull$$$0(7);
                }
                if (pdm.hasUncommitedDocuments()) {
                    AutoPopupController.runTransactionWithEverythingCommitted(project2, runnable2);
                } else {
                    runnable2.run();
                }
            });
        });
    }

    /*
     * WARNING - void declaration
     */
    public void waitForDelayedActions(long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        void unit;
        if (timeUnit == null) {
            AutoPopupController.$$$reportNull$$$0(3);
        }
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < deadline) {
            if (this.myAlarm.isEmpty()) {
                return;
            }
            LockSupport.parkNanos(10000000L);
            UIUtil.dispatchAllInvocationEvents();
        }
        throw new TimeoutException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/AutoPopupController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "autoPopupParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runTransactionWithEverythingCommitted";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForDelayedActions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runTransactionWithEverythingCommitted$6";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$5";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$autoPopupParameterInfo$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

