/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsLineMarkerProvider;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeExternalAnnotationExplicit
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Make External Annotations Explicit" == null) {
            MakeExternalAnnotationExplicit.$$$reportNull$$$0(0);
        }
        return "Make External Annotations Explicit";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        Object[] annotations2;
        PsiElement leaf;
        PsiModifierListOwner owner2;
        if (project2 == null) {
            MakeExternalAnnotationExplicit.$$$reportNull$$$0(1);
        }
        if ((owner2 = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(leaf = file2.findElementAt(editor.getCaretModel().getOffset()))) != null && owner2.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && MakeExternalAnnotationExplicit.isWritable(owner2) && ModuleUtilCore.findModuleForPsiElement((PsiElement)file2) != null && PsiUtil.getLanguageLevel((PsiElement)file2).isAtLeast(LanguageLevel.JDK_1_5) && (annotations2 = this.getAnnotations(project2, owner2)).length > 0) {
            String annos = StringUtil.join((Object[])annotations2, annotation -> {
                PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
                String name2 = nameRef != null ? nameRef.getReferenceName() : annotation.getQualifiedName();
                return "@" + name2 + annotation.getParameterList().getText();
            }, (String)" ");
            this.setText("Insert '" + annos + "'");
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            MakeExternalAnnotationExplicit.$$$reportNull$$$0(2);
        }
        PsiElement leaf = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner owner2 = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(leaf);
        assert (owner2 != null);
        PsiModifierList modifierList = owner2.getModifierList();
        assert (modifierList != null);
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
        assert (module2 != null);
        ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project2);
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(MakeExternalAnnotationExplicit.getFilesToWrite(file2, owner2, externalAnnotationsManager))) {
            return;
        }
        for (PsiAnnotation anno : this.getAnnotations(project2, owner2)) {
            String qname = anno.getQualifiedName();
            assert (qname != null);
            externalAnnotationsManager.deannotate(owner2, qname);
            WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
                if (project2 == null) {
                    MakeExternalAnnotationExplicit.$$$reportNull$$$0(6);
                }
                DumbService.getInstance((Project)project2).withAlternativeResolveEnabled(() -> {
                    if (project2 == null) {
                        MakeExternalAnnotationExplicit.$$$reportNull$$$0(7);
                    }
                    JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(modifierList.addAfter((PsiElement)anno, null));
                });
            });
        }
    }

    public static List<PsiFile> getFilesToWrite(PsiFile file2, PsiModifierListOwner owner2, ExternalAnnotationsManager externalAnnotationsManager) {
        List files = externalAnnotationsManager.findExternalAnnotationsFiles(owner2);
        if (files != null) {
            ArrayList<PsiFile> elements = new ArrayList<PsiFile>(files);
            elements.add(file2);
            return elements;
        }
        return Collections.singletonList(file2);
    }

    @NotNull
    private PsiAnnotation[] getAnnotations(@NotNull Project project2, PsiModifierListOwner owner2) {
        PsiAnnotation[] annotations2;
        if (project2 == null) {
            MakeExternalAnnotationExplicit.$$$reportNull$$$0(3);
        }
        if ((annotations2 = ExternalAnnotationsManager.getInstance((Project)project2).findExternalAnnotations(owner2)) == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                MakeExternalAnnotationExplicit.$$$reportNull$$$0(4);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])Arrays.stream(annotations2).filter(anno -> {
            String qualifiedName = anno.getQualifiedName();
            return qualifiedName != null && facade.findClass(qualifiedName, owner2.getResolveScope()) != null;
        }).toArray(PsiAnnotation[]::new);
        if (psiAnnotationArray == null) {
            MakeExternalAnnotationExplicit.$$$reportNull$$$0(5);
        }
        return psiAnnotationArray;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static boolean isWritable(PsiModifierListOwner owner2) {
        if (owner2 instanceof PsiCompiledElement) {
            return false;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)owner2);
        return vFile != null && vFile.isInLocalFileSystem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/MakeExternalAnnotationExplicit";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/MakeExternalAnnotationExplicit";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$2";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

