/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeInferredAnnotationExplicit
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Make Inferred Annotations Explicit" == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(0);
        }
        return "Make Inferred Annotations Explicit";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        Object[] annotations2;
        PsiElement leaf;
        if (project2 == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(1);
        }
        if ((leaf = file2.findElementAt(editor.getCaretModel().getOffset())) == null) {
            return false;
        }
        PsiModifierListOwner owner2 = (PsiModifierListOwner)ObjectUtils.tryCast((Object)leaf.getParent(), PsiModifierListOwner.class);
        if (owner2 != null && owner2.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && MakeInferredAnnotationExplicit.isWritable(owner2) && ModuleUtilCore.findModuleForPsiElement((PsiElement)file2) != null && PsiUtil.getLanguageLevel((PsiElement)file2).isAtLeast(LanguageLevel.JDK_1_5) && (annotations2 = InferredAnnotationsManager.getInstance((Project)project2).findInferredAnnotations(owner2)).length > 0) {
            String annos = StringUtil.join((Object[])annotations2, annotation -> {
                PsiJavaCodeReferenceElement nameRef = MakeInferredAnnotationExplicit.correctAnnotation(annotation).getNameReferenceElement();
                String name2 = nameRef != null ? nameRef.getReferenceName() : annotation.getQualifiedName();
                return "@" + name2 + annotation.getParameterList().getText();
            }, (String)" ");
            this.setText("Insert '" + annos + "'");
            return true;
        }
        return false;
    }

    private static boolean isWritable(PsiModifierListOwner owner2) {
        if (owner2 instanceof PsiCompiledElement) {
            return false;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)owner2);
        return vFile != null && vFile.isInLocalFileSystem();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(2);
        }
        PsiElement leaf = file2.findElementAt(editor.getCaretModel().getOffset());
        assert (leaf != null);
        PsiModifierListOwner owner2 = (PsiModifierListOwner)ObjectUtils.tryCast((Object)leaf.getParent(), PsiModifierListOwner.class);
        assert (owner2 != null);
        PsiModifierList modifierList = owner2.getModifierList();
        assert (modifierList != null);
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
        assert (module2 != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)owner2)) {
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        for (PsiAnnotation inferred : InferredAnnotationsManager.getInstance((Project)project2).findInferredAnnotations(owner2)) {
            PsiAnnotation toInsert = MakeInferredAnnotationExplicit.correctAnnotation(inferred);
            String qname = toInsert.getQualifiedName();
            assert (qname != null);
            if (facade.findClass(qname, file2.getResolveScope()) == null && !InferNullityAnnotationsAction.addAnnotationsDependency(project2, Collections.singleton(module2), qname, this.getFamilyName())) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
                if (project2 == null) {
                    MakeInferredAnnotationExplicit.$$$reportNull$$$0(7);
                }
                DumbService.getInstance((Project)project2).withAlternativeResolveEnabled(() -> {
                    if (project2 == null) {
                        MakeInferredAnnotationExplicit.$$$reportNull$$$0(8);
                    }
                    JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(modifierList.addAfter((PsiElement)toInsert, null));
                });
            });
        }
    }

    @NotNull
    private static PsiAnnotation correctAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(3);
        }
        Project project2 = annotation.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project2);
        NullableNotNullManager nnnm = NullableNotNullManager.getInstance((Project)project2);
        if ("org.jetbrains.annotations.Nullable".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNullable(), allScope) != null) {
            PsiAnnotation psiAnnotation = facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNullable(), null);
            if (psiAnnotation == null) {
                MakeInferredAnnotationExplicit.$$$reportNull$$$0(4);
            }
            return psiAnnotation;
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNotNull(), allScope) != null) {
            PsiAnnotation psiAnnotation = facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNotNull(), null);
            if (psiAnnotation == null) {
                MakeInferredAnnotationExplicit.$$$reportNull$$$0(5);
            }
            return psiAnnotation;
        }
        PsiAnnotation psiAnnotation = annotation;
        if (psiAnnotation == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(6);
        }
        return psiAnnotation;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/MakeInferredAnnotationExplicit";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/MakeInferredAnnotationExplicit";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "correctAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "correctAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$2";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

