/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCodeInsightAction
extends CodeInsightAction {
    private final boolean myLookForInjectedEditor;

    protected BaseCodeInsightAction() {
        this(true);
    }

    protected BaseCodeInsightAction(boolean lookForInjectedEditor) {
        this.myLookForInjectedEditor = lookForInjectedEditor;
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext, @NotNull Project project2, boolean forUpdate) {
        if (dataContext == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(1);
        }
        Editor editor = this.getBaseEditor(dataContext, project2);
        if (!this.myLookForInjectedEditor) {
            return editor;
        }
        return BaseCodeInsightAction.getInjectedEditor(project2, editor, !forUpdate);
    }

    public static Editor getInjectedEditor(@NotNull Project project2, Editor editor) {
        if (project2 == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(2);
        }
        return BaseCodeInsightAction.getInjectedEditor(project2, editor, true);
    }

    public static Editor getInjectedEditor(@NotNull Project project2, Editor editor, boolean commit) {
        PsiDocumentManager documentManager;
        PsiFile psiFile;
        if (project2 == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(3);
        }
        Editor injectedEditor = editor;
        if (editor != null && (psiFile = (documentManager = PsiDocumentManager.getInstance((Project)project2)).getCachedPsiFile(editor.getDocument())) != null) {
            if (commit) {
                documentManager.commitAllDocuments();
            }
            injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile);
        }
        return injectedEditor;
    }

    @Nullable
    protected Editor getBaseEditor(@NotNull DataContext dataContext, @NotNull Project project2) {
        if (dataContext == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(5);
        }
        return super.getEditor(dataContext, project2, true);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        LookupEx activeLookup = LookupManager.getInstance(project2).getActiveLookup();
        if (activeLookup != null) {
            presentation.setEnabled(this.isValidForLookup());
        } else {
            super.update(event);
        }
    }

    protected boolean isValidForLookup() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/actions/BaseCodeInsightAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjectedEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

