/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.Collection;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RearrangeCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = "Rearrange code";
    public static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"process.rearrange.code", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance(RearrangeCodeProcessor.class);
    private SelectionModel mySelectionModel;

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor) {
        if (previousProcessor == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(0);
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
    }

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor, @NotNull SelectionModel selectionModel) {
        if (previousProcessor == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(1);
        }
        if (selectionModel == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(2);
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
        this.mySelectionModel = selectionModel;
    }

    public RearrangeCodeProcessor(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        if (file2 == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(3);
        }
        if (selectionModel == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(4);
        }
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, false);
        this.mySelectionModel = selectionModel;
    }

    public RearrangeCodeProcessor(@NotNull PsiFile file2) {
        if (file2 == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(5);
        }
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, false);
    }

    public RearrangeCodeProcessor(@NotNull Project project2, @NotNull PsiFile[] files, @NotNull String commandName, @Nullable Runnable postRunnable) {
        if (project2 == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(6);
        }
        if (files == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(7);
        }
        if (commandName == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(8);
        }
        this(project2, files, commandName, postRunnable, false);
    }

    public RearrangeCodeProcessor(@NotNull Project project2, @NotNull PsiFile[] files, @NotNull String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        if (project2 == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(9);
        }
        if (files == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(10);
        }
        if (commandName == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(11);
        }
        super(project2, files, PROGRESS_TEXT, commandName, postRunnable, processChangedTextOnly);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(12);
        }
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(() -> {
            if (file2 == null) {
                RearrangeCodeProcessor.$$$reportNull$$$0(20);
            }
            try {
                Collection<TextRange> ranges = this.getRangesToFormat(file2, processChangedTextOnly);
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
                if (document != null && Rearranger.EXTENSION.forLanguage(file2.getLanguage()) != null) {
                    PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(document);
                    PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
                    Runnable command = this.prepareRearrangeCommand(file2, ranges);
                    try {
                        CommandProcessor.getInstance().executeCommand(this.myProject, command, COMMAND_NAME, null);
                    }
                    finally {
                        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
                    }
                }
                return true;
            }
            catch (FilesTooBigForDiffException e) {
                this.handleFileTooBigException(LOG, e, file2);
                return false;
            }
        });
        if (futureTask == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(13);
        }
        return futureTask;
    }

    @NotNull
    private Runnable prepareRearrangeCommand(@NotNull PsiFile file2, @NotNull Collection<TextRange> ranges) {
        if (file2 == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(14);
        }
        if (ranges == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(15);
        }
        ArrangementEngine engine = (ArrangementEngine)ServiceManager.getService((Project)this.myProject, ArrangementEngine.class);
        Runnable runnable2 = () -> {
            if (file2 == null) {
                RearrangeCodeProcessor.$$$reportNull$$$0(18);
            }
            if (ranges == null) {
                RearrangeCodeProcessor.$$$reportNull$$$0(19);
            }
            engine.arrange(file2, ranges);
            if (this.getInfoCollector() != null) {
                String info = engine.getUserNotificationInfo();
                this.getInfoCollector().setRearrangeCodeNotification(info);
            }
        };
        if (runnable2 == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(16);
        }
        return runnable2;
    }

    public Collection<TextRange> getRangesToFormat(@NotNull PsiFile file2, boolean processChangedTextOnly) throws FilesTooBigForDiffException {
        if (file2 == null) {
            RearrangeCodeProcessor.$$$reportNull$$$0(17);
        }
        if (this.mySelectionModel != null) {
            return RearrangeCodeProcessor.getSelectedRanges(this.mySelectionModel);
        }
        if (processChangedTextOnly) {
            return FormatChangedTextUtil.getInstance().getChangedTextRanges(this.myProject, file2);
        }
        return ContainerUtil.newSmartList((Object)file2.getTextRange());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousProcessor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/RearrangeCodeProcessor";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/RearrangeCodeProcessor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTask";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRearrangeCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareTask";
                break;
            }
            case 13: 
            case 16: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareRearrangeCommand";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRangesToFormat";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareRearrangeCommand$1";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareTask$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

