/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.codeInsight.lookup.PresentableLookupValue;
import com.intellij.codeInsight.template.Template;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CompletionData");
    public static final ObjectPattern.Capture<Character> NOT_JAVA_ID = StandardPatterns.not((ElementPattern)StandardPatterns.character().javaIdentifierPart());
    private final List<CompletionVariant> myCompletionVariants = new ArrayList<CompletionVariant>();
    protected final CompletionVariant myGenericVariant = new CompletionVariant(){

        @Override
        void addReferenceCompletions(PsiReference reference, PsiElement position, Set<LookupElement> set2, PsiFile file2, CompletionData completionData) {
            CompletionData.this.completeReference(reference, position, set2, TailType.NONE, TrueFilter.INSTANCE, this);
        }
    };

    protected CompletionData() {
    }

    private boolean isScopeAcceptable(PsiElement scope) {
        for (CompletionVariant variant : this.myCompletionVariants) {
            if (!variant.isScopeAcceptable(scope)) continue;
            return true;
        }
        return false;
    }

    protected void registerVariant(CompletionVariant variant) {
        this.myCompletionVariants.add(variant);
    }

    public void completeReference(PsiReference reference, Set<LookupElement> set2, @NotNull PsiElement position, PsiFile file2) {
        if (position == null) {
            CompletionData.$$$reportNull$$$0(0);
        }
        CompletionVariant[] variants = this.findVariants(position, file2);
        boolean hasApplicableVariants = false;
        for (CompletionVariant variant : variants) {
            if (!variant.hasReferenceFilter()) continue;
            variant.addReferenceCompletions(reference, position, set2, file2, this);
            hasApplicableVariants = true;
        }
        if (!hasApplicableVariants) {
            this.myGenericVariant.addReferenceCompletions(reference, position, set2, file2, this);
        }
    }

    public void addKeywordVariants(Set<CompletionVariant> set2, PsiElement position, PsiFile file2) {
        ContainerUtil.addAll(set2, (Object[])this.findVariants(position, file2));
    }

    void completeKeywordsBySet(Set<LookupElement> set2, Set<CompletionVariant> variants) {
        for (CompletionVariant variant : variants) {
            variant.addKeywords(set2, this);
        }
    }

    public String findPrefix(PsiElement insertedElement, int offsetInFile) {
        return CompletionData.findPrefixStatic(insertedElement, offsetInFile);
    }

    public CompletionVariant[] findVariants(PsiElement position, PsiFile file2) {
        ArrayList<CompletionVariant> variants = new ArrayList<CompletionVariant>();
        PsiElement scope = position;
        if (scope == null) {
            scope = file2;
        }
        while (scope != null) {
            boolean breakFlag = false;
            if (this.isScopeAcceptable(scope)) {
                for (CompletionVariant variant : this.myCompletionVariants) {
                    if (!variant.isVariantApplicable(position, scope) || variants.contains(variant)) continue;
                    variants.add(variant);
                    if (!variant.isScopeFinal(scope)) continue;
                    breakFlag = true;
                }
            }
            if (!breakFlag && !((scope = scope.getContext()) instanceof PsiDirectory)) continue;
            break;
        }
        return variants.toArray(new CompletionVariant[variants.size()]);
    }

    @Nullable
    public static String getReferencePrefix(@NotNull PsiElement insertedElement, int offsetInFile) {
        if (insertedElement == null) {
            CompletionData.$$$reportNull$$$0(1);
        }
        try {
            PsiReference ref = insertedElement.getContainingFile().findReferenceAt(offsetInFile);
            if (ref != null) {
                List ranges = ReferenceRange.getRanges((PsiReference)ref);
                PsiElement element = ref.getElement();
                int elementStart = element.getTextRange().getStartOffset();
                for (TextRange refRange : ranges) {
                    if (!refRange.contains(offsetInFile - elementStart)) continue;
                    int endIndex = offsetInFile - elementStart;
                    int beginIndex = refRange.getStartOffset();
                    if (beginIndex > endIndex) {
                        LOG.error("Inconsistent reference (found at offset not included in its range): ref=" + ref + " element=" + element + " text=" + element.getText());
                    }
                    if (beginIndex < 0) {
                        LOG.error("Inconsistent reference (begin < 0): ref=" + ref + " element=" + element + "; begin=" + beginIndex + " text=" + element.getText());
                    }
                    LOG.assertTrue(endIndex >= 0);
                    return element.getText().substring(beginIndex, endIndex);
                }
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return null;
    }

    public static String findPrefixStatic(PsiElement insertedElement, int offsetInFile, ElementPattern<Character> prefixStartTrim) {
        if (insertedElement == null) {
            return "";
        }
        Document document = insertedElement.getContainingFile().getViewProvider().getDocument();
        assert (document != null);
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)insertedElement.getProject()).isUncommited(document), (Object)"Uncommitted");
        String prefix = CompletionData.getReferencePrefix(insertedElement, offsetInFile);
        if (prefix != null) {
            return prefix;
        }
        if (insertedElement instanceof PsiPlainText || insertedElement instanceof PsiComment) {
            return CompletionUtil.findJavaIdentifierPrefix(insertedElement, offsetInFile);
        }
        return CompletionData.findPrefixDefault(insertedElement, offsetInFile, prefixStartTrim);
    }

    public static String findPrefixStatic(PsiElement insertedElement, int offsetInFile) {
        return CompletionData.findPrefixStatic(insertedElement, offsetInFile, NOT_JAVA_ID);
    }

    public static String findPrefixDefault(PsiElement insertedElement, int offset, @NotNull ElementPattern trimStart) {
        int i;
        String substr;
        if (trimStart == null) {
            CompletionData.$$$reportNull$$$0(2);
        }
        if ((substr = insertedElement.getText().substring(0, offset - insertedElement.getTextRange().getStartOffset())).length() == 0 || Character.isWhitespace(substr.charAt(substr.length() - 1))) {
            return "";
        }
        substr = substr.trim();
        for (i = 0; substr.length() > i && trimStart.accepts((Object)Character.valueOf(substr.charAt(i))); ++i) {
        }
        return substr.substring(i).trim();
    }

    public static LookupElement objectToLookupItem(@NotNull Object object) {
        if (object == null) {
            CompletionData.$$$reportNull$$$0(3);
        }
        if (object instanceof LookupElement) {
            return (LookupElement)object;
        }
        String s = null;
        TailType tailType = TailType.NONE;
        if (object instanceof PsiElement) {
            s = PsiUtilCore.getName((PsiElement)((PsiElement)object));
        } else if (object instanceof PsiMetaData) {
            s = ((PsiMetaData)object).getName();
        } else if (object instanceof String) {
            s = (String)object;
        } else if (object instanceof Template) {
            s = ((Template)object).getKey();
        } else if (object instanceof PresentableLookupValue) {
            s = ((PresentableLookupValue)object).getPresentation();
        }
        if (s == null) {
            throw new AssertionError((Object)("Null string for object: " + object + " of class " + object.getClass()));
        }
        LookupItem<Object> item = new LookupItem<Object>(object, s);
        if (object instanceof LookupValueWithUIHint && ((LookupValueWithUIHint)object).isBold()) {
            item.setBold();
        }
        item.setAttribute(LookupItem.TAIL_TYPE_ATTR, (Object)tailType);
        return item;
    }

    protected void addLookupItem(Set<LookupElement> set2, TailType tailType, @NotNull Object completion, CompletionVariant variant) {
        LookupElement ret;
        if (completion == null) {
            CompletionData.$$$reportNull$$$0(4);
        }
        if ((ret = CompletionData.objectToLookupItem(completion)) == null) {
            return;
        }
        if (!(ret instanceof LookupItem)) {
            set2.add(ret);
            return;
        }
        LookupItem item = (LookupItem)ret;
        InsertHandler insertHandler = variant.getInsertHandler();
        if (insertHandler != null && item.getInsertHandler() == null) {
            item.setInsertHandler(insertHandler);
            item.setTailType(TailType.UNKNOWN);
        } else if (tailType != TailType.NONE) {
            item.setTailType(tailType);
        }
        Map<Object, Object> itemProperties = variant.getItemProperties();
        for (Object key2 : itemProperties.keySet()) {
            item.setAttribute(key2, itemProperties.get(key2));
        }
        set2.add(ret);
    }

    protected void completeReference(PsiReference reference, PsiElement position, Set<LookupElement> set2, TailType tailType, ElementFilter filter2, CompletionVariant variant) {
        if (reference instanceof PsiMultiReference) {
            for (PsiReference ref : CompletionData.getReferences((PsiMultiReference)reference)) {
                this.completeReference(ref, position, set2, tailType, filter2, variant);
            }
        } else if (reference instanceof PsiDynaReference) {
            for (PsiReference ref : ((PsiDynaReference)reference).getReferences()) {
                this.completeReference(ref, position, set2, tailType, filter2, variant);
            }
        } else {
            Object[] completions;
            for (Object completion : completions = reference.getVariants()) {
                Object o;
                if (completion == null) {
                    LOG.error("Position=" + position + "\n;Reference=" + reference + "\n;variants=" + Arrays.toString(completions));
                    continue;
                }
                if (completion instanceof PsiElement) {
                    PsiElement psiElement = (PsiElement)completion;
                    if (!filter2.isClassAcceptable(psiElement.getClass()) || !filter2.isAcceptable((Object)psiElement, position)) continue;
                    this.addLookupItem(set2, tailType, completion, variant);
                    continue;
                }
                if (completion instanceof LookupItem && (o = ((LookupItem)completion).getObject()) instanceof PsiElement && (!filter2.isClassAcceptable(o.getClass()) || !filter2.isAcceptable(o, position))) continue;
                try {
                    this.addLookupItem(set2, tailType, completion, variant);
                }
                catch (AssertionError e) {
                    LOG.error("Caused by variant from reference: " + reference.getClass(), (Throwable)((Object)e));
                }
            }
        }
    }

    protected static PsiReference[] getReferences(PsiMultiReference multiReference) {
        Object[] references = multiReference.getReferences();
        List hard = ContainerUtil.findAll((Object[])references, object -> !object.isSoft());
        if (!hard.isEmpty()) {
            return hard.toArray(new PsiReference[hard.size()]);
        }
        return references;
    }

    void addKeywords(Set<LookupElement> set2, CompletionVariant variant, Object comp, TailType tailType) {
        if (!(comp instanceof String)) {
            return;
        }
        for (LookupElement item : set2) {
            if (!item.getObject().toString().equals(comp)) continue;
            return;
        }
        this.addLookupItem(set2, tailType, comp, variant);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trimStart";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completion";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/CompletionData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "completeReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferencePrefix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findPrefixDefault";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "objectToLookupItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addLookupItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

