/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaConstructorCallElement;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.completion.JavaMemberNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaStaticMemberProcessor;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.StaticMemberProcessor;
import com.intellij.codeInsight.completion.SuperCalls;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.scope.CompletionElement;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.InsertHandlerDecorator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInspection.java15api.Java15APIUsageInspectionBase;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.proximity.ReferenceListWeigher;
import com.intellij.ui.JBColor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.siyeh.ig.psiutils.SideEffectChecker;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionUtil {
    public static final Key<Boolean> FORCE_SHOW_SIGNATURE_ATTR = Key.create((String)"forceShowSignature");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaCompletionUtil");
    public static final Key<PairFunction<PsiExpression, CompletionParameters, PsiType>> DYNAMIC_TYPE_EVALUATOR = Key.create((String)"DYNAMIC_TYPE_EVALUATOR");
    private static final Key<PsiType> QUALIFIER_TYPE_ATTR = Key.create((String)"qualifierType");
    static final NullableLazyKey<ExpectedTypeInfo[], CompletionLocation> EXPECTED_TYPES = NullableLazyKey.create((String)"expectedTypes", location -> {
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().beforeLeaf((ElementPattern)PsiJavaPatterns.psiElement().withText("."))).accepts((Object)location.getCompletionParameters().getPosition())) {
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        return JavaSmartCompletionContributor.getExpectedTypes(location.getCompletionParameters());
    });
    public static final Key<Boolean> SUPER_METHOD_PARAMETERS = Key.create((String)"SUPER_METHOD_PARAMETERS");
    private static final Key<List<SmartPsiElementPointer<PsiMethod>>> ALL_METHODS_ATTRIBUTE = Key.create((String)"allMethods");

    @Nullable
    public static Set<PsiType> getExpectedTypes(CompletionParameters parameters2) {
        PsiExpression expr = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)parameters2.getPosition(), PsiExpression.class, (boolean)true);
        if (expr != null) {
            THashSet set2 = new THashSet();
            for (ExpectedTypeInfo expectedInfo : JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
                set2.add(expectedInfo.getType());
            }
            return set2;
        }
        return null;
    }

    public static PsiType getQualifierType(LookupElement item) {
        return (PsiType)item.getUserData(QUALIFIER_TYPE_ATTR);
    }

    public static void completeVariableNameForRefactoring(Project project2, Set<LookupElement> set2, String prefix, PsiType varType, VariableKind varKind) {
        CamelHumpMatcher camelHumpMatcher = new CamelHumpMatcher(prefix);
        JavaMemberNameCompletionContributor.completeVariableNameForRefactoring(project2, set2, camelHumpMatcher, varType, varKind, true, false);
    }

    public static void putAllMethods(LookupElement item, List<PsiMethod> methods) {
        item.putUserData(ALL_METHODS_ATTRIBUTE, (Object)ContainerUtil.map(methods, method -> SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)method)));
    }

    public static List<PsiMethod> getAllMethods(LookupElement item) {
        List pointers = (List)item.getUserData(ALL_METHODS_ATTRIBUTE);
        if (pointers == null) {
            return null;
        }
        return ContainerUtil.mapNotNull((Collection)pointers, pointer -> (PsiMethod)pointer.getElement());
    }

    public static String[] completeVariableNameForRefactoring(JavaCodeStyleManager codeStyleManager, @Nullable PsiType varType, VariableKind varKind, SuggestedNameInfo suggestedNameInfo) {
        return JavaMemberNameCompletionContributor.completeVariableNameForRefactoring(codeStyleManager, new CamelHumpMatcher(""), varType, varKind, suggestedNameInfo, true, false);
    }

    public static boolean isInExcludedPackage(@NotNull PsiMember member, boolean allowInstanceInnerClasses) {
        String name2;
        if (member == null) {
            JavaCompletionUtil.$$$reportNull$$$0(0);
        }
        if ((name2 = PsiUtil.getMemberQualifiedName((PsiMember)member)) == null) {
            return false;
        }
        if (!member.hasModifierProperty("static")) {
            if (member instanceof PsiMethod || member instanceof PsiField) {
                return false;
            }
            if (allowInstanceInnerClasses && member instanceof PsiClass && member.getContainingClass() != null) {
                return false;
            }
        }
        return JavaProjectCodeInsightSettings.getSettings(member.getProject()).isExcluded(name2);
    }

    @NotNull
    public static <T extends PsiType> T originalize(@NotNull T type2) {
        if (type2 == null) {
            JavaCompletionUtil.$$$reportNull$$$0(1);
        }
        if (!type2.isValid()) {
            T t = type2;
            if (t == null) {
                JavaCompletionUtil.$$$reportNull$$$0(2);
            }
            return t;
        }
        T result2 = new PsiTypeMapper(){
            private final Set<PsiClassType> myVisited = ContainerUtil.newIdentityTroveSet();

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                if (!this.myVisited.add(classType)) {
                    return classType;
                }
                PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
                PsiClass psiClass = classResolveResult.getElement();
                PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
                if (psiClass == null) {
                    return classType;
                }
                return new PsiImmediateClassType(CompletionUtil.getOriginalOrSelf(psiClass), this.originalizeSubstitutor(substitutor));
            }

            private PsiSubstitutor originalizeSubstitutor(PsiSubstitutor substitutor) {
                PsiSubstitutor originalSubstitutor = PsiSubstitutor.EMPTY;
                for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
                    PsiType value2 = (PsiType)entry.getValue();
                    originalSubstitutor = originalSubstitutor.put((PsiTypeParameter)CompletionUtil.getOriginalOrSelf((PsiElement)entry.getKey()), value2 == null ? null : this.mapType(value2));
                }
                return originalSubstitutor;
            }

            @Override
            public PsiType visitType(PsiType type2) {
                return type2;
            }
        }.mapType(type2);
        if (result2 == null) {
            throw new AssertionError((Object)("Null result for type " + type2 + " of class " + type2.getClass()));
        }
        T t = result2;
        if (t == null) {
            JavaCompletionUtil.$$$reportNull$$$0(3);
        }
        return t;
    }

    @Nullable
    public static List<? extends PsiElement> getAllPsiElements(LookupElement item) {
        List<PsiMethod> allMethods = JavaCompletionUtil.getAllMethods(item);
        if (allMethods != null) {
            return allMethods;
        }
        if (item.getObject() instanceof PsiElement) {
            return Collections.singletonList((PsiElement)item.getObject());
        }
        return null;
    }

    @Nullable
    public static PsiType getLookupElementType(LookupElement element) {
        TypedLookupItem typed = (TypedLookupItem)element.as(TypedLookupItem.CLASS_CONDITION_KEY);
        return typed != null ? typed.getType() : null;
    }

    @Nullable
    public static PsiType getQualifiedMemberReferenceType(@Nullable PsiType qualifierType, final @NotNull PsiMember member) {
        if (member == null) {
            JavaCompletionUtil.$$$reportNull$$$0(4);
        }
        final Ref subst = Ref.create((Object)PsiSubstitutor.EMPTY);
        class MyProcessor
        extends BaseScopeProcessor
        implements NameHint,
        ElementClassHint {
            MyProcessor() {
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    MyProcessor.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    MyProcessor.$$$reportNull$$$0(1);
                }
                if (element == member) {
                    subst.set(state.get(PsiSubstitutor.KEY));
                }
                return true;
            }

            @Override
            public String getName(@NotNull ResolveState state) {
                if (state == null) {
                    MyProcessor.$$$reportNull$$$0(2);
                }
                return member.getName();
            }

            @Override
            public boolean shouldProcess(ElementClassHint.DeclarationKind kind2) {
                return member instanceof PsiEnumConstant ? kind2 == ElementClassHint.DeclarationKind.ENUM_CONST : (member instanceof PsiField ? kind2 == ElementClassHint.DeclarationKind.FIELD : kind2 == ElementClassHint.DeclarationKind.METHOD);
            }

            @Override
            public <T> T getHint(@NotNull Key<T> hintKey) {
                if (hintKey == null) {
                    MyProcessor.$$$reportNull$$$0(3);
                }
                return (T)(hintKey == NameHint.KEY || hintKey == ElementClassHint.KEY ? this : null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "hintKey";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionUtil$1MyProcessor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getHint";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        PsiScopesUtil.processTypeDeclarations(qualifierType, (PsiElement)member, new MyProcessor());
        PsiType rawType = member instanceof PsiField ? ((PsiField)member).getType() : (member instanceof PsiMethod ? ((PsiMethod)member).getReturnType() : JavaPsiFacade.getElementFactory((Project)member.getProject()).createType((PsiClass)member));
        return ((PsiSubstitutor)subst.get()).substitute(rawType);
    }

    public static Set<LookupElement> processJavaReference(PsiElement element, PsiJavaReference javaReference, ElementFilter elementFilter, JavaCompletionProcessor.Options options, PrefixMatcher matcher, CompletionParameters parameters2) {
        PsiElement resolve2;
        PsiExpression qualifierExpression2;
        PsiElement elementParent = element.getContext();
        if (elementParent instanceof PsiReferenceExpression && (qualifierExpression2 = ((PsiReferenceExpression)elementParent).getQualifierExpression()) instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)qualifierExpression2).resolve()) instanceof PsiParameter) {
            LinkedHashSet<LookupElement> set2;
            int parameterIndex;
            boolean overloadsFound;
            PsiLambdaExpression lambdaExpression;
            PsiElement declarationScope = ((PsiParameter)resolve2).getDeclarationScope();
            if (((PsiParameter)resolve2).getType() instanceof PsiLambdaParameterType && PsiTypesUtil.getExpectedTypeByParent((PsiElement)(lambdaExpression = (PsiLambdaExpression)declarationScope)) == null && (overloadsFound = LambdaUtil.processParentOverloads((PsiFunctionalExpression)lambdaExpression, arg_0 -> JavaCompletionUtil.lambda$processJavaReference$3(parameterIndex = lambdaExpression.getParameterList().getParameterIndex((PsiParameter)resolve2), element, set2 = new LinkedHashSet<LookupElement>(), elementFilter, options, matcher, parameters2, arg_0)))) {
                return set2;
            }
        }
        return JavaCompletionUtil.processJavaQualifiedReference(element, javaReference, elementFilter, options, matcher, parameters2);
    }

    private static Set<LookupElement> processJavaQualifiedReference(PsiElement element, PsiJavaReference javaReference, ElementFilter elementFilter, JavaCompletionProcessor.Options options, PrefixMatcher matcher, CompletionParameters parameters2) {
        PsiType plainQualifier;
        LinkedHashSet<LookupElement> set2 = new LinkedHashSet<LookupElement>();
        Condition nameCondition = arg_0 -> ((PrefixMatcher)matcher).prefixMatches(arg_0);
        JavaCompletionProcessor processor2 = new JavaCompletionProcessor(element, elementFilter, options, (Condition<String>)nameCondition);
        PsiType qualifierType = plainQualifier = processor2.getQualifierType();
        PsiType runtimeQualifier = JavaCompletionUtil.getQualifierCastType(javaReference, parameters2);
        if (runtimeQualifier != null) {
            PsiType composite = qualifierType == null ? runtimeQualifier : PsiIntersectionType.createIntersection((PsiType[])new PsiType[]{qualifierType, runtimeQualifier});
            FakePsiElement ctx = JavaCompletionUtil.createContextWithXxxVariable(element, composite);
            javaReference = JavaCompletionUtil.createReference("xxx.xxx", (PsiElement)ctx);
            qualifierType = runtimeQualifier;
            processor2.setQualifierType(qualifierType);
        }
        javaReference.processVariants((PsiScopeProcessor)processor2);
        PsiTypeLookupItem castItem = runtimeQualifier == null ? null : PsiTypeLookupItem.createLookupItem(runtimeQualifier, (PsiElement)((PsiReferenceExpression)javaReference));
        boolean pkgContext = JavaCompletionUtil.inSomePackage(element);
        PsiClass qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierType);
        boolean honorExcludes = qualifierClass == null || !JavaCompletionUtil.isInExcludedPackage((PsiMember)qualifierClass, false);
        THashSet mentioned = new THashSet();
        for (CompletionElement completionElement : processor2.getResults()) {
            for (LookupElement lookupElement : JavaCompletionUtil.createLookupElements(completionElement, javaReference)) {
                lookupElement.putUserData(QUALIFIER_TYPE_ATTR, (Object)qualifierType);
                Object o = lookupElement.getObject();
                if (o instanceof PsiClass && !JavaCompletionUtil.isSourceLevelAccessible(element, (PsiClass)o, pkgContext)) continue;
                if (o instanceof PsiMember) {
                    if (honorExcludes && JavaCompletionUtil.isInExcludedPackage((PsiMember)o, true)) continue;
                    mentioned.add(CompletionUtil.getOriginalOrSelf((PsiMember)o));
                }
                set2.add(JavaCompletionUtil.highlightIfNeeded(qualifierType, JavaCompletionUtil.castQualifier(lookupElement, castItem, plainQualifier, processor2), o, element));
            }
        }
        if (javaReference instanceof PsiJavaCodeReferenceElement) {
            PsiElement refQualifier = ((PsiJavaCodeReferenceElement)javaReference).getQualifier();
            if (refQualifier == null && PsiTreeUtil.getParentOfType((PsiElement)element, PsiPackageStatement.class) == null) {
                JavaStaticMemberProcessor memberProcessor = new JavaStaticMemberProcessor(parameters2);
                memberProcessor.processMembersOfRegisteredClasses(matcher, (PairConsumer<PsiMember, PsiClass>)((PairConsumer)(arg_0, arg_1) -> JavaCompletionUtil.lambda$processJavaQualifiedReference$4((Set)mentioned, processor2, set2, memberProcessor, arg_0, arg_1)));
            } else if (refQualifier instanceof PsiSuperExpression && ((PsiSuperExpression)refQualifier).getQualifier() == null) {
                set2.addAll(SuperCalls.suggestQualifyingSuperCalls(element, javaReference, elementFilter, options, (Condition<String>)nameCondition));
            }
        }
        return set2;
    }

    @NotNull
    static PsiReferenceExpression createReference(@NotNull String text2, @NotNull PsiElement context) {
        if (text2 == null) {
            JavaCompletionUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JavaCompletionUtil.$$$reportNull$$$0(6);
        }
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText(text2, context);
        if (psiReferenceExpression == null) {
            JavaCompletionUtil.$$$reportNull$$$0(7);
        }
        return psiReferenceExpression;
    }

    @Nullable
    private static PsiType getQualifierCastType(PsiJavaReference javaReference, CompletionParameters parameters2) {
        PsiReferenceExpression refExpr;
        PsiExpression qualifier;
        if (javaReference instanceof PsiReferenceExpression && (qualifier = (refExpr = (PsiReferenceExpression)javaReference).getQualifierExpression()) != null) {
            Project project2 = qualifier.getProject();
            PsiType type2 = null;
            PairFunction evaluator = (PairFunction)refExpr.getContainingFile().getCopyableUserData(DYNAMIC_TYPE_EVALUATOR);
            if (evaluator != null) {
                type2 = (PsiType)evaluator.fun((Object)qualifier, (Object)parameters2);
            }
            if (type2 == null) {
                type2 = GuessManager.getInstance(project2).getControlFlowExpressionType(qualifier);
            }
            return type2;
        }
        return null;
    }

    @NotNull
    private static LookupElement castQualifier(@NotNull LookupElement item, final @Nullable PsiTypeLookupItem castTypeItem, @Nullable PsiType plainQualifier, JavaCompletionProcessor processor2) {
        if (item == null) {
            JavaCompletionUtil.$$$reportNull$$$0(8);
        }
        if (castTypeItem == null) {
            LookupElement lookupElement = item;
            if (lookupElement == null) {
                JavaCompletionUtil.$$$reportNull$$$0(9);
            }
            return lookupElement;
        }
        if (plainQualifier != null) {
            Object o = item.getObject();
            if (o instanceof PsiMethod) {
                PsiType castType = castTypeItem.getType();
                if (plainQualifier instanceof PsiClassType && castType instanceof PsiClassType) {
                    PsiMethod method = (PsiMethod)o;
                    PsiClassType.ClassResolveResult plainResult = ((PsiClassType)plainQualifier).resolveGenerics();
                    PsiClass plainClass = plainResult.getElement();
                    if (plainClass != null && plainClass.findMethodBySignature(method, true) != null) {
                        PsiClass castClass = ((PsiClassType)castType).resolveGenerics().getElement();
                        if (castClass == null || !castClass.isInheritor(plainClass, true)) {
                            LookupElement lookupElement = item;
                            if (lookupElement == null) {
                                JavaCompletionUtil.$$$reportNull$$$0(10);
                            }
                            return lookupElement;
                        }
                        PsiSubstitutor plainSub = plainResult.getSubstitutor();
                        PsiSubstitutor castSub = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)plainClass, (PsiClassType)((PsiClassType)castType));
                        PsiType returnType = method.getReturnType();
                        if (method.getSignature(plainSub).equals(method.getSignature(castSub))) {
                            PsiType typeAfterCast = JavaCompletionUtil.toRaw(castSub.substitute(returnType));
                            PsiType typeDeclared = JavaCompletionUtil.toRaw(plainSub.substitute(returnType));
                            if (typeAfterCast != null && typeDeclared != null && typeAfterCast.isAssignableFrom(typeDeclared) && processor2.isAccessible((PsiElement)plainClass.findMethodBySignature(method, true))) {
                                LookupElement lookupElement = item;
                                if (lookupElement == null) {
                                    JavaCompletionUtil.$$$reportNull$$$0(11);
                                }
                                return lookupElement;
                            }
                        }
                    }
                }
            } else if (JavaCompletionUtil.containsMember(plainQualifier, o)) {
                LookupElement lookupElement = item;
                if (lookupElement == null) {
                    JavaCompletionUtil.$$$reportNull$$$0(12);
                }
                return lookupElement;
            }
        }
        LookupElementDecorator lookupElementDecorator = LookupElementDecorator.withInsertHandler((LookupElement)item, (InsertHandler)new InsertHandlerDecorator<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
                PsiElement qualifier;
                Document document = context.getEditor().getDocument();
                context.commitDocument();
                PsiFile file2 = context.getFile();
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)context.getStartOffset(), PsiJavaCodeReferenceElement.class, (boolean)false);
                if (ref != null && (qualifier = ref.getQualifier()) != null) {
                    CommonCodeStyleSettings settings = context.getCodeStyleSettings();
                    String parenSpace = settings.SPACE_WITHIN_PARENTHESES ? " " : "";
                    document.insertString(qualifier.getTextRange().getEndOffset(), (CharSequence)(parenSpace + ")"));
                    String spaceWithin = settings.SPACE_WITHIN_CAST_PARENTHESES ? " " : "";
                    String prefix = "(" + parenSpace + "(" + spaceWithin;
                    String spaceAfter = settings.SPACE_AFTER_TYPE_CAST ? " " : "";
                    int exprStart = qualifier.getTextRange().getStartOffset();
                    document.insertString(exprStart, (CharSequence)(prefix + spaceWithin + ")" + spaceAfter));
                    CompletionUtil.emulateInsertion(context, exprStart + prefix.length(), (LookupElement)castTypeItem);
                    PsiDocumentManager.getInstance((Project)file2.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
                }
                item.getDelegate().handleInsert(context);
            }
        });
        if (lookupElementDecorator == null) {
            JavaCompletionUtil.$$$reportNull$$$0(13);
        }
        return lookupElementDecorator;
    }

    @Nullable
    private static PsiType toRaw(@Nullable PsiType type2) {
        return type2 instanceof PsiClassType ? ((PsiClassType)type2).rawType() : type2;
    }

    @NotNull
    public static LookupElement highlightIfNeeded(@Nullable PsiType qualifierType, @NotNull LookupElement item, @NotNull Object object, @NotNull PsiElement place) {
        if (item == null) {
            JavaCompletionUtil.$$$reportNull$$$0(14);
        }
        if (object == null) {
            JavaCompletionUtil.$$$reportNull$$$0(15);
        }
        if (place == null) {
            JavaCompletionUtil.$$$reportNull$$$0(16);
        }
        if (JavaCompletionUtil.shouldMarkRed(object, place)) {
            LookupElement lookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)LookupElementDecorator.withRenderer((LookupElement)item, (LookupElementRenderer)new LookupElementRenderer<LookupElementDecorator<LookupElement>>(){

                public void renderElement(LookupElementDecorator<LookupElement> element, LookupElementPresentation presentation) {
                    element.getDelegate().renderElement(presentation);
                    presentation.setItemTextForeground((Color)JBColor.RED);
                }
            }), (int)-1);
            if (lookupElement == null) {
                JavaCompletionUtil.$$$reportNull$$$0(17);
            }
            return lookupElement;
        }
        if (JavaCompletionUtil.containsMember(qualifierType, object)) {
            LookupElementDecorator bold = LookupElementDecorator.withRenderer((LookupElement)item, (LookupElementRenderer)new LookupElementRenderer<LookupElementDecorator<LookupElement>>(){

                public void renderElement(LookupElementDecorator<LookupElement> element, LookupElementPresentation presentation) {
                    element.getDelegate().renderElement(presentation);
                    presentation.setItemTextBold(true);
                }
            });
            Object object2 = object instanceof PsiField ? bold : PrioritizedLookupElement.withExplicitProximity((LookupElement)bold, (int)1);
            if (object2 == null) {
                JavaCompletionUtil.$$$reportNull$$$0(18);
            }
            return object2;
        }
        LookupElement lookupElement = item;
        if (lookupElement == null) {
            JavaCompletionUtil.$$$reportNull$$$0(19);
        }
        return lookupElement;
    }

    private static boolean shouldMarkRed(@NotNull Object object, @NotNull PsiElement place) {
        if (object == null) {
            JavaCompletionUtil.$$$reportNull$$$0(20);
        }
        if (place == null) {
            JavaCompletionUtil.$$$reportNull$$$0(21);
        }
        if (!(object instanceof PsiMember)) {
            return false;
        }
        if (Java15APIUsageInspectionBase.getLastIncompatibleLanguageLevel((PsiMember)object, PsiUtil.getLanguageLevel((PsiElement)place)) != null) {
            return true;
        }
        if (object instanceof PsiEnumConstant) {
            return ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch(place).contains(CompletionUtil.getOriginalOrSelf((PsiEnumConstant)object));
        }
        return object instanceof PsiClass && ReferenceListWeigher.INSTANCE.getApplicability((PsiClass)object, place) == ReferenceListWeigher.ReferenceListApplicability.inapplicable;
    }

    public static boolean containsMember(@Nullable PsiType qualifierType, @NotNull Object object) {
        if (object == null) {
            JavaCompletionUtil.$$$reportNull$$$0(22);
        }
        if (qualifierType instanceof PsiArrayType && object instanceof PsiMember) {
            PsiFile file2 = ((PsiMember)object).getContainingFile();
            if (file2 == null || file2.getVirtualFile() == null) {
                return true;
            }
        } else if (qualifierType instanceof PsiClassType) {
            PsiClass qualifierClass = ((PsiClassType)qualifierType).resolve();
            if (qualifierClass == null) {
                return false;
            }
            if (object instanceof PsiMethod && qualifierClass.findMethodBySignature((PsiMethod)object, false) != null) {
                return true;
            }
            if (object instanceof PsiMember) {
                return qualifierClass.equals(((PsiMember)object).getContainingClass());
            }
        }
        return false;
    }

    static Iterable<? extends LookupElement> createLookupElements(CompletionElement completionElement, PsiJavaReference reference) {
        Object completion = completionElement.getElement();
        assert (!(completion instanceof LookupElement));
        if (reference instanceof PsiJavaCodeReferenceElement) {
            if (completion instanceof PsiMethod && ((PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiImportStaticStatement) {
                return Collections.singletonList(JavaLookupElementBuilder.forMethod((PsiMethod)completion, PsiSubstitutor.EMPTY));
            }
            if (completion instanceof PsiClass) {
                List<JavaPsiClassReferenceElement> classItems = JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)completion, JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)reference), JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER, (Condition<PsiClass>)Conditions.alwaysTrue());
                return JBIterable.from(classItems).flatMap(i -> JavaConstructorCallElement.wrap(i, reference.getElement()));
            }
        }
        if (reference instanceof PsiMethodReferenceExpression && completion instanceof PsiMethod && ((PsiMethod)completion).isConstructor()) {
            return Collections.singletonList(JavaLookupElementBuilder.forMethod((PsiMethod)completion, "new", PsiSubstitutor.EMPTY, null));
        }
        PsiSubstitutor substitutor = completionElement.getSubstitutor();
        if (substitutor == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        if (completion instanceof PsiClass) {
            JavaPsiClassReferenceElement classItem = JavaClassNameCompletionContributor.createClassLookupItem((PsiClass)completion, true).setSubstitutor(substitutor);
            return JavaConstructorCallElement.wrap(classItem, reference.getElement());
        }
        if (completion instanceof PsiMethod) {
            JavaMethodCallElement item = new JavaMethodCallElement((PsiMethod)completion).setQualifierSubstitutor(substitutor);
            item.setForcedQualifier(completionElement.getQualifierText());
            return Collections.singletonList(item);
        }
        if (completion instanceof PsiVariable) {
            return Collections.singletonList(new VariableLookupItem((PsiVariable)completion).setSubstitutor(substitutor));
        }
        return Collections.singletonList(LookupItemUtil.objectToLookupItem(completion));
    }

    public static boolean hasAccessibleConstructor(PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            return true;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (psiClass == null || psiClass.isEnum() || psiClass.isAnnotationType()) {
            return false;
        }
        PsiMethod[] methods = psiClass.getConstructors();
        return methods.length == 0 || Arrays.stream(methods).anyMatch(JavaCompletionUtil::isConstructorCompletable);
    }

    private static boolean isConstructorCompletable(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            JavaCompletionUtil.$$$reportNull$$$0(23);
        }
        return !(constructor instanceof PsiCompiledElement) || !constructor.hasModifierProperty("private");
    }

    public static LinkedHashSet<String> getAllLookupStrings(@NotNull PsiMember member) {
        String className;
        if (member == null) {
            JavaCompletionUtil.$$$reportNull$$$0(24);
        }
        LinkedHashSet allLookupStrings = ContainerUtil.newLinkedHashSet();
        String name2 = member.getName();
        allLookupStrings.add(name2);
        PsiClass containingClass = member.getContainingClass();
        while (containingClass != null && (className = containingClass.getName()) != null) {
            name2 = className + "." + name2;
            allLookupStrings.add(name2);
            PsiElement parent = containingClass.getParent();
            if (!(parent instanceof PsiClass)) break;
            containingClass = (PsiClass)parent;
        }
        return allLookupStrings;
    }

    public static boolean mayHaveSideEffects(@Nullable PsiElement element) {
        return element instanceof PsiExpression && SideEffectChecker.mayHaveSideEffects((PsiExpression)element);
    }

    public static void insertClassReference(@NotNull PsiClass psiClass, @NotNull PsiFile file2, int offset) {
        if (psiClass == null) {
            JavaCompletionUtil.$$$reportNull$$$0(25);
        }
        if (file2 == null) {
            JavaCompletionUtil.$$$reportNull$$$0(26);
        }
        JavaCompletionUtil.insertClassReference(psiClass, file2, offset, offset);
    }

    public static int insertClassReference(PsiClass psiClass, PsiFile file2, int startOffset, int endOffset) {
        PsiElement parent;
        Project project2 = file2.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        documentManager.commitAllDocuments();
        PsiManager manager = file2.getManager();
        Document document = FileDocumentManager.getInstance().getDocument(file2.getViewProvider().getVirtualFile());
        PsiReference reference = file2.findReferenceAt(startOffset);
        if (reference != null && manager.areElementsEquivalent((PsiElement)psiClass, reference.resolve())) {
            return endOffset;
        }
        String name2 = psiClass.getName();
        if (name2 == null) {
            return endOffset;
        }
        assert (document != null);
        document.replaceString(startOffset, endOffset, (CharSequence)name2);
        int newEndOffset = startOffset + name2.length();
        RangeMarker toDelete = JavaCompletionUtil.insertTemporary(newEndOffset, document, " ");
        documentManager.commitAllDocuments();
        PsiElement element = file2.findElementAt(startOffset);
        if (element instanceof PsiIdentifier && (parent = element.getParent()) instanceof PsiJavaCodeReferenceElement && !((PsiJavaCodeReferenceElement)parent).isQualified() && !(parent.getParent() instanceof PsiPackageStatement)) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)parent;
            if (psiClass.isValid() && !psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference((PsiReference)ref))) {
                PsiElement newElement;
                boolean staticImport = ref instanceof PsiImportStaticReferenceElement;
                try {
                    newElement = staticImport ? ((PsiImportStaticReferenceElement)ref).bindToTargetClass(psiClass) : ref.bindToElement((PsiElement)psiClass);
                }
                catch (IncorrectOperationException e) {
                    return endOffset;
                }
                RangeMarker rangeMarker = document.createRangeMarker(newElement.getTextRange());
                documentManager.doPostponedOperationsAndUnblockDocument(document);
                documentManager.commitDocument(document);
                newElement = CodeInsightUtilCore.findElementInRange(file2, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), PsiJavaCodeReferenceElement.class, (Language)JavaLanguage.INSTANCE);
                rangeMarker.dispose();
                if (newElement != null) {
                    String qName;
                    PsiReferenceParameterList parameterList;
                    newEndOffset = newElement.getTextRange().getEndOffset();
                    if (!(newElement instanceof PsiReferenceExpression) && (parameterList = ((PsiJavaCodeReferenceElement)newElement).getParameterList()) != null) {
                        newEndOffset = parameterList.getTextRange().getStartOffset();
                    }
                    if (!(staticImport || psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference((PsiReference)newElement)) || PsiUtil.isInnerClass((PsiClass)psiClass) || (qName = psiClass.getQualifiedName()) == null)) {
                        document.replaceString(newElement.getTextRange().getStartOffset(), newEndOffset, (CharSequence)qName);
                        newEndOffset = newElement.getTextRange().getStartOffset() + qName.length();
                    }
                }
            }
        }
        if (toDelete.isValid()) {
            document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
        }
        return newEndOffset;
    }

    @Nullable
    static PsiElement resolveReference(PsiReference psiReference) {
        ResolveResult[] results;
        if (psiReference instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)psiReference).multiResolve(true)).length == 1) {
            return results[0].getElement();
        }
        return psiReference.resolve();
    }

    public static RangeMarker insertTemporary(int endOffset, Document document, String temporary) {
        RangeMarker toDelete;
        CharSequence chars = document.getCharsSequence();
        int length = chars.length();
        if (endOffset < length && Character.isJavaIdentifierPart(chars.charAt(endOffset))) {
            document.insertString(endOffset, (CharSequence)temporary);
            toDelete = document.createRangeMarker(endOffset, endOffset + 1);
        } else {
            toDelete = endOffset >= length ? document.createRangeMarker(length, length) : document.createRangeMarker(endOffset, endOffset);
        }
        toDelete.setGreedyToLeft(true);
        toDelete.setGreedyToRight(true);
        return toDelete;
    }

    public static void insertParentheses(InsertionContext context, LookupElement item, boolean overloadsMatter, boolean hasParams) {
        JavaCompletionUtil.insertParentheses(context, item, overloadsMatter, hasParams, false);
    }

    public static void insertParentheses(InsertionContext context, LookupElement item, boolean overloadsMatter, boolean hasParams, boolean forceClosingParenthesis) {
        boolean smart;
        Editor editor = context.getEditor();
        char completionChar = context.getCompletionChar();
        PsiFile file2 = context.getFile();
        TailType tailType = completionChar == '(' ? TailType.NONE : (completionChar == ':' ? TailType.COND_EXPR_COLON : LookupItem.handleCompletionChar(context.getEditor(), item, completionChar));
        boolean hasTail = tailType != TailType.NONE && tailType != TailType.UNKNOWN;
        boolean bl = smart = completionChar == '\r';
        if (completionChar == '(' || completionChar == '.' || completionChar == ',' || completionChar == ';' || completionChar == ':' || completionChar == ' ') {
            context.setAddCompletionChar(false);
        }
        if (hasTail) {
            hasParams = false;
        }
        boolean needRightParenth = forceClosingParenthesis || !smart && (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET || !hasParams && completionChar != '(');
        context.commitDocument();
        CommonCodeStyleSettings styleSettings = context.getCodeStyleSettings();
        PsiElement elementAt = file2.findElementAt(context.getStartOffset());
        if (elementAt == null || !(elementAt.getParent() instanceof PsiMethodReferenceExpression)) {
            final boolean hasParameters = hasParams;
            boolean spaceBetweenParentheses = styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES && hasParams;
            new ParenthesesInsertHandler<LookupElement>(styleSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES, spaceBetweenParentheses, needRightParenth, styleSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE){

                protected boolean placeCaretInsideParentheses(InsertionContext context1, LookupElement item1) {
                    return hasParameters;
                }

                protected PsiElement findExistingLeftParenthesis(@NotNull InsertionContext context) {
                    PsiElement token;
                    if (context == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return this.isPartOfLambda(token = super.findExistingLeftParenthesis(context)) ? null : token;
                }

                private boolean isPartOfLambda(PsiElement token) {
                    return token != null && token.getParent() instanceof PsiExpressionList && PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.nextVisibleLeaf((PsiElement)token.getParent())) == JavaTokenType.ARROW;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/JavaCompletionUtil$5", "findExistingLeftParenthesis"));
                }
            }.handleInsert(context, item);
        }
        if (hasParams) {
            AutoPopupController.getInstance(file2.getProject()).autoPopupParameterInfo(editor, overloadsMatter ? null : (PsiElement)item.getObject());
        }
        if (smart || !needRightParenth || !JavaCompletionUtil.insertTail(context, item, tailType, hasTail)) {
            return;
        }
        if (completionChar == '.') {
            AutoPopupController.getInstance(file2.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        } else if (completionChar == ',') {
            AutoPopupController.getInstance(file2.getProject()).autoPopupParameterInfo(context.getEditor(), null);
        }
    }

    public static boolean insertTail(InsertionContext context, LookupElement item, TailType tailType, boolean hasTail) {
        TailType toInsert = tailType;
        LookupItem lookupItem = (LookupItem)item.as(LookupItem.CLASS_CONDITION_KEY);
        if ((lookupItem == null || lookupItem.getAttribute(LookupItem.TAIL_TYPE_ATTR) != TailType.UNKNOWN) && !hasTail && item.getObject() instanceof PsiMethod && PsiType.VOID.equals((Object)((PsiMethod)item.getObject()).getReturnType())) {
            PsiElement composite;
            PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
            if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().beforeLeaf((ElementPattern)PlatformPatterns.psiElement().withText("."))).accepts((Object)context.getFile().findElementAt(context.getTailOffset() - 1))) {
                return false;
            }
            boolean insertAdditionalSemicolon = true;
            PsiElement leaf = context.getFile().findElementAt(context.getStartOffset());
            PsiElement psiElement = composite = leaf == null ? null : leaf.getParent();
            if (composite instanceof PsiMethodReferenceExpression && LambdaHighlightingUtil.insertSemicolon(composite.getParent())) {
                insertAdditionalSemicolon = false;
            } else if (composite instanceof PsiReferenceExpression) {
                PsiElement parent = composite.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiLambdaExpression && !LambdaHighlightingUtil.insertSemicolonAfter((PsiLambdaExpression)parent)) {
                    insertAdditionalSemicolon = false;
                }
                if (parent instanceof PsiMethodReferenceExpression && LambdaHighlightingUtil.insertSemicolon(parent.getParent())) {
                    insertAdditionalSemicolon = false;
                }
            }
            if (insertAdditionalSemicolon) {
                toInsert = TailType.SEMICOLON;
            }
        }
        toInsert.processTail(context.getEditor(), context.getTailOffset());
        return true;
    }

    public static void shortenReference(PsiFile file2, int offset) throws IncorrectOperationException {
        PsiElement element;
        Project project2 = file2.getProject();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project2);
        Document document = manager.getDocument(file2);
        if (document == null) {
            PsiUtilCore.ensureValid((PsiElement)file2);
            LOG.error("No document for " + file2);
            return;
        }
        manager.commitDocument(document);
        PsiReference ref = file2.findReferenceAt(offset);
        if (ref != null && (element = ref.getElement()) != null) {
            JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(element);
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
        }
    }

    public static boolean inSomePackage(PsiElement context) {
        PsiFile contextFile = context.getContainingFile();
        return contextFile instanceof PsiClassOwner && StringUtil.isNotEmpty((String)((PsiClassOwner)contextFile).getPackageName());
    }

    public static boolean isSourceLevelAccessible(PsiElement context, PsiClass psiClass, boolean pkgContext) {
        String fqName;
        PsiClass topLevel;
        if (!JavaPsiFacade.getInstance((Project)psiClass.getProject()).getResolveHelper().isAccessible((PsiMember)psiClass, context, null)) {
            return false;
        }
        return !pkgContext || (topLevel = PsiUtil.getTopLevelClass((PsiElement)psiClass)) == null || (fqName = topLevel.getQualifiedName()) == null || !StringUtil.isEmpty((String)StringUtil.getPackageName((String)fqName));
    }

    public static boolean promptTypeArgs(InsertionContext context, int offset) {
        if (offset < 0) {
            return false;
        }
        OffsetKey key2 = context.trackOffset(offset, false);
        PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting();
        offset = context.getOffset(key2);
        if (offset < 0) {
            return false;
        }
        String open2 = JavaCompletionUtil.escapeXmlIfNeeded(context, "<");
        context.getDocument().insertString(offset, (CharSequence)open2);
        context.getEditor().getCaretModel().moveToOffset(offset + open2.length());
        if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            context.getDocument().insertString(offset + open2.length(), (CharSequence)JavaCompletionUtil.escapeXmlIfNeeded(context, ">"));
        }
        if (context.getCompletionChar() != '\r') {
            context.setAddCompletionChar(false);
        }
        return true;
    }

    public static FakePsiElement createContextWithXxxVariable(final @NotNull PsiElement place, final @NotNull PsiType varType) {
        if (place == null) {
            JavaCompletionUtil.$$$reportNull$$$0(27);
        }
        if (varType == null) {
            JavaCompletionUtil.$$$reportNull$$$0(28);
        }
        return new FakePsiElement(){

            @Override
            public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place2) {
                if (processor2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (place2 == null) {
                    6.$$$reportNull$$$0(2);
                }
                return processor2.execute(new LightVariableBuilder("xxx", varType, place2), ResolveState.initial());
            }

            public PsiElement getParent() {
                return place;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "place";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/JavaCompletionUtil$6";
                objectArray[2] = "processDeclarations";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static String escapeXmlIfNeeded(InsertionContext context, String generics) {
        if (context.getFile().getViewProvider().getBaseLanguage() == StdLanguages.JSPX) {
            return StringUtil.escapeXml((String)generics);
        }
        return generics;
    }

    public static boolean isEffectivelyDeprecated(PsiDocCommentOwner member) {
        if (member.isDeprecated()) {
            return true;
        }
        for (PsiClass aClass = member.getContainingClass(); aClass != null; aClass = aClass.getContainingClass()) {
            if (!aClass.isDeprecated()) continue;
            return true;
        }
        return false;
    }

    public static int findQualifiedNameStart(@NotNull InsertionContext context) {
        char ch;
        int start;
        if (context == null) {
            JavaCompletionUtil.$$$reportNull$$$0(29);
        }
        for (start = context.getTailOffset() - 1; start >= 0 && (Character.isJavaIdentifierPart(ch = context.getDocument().getCharsSequence().charAt(start)) || ch == '.'); --start) {
        }
        return start + 1;
    }

    private static /* synthetic */ void lambda$processJavaQualifiedReference$4(Set mentioned, JavaCompletionProcessor processor2, Set set2, StaticMemberProcessor memberProcessor, PsiMember member, PsiClass psiClass) {
        if (!mentioned.contains(member) && processor2.satisfies((PsiElement)member, ResolveState.initial())) {
            ContainerUtil.addIfNotNull((Collection)set2, (Object)memberProcessor.createLookupElement(member, psiClass, true));
        }
    }

    private static /* synthetic */ void lambda$processJavaReference$3(int parameterIndex, PsiElement element, Set set2, ElementFilter elementFilter, JavaCompletionProcessor.Options options, PrefixMatcher matcher, CompletionParameters parameters2, PsiType functionalInterfaceType) {
        PsiType qualifierType = LambdaUtil.getLambdaParameterFromType((PsiType)functionalInterfaceType, (int)parameterIndex);
        if (qualifierType instanceof PsiWildcardType) {
            qualifierType = ((PsiWildcardType)qualifierType).getBound();
        }
        if (qualifierType == null) {
            return;
        }
        PsiReferenceExpression fakeRef = JavaCompletionUtil.createReference("xxx.xxx", (PsiElement)JavaCompletionUtil.createContextWithXxxVariable(element, qualifierType));
        set2.addAll(JavaCompletionUtil.processJavaQualifiedReference(fakeRef.getReferenceNameElement(), (PsiJavaReference)fakeRef, elementFilter, options, matcher, parameters2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 16: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "originalize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createReference";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "castQualifier";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInExcludedPackage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "originalize";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedMemberReferenceType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "castQualifier";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "highlightIfNeeded";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldMarkRed";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "containsMember";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isConstructorCompletable";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllLookupStrings";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "insertClassReference";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createContextWithXxxVariable";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findQualifiedNameStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

