/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeArgumentCompletionProvider
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> IN_TYPE_ARGS = PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.TypeArgumentCompletionProvider");
    private final boolean mySmart;
    @Nullable
    private final JavaCompletionSession mySession;

    TypeArgumentCompletionProvider(boolean smart, @Nullable JavaCompletionSession session2) {
        this.mySmart = smart;
        this.mySession = session2;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext processingContext, @NotNull CompletionResultSet resultSet) {
        if (parameters2 == null) {
            TypeArgumentCompletionProvider.$$$reportNull$$$0(0);
        }
        if (resultSet == null) {
            TypeArgumentCompletionProvider.$$$reportNull$$$0(1);
        }
        this.addTypeArgumentVariants(parameters2, (Consumer<LookupElement>)resultSet, resultSet.getPrefixMatcher());
    }

    void addTypeArgumentVariants(CompletionParameters parameters2, Consumer<LookupElement> result2, PrefixMatcher matcher) {
        Pair<PsiTypeParameterListOwner, Integer> pair2 = TypeArgumentCompletionProvider.getTypeParameterInfo(parameters2.getPosition());
        if (pair2 == null) {
            return;
        }
        PsiTypeParameterListOwner paramOwner = (PsiTypeParameterListOwner)pair2.first;
        if (this.suggestByExpectedType(result2, parameters2.getPosition(), paramOwner, (Integer)pair2.second)) {
            return;
        }
        if (this.mySmart && paramOwner instanceof PsiClass) {
            TypeArgumentCompletionProvider.addInheritors(parameters2, result2, (PsiClass)paramOwner, (Integer)pair2.second, matcher);
        }
    }

    private boolean suggestByExpectedType(Consumer<LookupElement> result2, PsiElement context, PsiTypeParameterListOwner paramOwner, int index) {
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)context, PsiExpression.class, (boolean)true);
        ExpectedTypeInfo[] types = ExpectedTypesProvider.getExpectedTypes(expression2, true, false, false);
        if (expression2 == null || types.length == 0) {
            return false;
        }
        for (ExpectedTypeInfo info : types) {
            PsiType type2 = info.getType();
            if (!(type2 instanceof PsiClassType) || type2.equals(expression2.getType())) continue;
            JBIterable remainingParams = JBIterable.of((Object[])paramOwner.getTypeParameters()).skip(index);
            List<PsiType> expectedArgs = CodeInsightUtil.getExpectedTypeArgs(context, paramOwner, (Iterable<PsiTypeParameter>)remainingParams, (PsiClassType)type2);
            this.createLookupItems(result2, context, info, expectedArgs, paramOwner);
        }
        return true;
    }

    private void createLookupItems(Consumer<LookupElement> result2, PsiElement context, ExpectedTypeInfo info, List<PsiType> expectedArgs, PsiTypeParameterListOwner paramOwner) {
        if (expectedArgs.contains(null)) {
            PsiType arg = expectedArgs.get(0);
            if (arg != null) {
                result2.consume(TailTypeDecorator.withTail(PsiTypeLookupItem.createLookupItem(arg, context), TypeArgumentCompletionProvider.getTail(expectedArgs.size() == 1)));
            }
        } else {
            this.fillAllArgs(result2, context, info, expectedArgs, paramOwner);
        }
    }

    private void fillAllArgs(Consumer<LookupElement> resultSet, PsiElement context, ExpectedTypeInfo info, List<PsiType> expectedArgs, PsiTypeParameterListOwner paramOwner) {
        List typeItems = ContainerUtil.map(expectedArgs, arg -> PsiTypeLookupItem.createLookupItem(arg, context));
        TailType globalTail = this.mySmart ? info.getTailType() : TailType.NONE;
        TypeArgsLookupElement element = new TypeArgsLookupElement(typeItems, globalTail, TypeArgumentCompletionProvider.hasParameters(paramOwner, context));
        element.registerSingleClass(this.mySession);
        resultSet.consume((Object)element);
    }

    private static boolean hasParameters(PsiTypeParameterListOwner paramOwner, PsiElement context) {
        return paramOwner instanceof PsiClass && ConstructorInsertHandler.hasConstructorParameters((PsiClass)paramOwner, context);
    }

    private static void addInheritors(CompletionParameters parameters2, Consumer<LookupElement> resultSet, PsiClass referencedClass, int parameterIndex, PrefixMatcher matcher) {
        List<PsiClassType> typeList = Collections.singletonList((PsiClassType)TypeConversionUtil.typeParameterErasure((PsiTypeParameter)referencedClass.getTypeParameters()[parameterIndex]));
        JavaInheritorsGetter.processInheritors(parameters2, typeList, matcher, (Consumer<PsiType>)((Consumer)type2 -> {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
            if (psiClass == null) {
                return;
            }
            resultSet.consume(TailTypeDecorator.withTail(new JavaPsiClassReferenceElement(psiClass), TypeArgumentCompletionProvider.getTail(parameterIndex == referencedClass.getTypeParameters().length - 1)));
        }));
    }

    private static TailType getTail(boolean last) {
        return last ? new CharTailType('>') : TailType.COMMA;
    }

    @Nullable
    static Pair<PsiTypeParameterListOwner, Integer> getTypeParameterInfo(PsiElement context) {
        int parameterIndex;
        PsiReferenceParameterList parameterList = (PsiReferenceParameterList)PsiTreeUtil.getContextOfType((PsiElement)context, PsiReferenceParameterList.class, (boolean)true);
        if (parameterList == null) {
            return null;
        }
        PsiElement parent = parameterList.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return null;
        }
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
        int index = 0;
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getContextOfType((PsiElement)context, PsiTypeElement.class, (boolean)true);
        if (typeElement != null) {
            PsiTypeElement element;
            PsiTypeElement[] elements = referenceElement.getParameterList().getTypeParameterElements();
            while (index < elements.length && (element = elements[index++]) != typeElement) {
            }
        }
        if ((parameterIndex = index - 1) < 0) {
            return null;
        }
        PsiElement target2 = referenceElement.resolve();
        if (!(target2 instanceof PsiClass) && !(target2 instanceof PsiMethod)) {
            return null;
        }
        PsiTypeParameterListOwner referencedClass = (PsiTypeParameterListOwner)target2;
        PsiTypeParameter[] typeParameters = referencedClass.getTypeParameters();
        if (typeParameters.length <= parameterIndex) {
            return null;
        }
        return Pair.create((Object)referencedClass, (Object)parameterIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "resultSet";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/TypeArgumentCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TypeArgsLookupElement
    extends LookupElement {
        private final String myLookupString;
        private final List<PsiTypeLookupItem> myTypeItems;
        private final TailType myGlobalTail;
        private final boolean myHasParameters;

        public TypeArgsLookupElement(List<PsiTypeLookupItem> typeItems, TailType globalTail, boolean hasParameters) {
            this.myTypeItems = typeItems;
            this.myGlobalTail = globalTail;
            this.myHasParameters = hasParameters;
            this.myLookupString = StringUtil.join(this.myTypeItems, item -> item.getType().getPresentableText(), (String)", ");
        }

        @NotNull
        public Object getObject() {
            Object t = this.myTypeItems.get(0).getObject();
            if (t == null) {
                TypeArgsLookupElement.$$$reportNull$$$0(0);
            }
            return t;
        }

        public void registerSingleClass(@Nullable JavaCompletionSession inheritors) {
            PsiType type2;
            PsiClass aClass;
            if (inheritors != null && this.myTypeItems.size() == 1 && (aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(type2 = this.myTypeItems.get(0).getType()))) != null && !aClass.hasTypeParameters()) {
                this.myTypeItems.get(0).setShowPackage();
                inheritors.registerClass(aClass);
            }
        }

        @NotNull
        public String getLookupString() {
            String string = this.myLookupString;
            if (string == null) {
                TypeArgsLookupElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void renderElement(LookupElementPresentation presentation) {
            this.myTypeItems.get(0).renderElement(presentation);
            presentation.setItemText(this.getLookupString());
            if (this.myTypeItems.size() > 1) {
                presentation.setTailText(null);
                presentation.setTypeText(null);
            }
        }

        public void handleInsert(InsertionContext context) {
            PsiTypeElement[] typeElements;
            context.commitDocument();
            PsiReferenceParameterList list2 = (PsiReferenceParameterList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiReferenceParameterList.class, (boolean)false);
            PsiTypeElement[] psiTypeElementArray = typeElements = list2 != null ? list2.getTypeParameterElements() : PsiTypeElement.EMPTY_ARRAY;
            if (typeElements.length == 0) {
                return;
            }
            int listEnd = typeElements[typeElements.length - 1].getTextRange().getEndOffset();
            context.setTailOffset(listEnd);
            context.getDocument().deleteString(context.getStartOffset(), listEnd);
            for (int i = 0; i < this.myTypeItems.size(); ++i) {
                PsiTypeLookupItem typeItem = this.myTypeItems.get(i);
                CompletionUtil.emulateInsertion(context, context.getTailOffset(), (LookupElement)typeItem);
                if (context.getTailOffset() < 0) {
                    LOG.error("tail offset spoiled by " + typeItem);
                    return;
                }
                context.setTailOffset(TypeArgumentCompletionProvider.getTail(i == this.myTypeItems.size() - 1).processTail(context.getEditor(), context.getTailOffset()));
            }
            context.setAddCompletionChar(false);
            context.commitDocument();
            PsiElement leaf = context.getFile().findElementAt(context.getTailOffset() - 1);
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceParameterList.class, PsiJavaCodeReferenceElement.class, PsiNewExpression.class})).accepts((Object)leaf)) {
                ParenthesesInsertHandler.getInstance((boolean)this.myHasParameters).handleInsert(context, (LookupElement)this);
                this.myGlobalTail.processTail(context.getEditor(), context.getTailOffset());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TypeArgsLookupElement element = (TypeArgsLookupElement)((Object)o);
            return this.myTypeItems.equals(element.myTypeItems);
        }

        public int hashCode() {
            return this.myTypeItems.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/completion/TypeArgumentCompletionProvider$TypeArgsLookupElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

