/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.TransparentInstruction;
import com.intellij.codeInsight.controlflow.impl.ConditionalInstructionImpl;
import com.intellij.codeInsight.controlflow.impl.ControlFlowImpl;
import com.intellij.codeInsight.controlflow.impl.InstructionImpl;
import com.intellij.codeInsight.controlflow.impl.TransparentInstructionImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowBuilder {
    public List<Instruction> instructions = ContainerUtil.newArrayList();
    public Instruction prevInstruction;
    public List<Pair<PsiElement, Instruction>> pending = ContainerUtil.newArrayList();
    public int instructionCount = 0;
    public int transparentInstructionCount = 0;

    @Nullable
    public Instruction findInstructionByElement(PsiElement element) {
        for (int i = this.instructions.size() - 1; i >= 0; --i) {
            Instruction instruction = this.instructions.get(i);
            if (!element.equals(instruction.getElement())) continue;
            return instruction;
        }
        return null;
    }

    @NotNull
    public ControlFlow getControlFlow() {
        ControlFlowImpl controlFlowImpl = new ControlFlowImpl(this.instructions.toArray(new Instruction[0]));
        if (controlFlowImpl == null) {
            ControlFlowBuilder.$$$reportNull$$$0(0);
        }
        return controlFlowImpl;
    }

    @NotNull
    public ControlFlow getCompleteControlFlow() {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Instruction instruction : this.instructions) {
            if (instruction instanceof TransparentInstruction) {
                Collection predecessors = instruction.allPred();
                Collection successors = instruction.allSucc();
                for (Instruction predecessor : predecessors) {
                    successors.forEach(successor -> this.addEdge(predecessor, (Instruction)successor));
                }
                predecessors.forEach(el -> el.allSucc().remove(instruction));
                successors.forEach(el -> el.allPred().remove(instruction));
                continue;
            }
            result2.add(instruction);
        }
        ControlFlowImpl controlFlowImpl = new ControlFlowImpl(result2.toArray(new Instruction[0]));
        if (controlFlowImpl == null) {
            ControlFlowBuilder.$$$reportNull$$$0(1);
        }
        return controlFlowImpl;
    }

    public void addEdge(@Nullable Instruction beginInstruction, @Nullable Instruction endInstruction) {
        if (beginInstruction == null || endInstruction == null) {
            return;
        }
        if (!beginInstruction.allSucc().contains(endInstruction)) {
            beginInstruction.allSucc().add(endInstruction);
        }
        if (!endInstruction.allPred().contains(beginInstruction)) {
            endInstruction.allPred().add(beginInstruction);
        }
    }

    public void addNode(@NotNull Instruction instruction) {
        if (instruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(2);
        }
        this.instructions.add(instruction);
        if (this.prevInstruction != null) {
            this.addEdge(this.prevInstruction, instruction);
        }
        this.prevInstruction = instruction;
    }

    public void addNodeAndCheckPending(Instruction instruction) {
        this.addNode(instruction);
        this.checkPending(instruction);
    }

    public void flowAbrupted() {
        this.prevInstruction = null;
    }

    public void addPendingEdge(@Nullable PsiElement pendingScope, @Nullable Instruction instruction) {
        int i;
        if (instruction == null) {
            return;
        }
        if (pendingScope != null) {
            Pair<PsiElement, Instruction> pair2;
            PsiElement scope;
            for (i = 0; i < this.pending.size() && ((scope = (PsiElement)(pair2 = this.pending.get(i)).getFirst()) == null || PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)pendingScope, (boolean)true)); ++i) {
            }
        }
        this.pending.add(i, (Pair<PsiElement, Instruction>)Pair.create((Object)pendingScope, (Object)instruction));
    }

    public void checkPending(@NotNull Instruction instruction) {
        PsiElement element;
        if (instruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(3);
        }
        if ((element = instruction.getElement()) == null) {
            for (Pair<PsiElement, Instruction> pair2 : this.pending) {
                this.addEdge((Instruction)pair2.getSecond(), instruction);
            }
            this.pending.clear();
        } else {
            for (int i = this.pending.size() - 1; i >= 0; --i) {
                Pair<PsiElement, Instruction> pair3 = this.pending.get(i);
                PsiElement scopeWhenToAdd = (PsiElement)pair3.getFirst();
                if (scopeWhenToAdd == null) continue;
                if (PsiTreeUtil.isAncestor((PsiElement)scopeWhenToAdd, (PsiElement)element, (boolean)false)) break;
                this.addEdge((Instruction)pair3.getSecond(), instruction);
                this.pending.remove(i);
            }
        }
    }

    @NotNull
    public Instruction startNode(@Nullable PsiElement element) {
        InstructionImpl instruction = new InstructionImpl(this, element);
        this.addNodeAndCheckPending(instruction);
        InstructionImpl instructionImpl = instruction;
        if (instructionImpl == null) {
            ControlFlowBuilder.$$$reportNull$$$0(4);
        }
        return instructionImpl;
    }

    @NotNull
    public TransparentInstruction startTransparentNode(@Nullable PsiElement element, String markerName) {
        TransparentInstructionImpl instruction = new TransparentInstructionImpl(this, element, markerName);
        this.addNodeAndCheckPending(instruction);
        TransparentInstructionImpl transparentInstructionImpl = instruction;
        if (transparentInstructionImpl == null) {
            ControlFlowBuilder.$$$reportNull$$$0(5);
        }
        return transparentInstructionImpl;
    }

    public Instruction startConditionalNode(PsiElement element, PsiElement condition2, boolean result2) {
        ConditionalInstructionImpl instruction = new ConditionalInstructionImpl(this, element, condition2, result2);
        this.addNodeAndCheckPending(instruction);
        return instruction;
    }

    public ControlFlow build(PsiElementVisitor visitor, PsiElement element) {
        this.addEntryPointNode(element);
        element.acceptChildren(visitor);
        this.checkPending(this.startNode(null));
        List<Instruction> result2 = this.instructions;
        return new ControlFlowImpl(result2.toArray(new Instruction[result2.size()]));
    }

    protected void addEntryPointNode(PsiElement startElement) {
        this.startNode(null);
    }

    public void updatePendingElementScope(@NotNull PsiElement parentForScope, @NotNull PsiElement newParentScope) {
        if (parentForScope == null) {
            ControlFlowBuilder.$$$reportNull$$$0(6);
        }
        if (newParentScope == null) {
            ControlFlowBuilder.$$$reportNull$$$0(7);
        }
        this.processPending((pendingScope, instruction) -> {
            if (parentForScope == null) {
                ControlFlowBuilder.$$$reportNull$$$0(8);
            }
            if (newParentScope == null) {
                ControlFlowBuilder.$$$reportNull$$$0(9);
            }
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)parentForScope, (PsiElement)pendingScope, (boolean)false)) {
                this.addPendingEdge(newParentScope, instruction);
            } else {
                this.addPendingEdge(pendingScope, instruction);
            }
        });
    }

    public void processPending(PendingProcessor processor2) {
        List<Pair<PsiElement, Instruction>> pending = this.pending;
        this.pending = new ArrayList<Pair<PsiElement, Instruction>>();
        for (Pair<PsiElement, Instruction> pair2 : pending) {
            processor2.process((PsiElement)pair2.getFirst(), (Instruction)pair2.getSecond());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/controlflow/ControlFlowBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentForScope";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParentScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompleteControlFlow";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/controlflow/ControlFlowBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "startNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "startTransparentNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkPending";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updatePendingElementScope";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updatePendingElementScope$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface PendingProcessor {
        public void process(@Nullable PsiElement var1, @NotNull Instruction var2);
    }
}

