/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChameleonSyntaxHighlightingPass
extends GeneralHighlightingPass {
    ChameleonSyntaxHighlightingPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Document document, @NotNull ProperTextRange restrictRange, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project2 == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(1);
        }
        if (document == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(2);
        }
        if (restrictRange == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(3);
        }
        if (priorityRange == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(4);
        }
        if (highlightInfoProcessor == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(5);
        }
        super(project2, file2, document, restrictRange.getStartOffset(), restrictRange.getEndOffset(), true, priorityRange, editor, highlightInfoProcessor);
    }

    @Override
    public void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(6);
        }
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)this.myFile).filter(o -> {
            IElementType type2 = PsiUtilCore.getElementType((PsiElement)o);
            return type2 instanceof ILazyParseableElementType && !(type2 instanceof IFileElementType);
        });
        ArrayList lazyOutside = ContainerUtil.newArrayListWithCapacity((int)100);
        ArrayList lazyInside = ContainerUtil.newArrayListWithCapacity((int)100);
        ArrayList outside = ContainerUtil.newArrayListWithCapacity((int)100);
        ArrayList inside = ContainerUtil.newArrayListWithCapacity((int)100);
        for (PsiElement e : s) {
            (e.getTextRange().intersects((TextRange)this.myPriorityRange) ? lazyInside : lazyOutside).add(e);
        }
        for (PsiElement e : lazyInside) {
            this.collectHighlights(e, inside, outside, this.myPriorityRange);
        }
        this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), inside, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
        for (PsiElement e : lazyOutside) {
            this.collectHighlights(e, inside, outside, this.myPriorityRange);
        }
        this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), outside, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
        this.myHighlights.addAll(inside);
        this.myHighlights.addAll(outside);
    }

    private void collectHighlights(@NotNull PsiElement element, @NotNull List<HighlightInfo> inside, @NotNull List<HighlightInfo> outside, @NotNull ProperTextRange priorityRange) {
        if (element == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(7);
        }
        if (inside == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(8);
        }
        if (outside == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(9);
        }
        if (priorityRange == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(10);
        }
        EditorColorsScheme scheme2 = (EditorColorsScheme)ObjectUtils.notNull((Object)this.getColorsScheme(), (Object)EditorColorsManager.getInstance().getGlobalScheme());
        TextAttributes defaultAttrs = scheme2.getAttributes(HighlighterColors.TEXT);
        Language language = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)element.getNode());
        if (language == null) {
            return;
        }
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)this.myProject, (VirtualFile)this.myFile.getVirtualFile());
        for (PsiElement token : SyntaxTraverser.psiTraverser((PsiElement)element).traverse(TreeTraversal.LEAVES_DFS)) {
            TextAttributes forcedAttributes;
            TextRange tr = token.getTextRange();
            if (tr.isEmpty()) continue;
            IElementType type2 = PsiUtilCore.getElementType((PsiElement)token);
            TextAttributesKey[] keys = syntaxHighlighter.getTokenHighlights(type2);
            TextAttributes attributes = null;
            for (TextAttributesKey key2 : keys) {
                TextAttributes attrs2 = scheme2.getAttributes(key2);
                if (attrs2 == null) continue;
                attributes = attributes == null ? attrs2 : TextAttributes.merge((TextAttributes)attributes, (TextAttributes)attrs2);
            }
            if (attributes == null || attributes.isEmpty() || attributes.equals((Object)defaultAttrs)) {
                forcedAttributes = TextAttributes.ERASE_MARKER;
            } else {
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(tr).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally();
                (priorityRange.contains(tr) ? inside : outside).add(info);
                forcedAttributes = new TextAttributes(attributes.getForegroundColor(), attributes.getBackgroundColor(), attributes.getEffectColor(), attributes.getEffectType(), attributes.getFontType());
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(tr).textAttributes(forcedAttributes).createUnconditionally();
            (priorityRange.contains(tr) ? inside : outside).add(info);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
    }

    @Override
    @Nullable
    protected String getPresentableName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformationWithProgress";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "collectHighlights";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Factory
    extends AbstractProjectComponent
    implements MainHighlightingPassFactory {
        protected Factory(Project project2, TextEditorHighlightingPassRegistrar registrar) {
            super(project2);
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
        }

        @Override
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
            TextRange restrict;
            if (file2 == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                Factory.$$$reportNull$$$0(1);
            }
            if ((restrict = FileStatusMap.getDirtyTextRange(editor, 4)) == null) {
                return new ProgressableTextEditorHighlightingPass.EmptyPass(this.myProject, editor.getDocument());
            }
            ProperTextRange priority = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
            return new ChameleonSyntaxHighlightingPass(this.myProject, file2, editor.getDocument(), ProperTextRange.create((Segment)restrict), priority, editor, new DefaultHighlightInfoProcessor());
        }

        @Override
        @Nullable
        public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
            if (file2 == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (document == null) {
                Factory.$$$reportNull$$$0(3);
            }
            if (highlightInfoProcessor == null) {
                Factory.$$$reportNull$$$0(4);
            }
            ProperTextRange range = ProperTextRange.from((int)0, (int)document.getTextLength());
            return new ChameleonSyntaxHighlightingPass(this.myProject, file2, document, range, range, null, highlightInfoProcessor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightInfoProcessor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass$Factory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHighlightingPass";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createMainHighlightingPass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

