/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DaemonCodeAnalyzerEx
extends DaemonCodeAnalyzer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx");

    public static DaemonCodeAnalyzerEx getInstanceEx(Project project2) {
        return (DaemonCodeAnalyzerEx)((Object)project2.getComponent(DaemonCodeAnalyzer.class));
    }

    public static boolean processHighlights(@NotNull Document document, @NotNull Project project2, @Nullable(value="null means all") HighlightSeverity minSeverity, int startOffset, int endOffset, @NotNull Processor<HighlightInfo> processor2) {
        if (document == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        return model.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)marker -> {
            if (processor2 == null) {
                DaemonCodeAnalyzerEx.$$$reportNull$$$0(9);
            }
            ProgressManager.checkCanceled();
            Object tt = marker.getErrorStripeTooltip();
            if (!(tt instanceof HighlightInfo)) {
                return true;
            }
            HighlightInfo info = (HighlightInfo)tt;
            return minSeverity != null && severityRegistrar.compare(info.getSeverity(), minSeverity) < 0 || info.getHighlighter() == null || processor2.process((Object)info);
        }));
    }

    static boolean processHighlightsOverlappingOutside(@NotNull Document document, @NotNull Project project2, @Nullable(value="null means all") HighlightSeverity minSeverity, int startOffset, int endOffset, @NotNull Processor<HighlightInfo> processor2) {
        if (document == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        return model.processRangeHighlightersOutside(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)marker -> {
            Object tt;
            if (processor2 == null) {
                DaemonCodeAnalyzerEx.$$$reportNull$$$0(8);
            }
            if (!((tt = marker.getErrorStripeTooltip()) instanceof HighlightInfo)) {
                return true;
            }
            HighlightInfo info = (HighlightInfo)tt;
            return minSeverity != null && severityRegistrar.compare(info.getSeverity(), minSeverity) < 0 || info.getHighlighter() == null || processor2.process((Object)info);
        }));
    }

    static boolean hasErrors(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(6);
        }
        if (document == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(7);
        }
        return !DaemonCodeAnalyzerEx.processHighlights(document, project2, HighlightSeverity.ERROR, 0, document.getTextLength(), (Processor<HighlightInfo>)CommonProcessors.alwaysFalse());
    }

    @NotNull
    public abstract List<HighlightInfo> runMainPasses(@NotNull PsiFile var1, @NotNull Document var2, @NotNull ProgressIndicator var3);

    public abstract boolean isErrorAnalyzingFinished(@NotNull PsiFile var1);

    @NotNull
    public abstract FileStatusMap getFileStatusMap();

    @NotNull
    public abstract List<HighlightInfo> getFileLevelHighlights(@NotNull Project var1, @NotNull PsiFile var2);

    public abstract void cleanFileLevelHighlights(@NotNull Project var1, int var2, PsiFile var3);

    public abstract void addFileLevelHighlight(@NotNull Project var1, int var2, @NotNull HighlightInfo var3, @NotNull PsiFile var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processHighlights";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processHighlightsOverlappingOutside";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasErrors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processHighlightsOverlappingOutside$1";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processHighlights$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

