/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.IconUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GutterIntentionAction
extends AbstractIntentionAction
implements Comparable<IntentionAction>,
Iconable,
ShortcutProvider {
    private final AnAction myAction;
    private final int myOrder;
    private final Icon myIcon;
    private String myText;

    private GutterIntentionAction(AnAction action, int order, Icon icon) {
        this.myAction = action;
        this.myOrder = order;
        this.myIcon = icon;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            GutterIntentionAction.$$$reportNull$$$0(0);
        }
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        this.myAction.actionPerformed(new AnActionEvent((InputEvent)relativePoint.toMouseEvent(), ((EditorEx)editor).getDataContext(), this.myText, new Presentation(), ActionManager.getInstance(), 0));
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            GutterIntentionAction.$$$reportNull$$$0(1);
        }
        return this.myText != null ? StringUtil.isNotEmpty((String)this.myText) : this.isAvailable(GutterIntentionAction.createActionEvent((EditorEx)editor));
    }

    @NotNull
    private static AnActionEvent createActionEvent(EditorEx editor) {
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)editor.getDataContext());
        if (anActionEvent == null) {
            GutterIntentionAction.$$$reportNull$$$0(2);
        }
        return anActionEvent;
    }

    private boolean isAvailable(@NotNull AnActionEvent event) {
        if (event == null) {
            GutterIntentionAction.$$$reportNull$$$0(3);
        }
        if (this.myText == null) {
            String text2;
            this.myAction.update(event);
            this.myText = event.getPresentation().isEnabled() && event.getPresentation().isVisible() ? ((text2 = event.getPresentation().getText()) != null ? text2 : StringUtil.notNullize((String)this.myAction.getTemplatePresentation().getText())) : "";
        }
        return StringUtil.isNotEmpty((String)this.myText);
    }

    @NotNull
    public String getText() {
        String string = StringUtil.notNullize((String)this.myText);
        if (string == null) {
            GutterIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    static void addActions(@NotNull Editor hostEditor, @NotNull ShowIntentionsPass.IntentionsInfo intentions, Project project2, List<RangeHighlighterEx> result2) {
        if (hostEditor == null) {
            GutterIntentionAction.$$$reportNull$$$0(5);
        }
        if (intentions == null) {
            GutterIntentionAction.$$$reportNull$$$0(6);
        }
        AnActionEvent event = GutterIntentionAction.createActionEvent((EditorEx)hostEditor);
        for (RangeHighlighterEx highlighter : result2) {
            GutterIntentionAction.addActions(project2, highlighter, intentions.guttersToShow, event);
        }
    }

    private static void addActions(@NotNull Project project2, @NotNull RangeHighlighterEx info, @NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull AnActionEvent event) {
        GutterIconRenderer r;
        if (project2 == null) {
            GutterIntentionAction.$$$reportNull$$$0(7);
        }
        if (info == null) {
            GutterIntentionAction.$$$reportNull$$$0(8);
        }
        if (descriptors == null) {
            GutterIntentionAction.$$$reportNull$$$0(9);
        }
        if (event == null) {
            GutterIntentionAction.$$$reportNull$$$0(10);
        }
        if ((r = info.getGutterIconRenderer()) == null || DumbService.isDumb((Project)project2) && !DumbService.isDumbAware((Object)r)) {
            return;
        }
        ArrayList<HighlightInfo.IntentionActionDescriptor> list2 = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        for (AnAction action : (AnAction[])ContainerUtil.ar((Object[])new AnAction[]{r.getClickAction(), r.getMiddleButtonClickAction(), r.getRightButtonClickAction(), r.getPopupMenuActions()})) {
            if (action == null) continue;
            GutterIntentionAction.addActions(action, list2, r, 0, event);
        }
        if (list2.isEmpty()) {
            return;
        }
        if (list2.size() == 1) {
            descriptors.addAll(list2);
        } else {
            HighlightInfo.IntentionActionDescriptor first = (HighlightInfo.IntentionActionDescriptor)list2.get(0);
            List options = ContainerUtil.map(list2.subList(1, list2.size()), HighlightInfo.IntentionActionDescriptor::getAction);
            descriptors.add(new HighlightInfo.IntentionActionDescriptor(first.getAction(), options, null, first.getIcon()));
        }
    }

    private static void addActions(@NotNull AnAction action, @NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull GutterIconRenderer renderer, int order, @NotNull AnActionEvent event) {
        GutterIntentionAction gutterAction;
        Icon icon;
        if (action == null) {
            GutterIntentionAction.$$$reportNull$$$0(11);
        }
        if (descriptors == null) {
            GutterIntentionAction.$$$reportNull$$$0(12);
        }
        if (renderer == null) {
            GutterIntentionAction.$$$reportNull$$$0(13);
        }
        if (event == null) {
            GutterIntentionAction.$$$reportNull$$$0(14);
        }
        if (action instanceof ActionGroup) {
            AnAction[] children2 = ((ActionGroup)action).getChildren(null);
            for (int i = 0; i < children2.length; ++i) {
                GutterIntentionAction.addActions(children2[i], descriptors, renderer, i + order, event);
            }
        }
        if ((icon = action.getTemplatePresentation().getIcon()) == null) {
            icon = renderer.getIcon();
        }
        if (icon.getIconWidth() < 16) {
            icon = IconUtil.toSize((Icon)icon, (int)16, (int)16);
        }
        if (!(gutterAction = new GutterIntentionAction(action, order, icon)).isAvailable(event)) {
            return;
        }
        descriptors.add(new HighlightInfo.IntentionActionDescriptor((IntentionAction)gutterAction, Collections.emptyList(), null, icon){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = gutterAction.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction$1", "getDisplayName"));
            }
        });
    }

    @Override
    public int compareTo(@NotNull IntentionAction o) {
        if (o == null) {
            GutterIntentionAction.$$$reportNull$$$0(15);
        }
        if (o instanceof GutterIntentionAction) {
            return this.myOrder - ((GutterIntentionAction)o).myOrder;
        }
        return 0;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return this.myIcon;
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.myAction.getShortcutSet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/GutterIntentionAction";
                break;
            }
            case 3: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/GutterIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionEvent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

