/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ProjectIconsAccessor;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.evaluation.UEvaluationContextKt;
import org.jetbrains.uast.values.UCallResultValue;
import org.jetbrains.uast.values.UConstant;
import org.jetbrains.uast.values.UStringConstant;
import org.jetbrains.uast.values.UValue;
import org.jetbrains.uast.values.UValueKt;

public class IconLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            IconLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            IconLineMarkerProvider.$$$reportNull$$$0(1);
        }
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        UIdentifier identifier;
        Collection constants;
        List psiElements;
        List arguments;
        UCallExpression expression2;
        if (element == null) {
            IconLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if ((expression2 = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class)) == null) {
            return null;
        }
        if (!ProjectIconsAccessor.isIconClassType(expression2.getExpressionType())) {
            return null;
        }
        UValue uValue = UEvaluationContextKt.uValueOf((UExpression)expression2);
        if (uValue instanceof UCallResultValue && (arguments = ((UCallResultValue)uValue).getArguments()).size() > 0 && (psiElements = UastUtils.toPsiElements((Collection)(constants = (Collection)UValueKt.toPossibleConstants((UValue)((UValue)arguments.get(0))).stream().filter(constant -> constant instanceof UStringConstant).map(UConstant::getSource).collect(Collectors.toList())))).size() > 0 && (identifier = expression2.getMethodIdentifier()) != null) {
            return IconLineMarkerProvider.createIconLineMarker((PsiElement)psiElements.get(0), identifier.getPsi());
        }
        return null;
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> createIconLineMarker(@Nullable PsiElement initializer, PsiElement bindingElement) {
        if (initializer == null) {
            return null;
        }
        final Project project2 = initializer.getProject();
        final VirtualFile file2 = ProjectIconsAccessor.getInstance(project2).resolveIconFile(initializer);
        if (file2 == null) {
            return null;
        }
        Icon icon = ProjectIconsAccessor.getInstance(project2).getIcon(file2);
        if (icon == null) {
            return null;
        }
        GutterIconNavigationHandler<PsiElement> navHandler = new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement elt) {
                FileEditorManager.getInstance((Project)project2).openFile(file2, true);
            }
        };
        return new LineMarkerInfo(bindingElement, bindingElement.getTextRange(), icon, 11, null, (GutterIconNavigationHandler)navHandler, GutterIconRenderer.Alignment.LEFT);
    }

    @NotNull
    public String getName() {
        if ("Icon preview" == null) {
            IconLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return "Icon preview";
    }

    public boolean isEnabledByDefault() {
        return DaemonCodeAnalyzerSettings.getInstance().SHOW_SMALL_ICONS_IN_GUTTER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/IconLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/IconLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

