/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSchemaPrefixIntention
extends PsiElementBaseIntentionAction {
    public static final String NAME = "Insert namespace prefix";

    public AddSchemaPrefixIntention() {
        this.setText(NAME);
    }

    @NotNull
    public String getFamilyName() {
        if (NAME == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        XmlAttribute xmlns;
        if (project2 == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(2);
        }
        if ((xmlns = AddSchemaPrefixIntention.getXmlnsDeclaration(element)) == null) {
            return;
        }
        final String namespace = xmlns.getValue();
        final XmlTag tag = xmlns.getParent();
        if (tag != null) {
            final Set ns = tag.getLocalNamespaceDeclarations().keySet();
            final String nsPrefix = Messages.showInputDialog((Project)project2, (String)"Namespace Prefix:", (String)StringUtil.capitalize((String)NAME), (Icon)Messages.getInformationIcon(), (String)"", (InputValidator)new InputValidator(){

                public boolean checkInput(String inputString) {
                    return !ns.contains(inputString);
                }

                public boolean canClose(String inputString) {
                    return this.checkInput(inputString);
                }
            });
            if (nsPrefix == null) {
                return;
            }
            final ArrayList tags = new ArrayList();
            final ArrayList values = new ArrayList();
            new WriteCommandAction(project2, NAME, new PsiFile[]{tag.getContainingFile()}){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    tag.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                        public void visitXmlTag(XmlTag tag) {
                            if (tag.getNamespace().equals(namespace) && tag.getNamespacePrefix().isEmpty()) {
                                tags.add(tag);
                            }
                            super.visitXmlTag(tag);
                        }

                        public void visitXmlAttributeValue(XmlAttributeValue value2) {
                            XmlTag tag;
                            PsiElement xmlElement;
                            PsiReference ref = null;
                            boolean skip = false;
                            for (PsiReference reference : value2.getReferences()) {
                                if (reference instanceof TypeOrElementOrAttributeReference) {
                                    ref = reference;
                                    continue;
                                }
                                if (!(reference instanceof SchemaPrefixReference)) continue;
                                skip = true;
                                break;
                            }
                            if (!skip && ref != null && (xmlElement = ref.resolve()) instanceof XmlElement && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlElement, XmlTag.class, (boolean)false)) != null && tag.getNamespace().equals(namespace) && ref.getRangeInElement().getLength() == value2.getValue().length()) {
                                values.add(value2);
                            }
                        }
                    });
                    for (XmlAttributeValue value2 : values) {
                        ((XmlAttribute)value2.getParent()).setValue(nsPrefix + ":" + value2.getValue());
                    }
                    for (XmlTag xmlTag : tags) {
                        xmlTag.setName(nsPrefix + ":" + xmlTag.getLocalName());
                    }
                    xmlns.setName("xmlns:" + nsPrefix);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/analysis/AddSchemaPrefixIntention$2", "run"));
                }
            }.execute();
        }
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(4);
        }
        return AddSchemaPrefixIntention.getXmlnsDeclaration(element) != null;
    }

    @Nullable
    private static XmlAttribute getXmlnsDeclaration(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof XmlTag) {
            XmlTag tag = (XmlTag)parent;
            if (tag.getNamespacePrefix().isEmpty()) {
                while (tag != null) {
                    XmlAttribute attr = tag.getAttribute("xmlns");
                    if (attr != null) {
                        return attr;
                    }
                    tag = tag.getParentTag();
                }
            }
        } else if (parent instanceof XmlAttribute && ((XmlAttribute)parent).getName().equals("xmlns")) {
            return (XmlAttribute)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/AddSchemaPrefixIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/AddSchemaPrefixIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

