/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlNSRenderer;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlNamespaceHelper;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class ImportNSAction
implements QuestionAction {
    private final List<String> myNamespaces;
    private final XmlFile myFile;
    private final PsiElement myElement;
    private final Editor myEditor;
    private final String myTitle;

    public ImportNSAction(List<String> namespaces, XmlFile file2, @NotNull PsiElement element, Editor editor, String title) {
        if (element == null) {
            ImportNSAction.$$$reportNull$$$0(0);
        }
        this.myNamespaces = namespaces;
        this.myFile = file2;
        this.myElement = element;
        this.myEditor = editor;
        this.myTitle = title;
    }

    public boolean execute() {
        Object[] strings = ArrayUtil.toStringArray(this.myNamespaces);
        JBList list2 = new JBList(strings);
        list2.setCellRenderer(XmlNSRenderer.INSTANCE);
        list2.setSelectedIndex(0);
        int offset = this.myElement.getTextOffset();
        RangeMarker marker = this.myEditor.getDocument().createRangeMarker(offset, offset);
        Runnable runnable2 = () -> this.lambda$execute$0((JList)list2, marker);
        if (list2.getModel().getSize() == 1) {
            runnable2.run();
        } else {
            new PopupChooserBuilder((JList)list2).setTitle(this.myTitle).setItemChoosenCallback(runnable2).createPopup().showInBestPositionFor(this.myEditor);
        }
        return true;
    }

    private /* synthetic */ void lambda$execute$0(JList list2, final RangeMarker marker) {
        final String namespace = (String)list2.getSelectedValue();
        if (namespace != null) {
            Project project2 = this.myFile.getProject();
            new WriteCommandAction.Simple(project2, new PsiFile[]{this.myFile}){

                protected void run() throws Throwable {
                    final XmlNamespaceHelper extension = XmlNamespaceHelper.getHelper((PsiFile)ImportNSAction.this.myFile);
                    String prefix = extension.getNamespacePrefix(ImportNSAction.this.myElement);
                    extension.insertNamespaceDeclaration(ImportNSAction.this.myFile, ImportNSAction.this.myEditor, Collections.singleton(namespace), prefix, new XmlNamespaceHelper.Runner<String, IncorrectOperationException>(){

                        @Override
                        public void run(String s) throws IncorrectOperationException {
                            PsiDocumentManager.getInstance((Project)ImportNSAction.this.myFile.getProject()).doPostponedOperationsAndUnblockDocument(ImportNSAction.this.myEditor.getDocument());
                            PsiElement element = ImportNSAction.this.myFile.findElementAt(marker.getStartOffset());
                            if (element != null) {
                                extension.qualifyWithPrefix(s, element, ImportNSAction.this.myEditor.getDocument());
                            }
                        }
                    });
                }
            }.execute();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ImportNSAction", "<init>"));
    }
}

