/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.xml.XmlAttributeDescriptor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class XmlDefaultAttributeValueInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlDefaultAttributeValueInspection.$$$reportNull$$$0(0);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value2) {
                PsiElement parent = value2.getParent();
                if (!(parent instanceof XmlAttribute)) {
                    return;
                }
                if (parent.getParent() instanceof HtmlTag) {
                    return;
                }
                XmlAttributeDescriptor descriptor2 = ((XmlAttribute)parent).getDescriptor();
                if (descriptor2 == null || descriptor2.isRequired()) {
                    return;
                }
                String defaultValue = descriptor2.getDefaultValue();
                if (defaultValue != null && defaultValue.equals(value2.getValue())) {
                    holder.registerProblem((PsiElement)value2, "Redundant default attribute value assignment", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new LocalQuickFix(){

                        @Nls
                        @NotNull
                        public String getFamilyName() {
                            String string = XmlErrorMessages.message("remove.attribute.quickfix.family", new Object[0]);
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                            XmlAttribute attribute;
                            if (project2 == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (descriptor2 == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if ((attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), XmlAttribute.class)) != null) {
                                attribute.delete();
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 2;
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    n2 = 3;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection$1$1";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "project";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "descriptor";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getFamilyName";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection$1$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray;
                                    objectArray[2] = "applyFix";
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    }});
                }
            }
        };
        if (xmlElementVisitor == null) {
            XmlDefaultAttributeValueInspection.$$$reportNull$$$0(1);
        }
        return xmlElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

