/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddReturnFix
implements IntentionAction {
    private final PsiMethod myMethod;

    public AddReturnFix(@NotNull PsiMethod method) {
        if (method == null) {
            AddReturnFix.$$$reportNull$$$0(0);
        }
        this.myMethod = method;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.return.statement.text", new Object[0]);
        if (string == null) {
            AddReturnFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            AddReturnFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            AddReturnFix.$$$reportNull$$$0(3);
        }
        return this.myMethod.isValid() && this.myMethod.getManager().isInProject((PsiElement)this.myMethod) && this.myMethod.getBody() != null && this.myMethod.getBody().getRBrace() != null;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            AddReturnFix.$$$reportNull$$$0(4);
        }
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            AddReturnFix.$$$reportNull$$$0(5);
        }
        return psiMethod;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            AddReturnFix.$$$reportNull$$$0(6);
        }
        String value2 = this.suggestReturnValue();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
        PsiReturnStatement returnStatement = (PsiReturnStatement)factory.createStatementFromText("return " + value2 + ";", (PsiElement)this.myMethod);
        PsiCodeBlock body2 = this.myMethod.getBody();
        returnStatement = (PsiReturnStatement)body2.addBefore((PsiElement)returnStatement, (PsiElement)body2.getRBrace());
        MethodReturnTypeFix.selectReturnValueInEditor(returnStatement, editor);
    }

    private String suggestReturnValue() {
        String conversion;
        PsiVariable[] variables;
        PsiType type2 = this.myMethod.getReturnType();
        for (PsiVariable variable : variables = AddReturnFix.getDeclaredVariables(this.myMethod)) {
            PsiType varType = variable.getType();
            if (!varType.equals(type2)) continue;
            return variable.getName();
        }
        for (PsiVariable variable : variables) {
            conversion = this.getConversionToType(variable, type2, true);
            if (conversion == null) continue;
            return conversion;
        }
        for (PsiVariable variable : variables) {
            conversion = this.getConversionToType(variable, type2, false);
            if (conversion == null) continue;
            return conversion;
        }
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
    }

    private String getConversionToType(@NotNull PsiVariable variable, @Nullable PsiType type2, boolean preciseTypeReqired) {
        PsiType arrayComponentType;
        if (variable == null) {
            AddReturnFix.$$$reportNull$$$0(7);
        }
        PsiType varType = variable.getType();
        if (type2 instanceof PsiArrayType && !((arrayComponentType = ((PsiArrayType)type2).getComponentType()) instanceof PsiPrimitiveType) && !(PsiUtil.resolveClassInType((PsiType)arrayComponentType) instanceof PsiTypeParameter) && InheritanceUtil.isInheritor((PsiType)varType, (String)"java.util.Collection")) {
            PsiType collectionItemType;
            PsiType erasedComponentType = TypeConversionUtil.erasure((PsiType)arrayComponentType);
            if ((!preciseTypeReqired || arrayComponentType.equals(erasedComponentType)) && (collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)varType, (GlobalSearchScope)this.myMethod.getResolveScope())) != null && erasedComponentType.isAssignableFrom(collectionItemType)) {
                if (erasedComponentType.equalsToText("java.lang.Object")) {
                    return variable.getName() + ".toArray()";
                }
                return variable.getName() + ".toArray(new " + erasedComponentType.getCanonicalText() + "[0])";
            }
        }
        return null;
    }

    @NotNull
    private static PsiVariable[] getDeclaredVariables(PsiMethod method) {
        PsiStatement[] statements;
        ArrayList<PsiVariable> variables = new ArrayList<PsiVariable>();
        for (PsiStatement statement2 : statements = method.getBody().getStatements()) {
            PsiElement[] declaredElements;
            if (!(statement2 instanceof PsiDeclarationStatement)) continue;
            for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)statement2).getDeclaredElements()) {
                if (!(declaredElement instanceof PsiLocalVariable)) continue;
                variables.add((PsiVariable)declaredElement);
            }
        }
        Object[] parameters2 = method.getParameterList().getParameters();
        ContainerUtil.addAll(variables, (Object[])parameters2);
        PsiVariable[] psiVariableArray = variables.toArray(new PsiVariable[variables.size()]);
        if (psiVariableArray == null) {
            AddReturnFix.$$$reportNull$$$0(8);
        }
        return psiVariableArray;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConversionToType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

