/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeCastFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final PsiType myType;

    public AddTypeCastFix(@NotNull PsiType type2, @NotNull PsiExpression expression2) {
        if (type2 == null) {
            AddTypeCastFix.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            AddTypeCastFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)expression2);
        this.myType = type2;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.typecast.text", this.myType.isValid() ? this.myType.getCanonicalText() : "");
        if (string == null) {
            AddTypeCastFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.typecast.family", new Object[0]);
        if (string == null) {
            AddTypeCastFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            AddTypeCastFix.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            AddTypeCastFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            AddTypeCastFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            AddTypeCastFix.$$$reportNull$$$0(7);
        }
        return this.myType.isValid() && PsiTypesUtil.isDenotableType((PsiType)this.myType) && startElement.isValid() && startElement.getManager().isInProject(startElement);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            AddTypeCastFix.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            AddTypeCastFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            AddTypeCastFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            AddTypeCastFix.$$$reportNull$$$0(11);
        }
        AddTypeCastFix.addTypeCast(project2, (PsiExpression)startElement, this.myType);
    }

    private static void addTypeCast(Project project2, PsiExpression originalExpression, PsiType type2) {
        PsiExpression typeCast = AddTypeCastFix.createCastExpression(originalExpression, project2, type2);
        originalExpression.replace((PsiElement)typeCast);
    }

    static PsiExpression createCastExpression(PsiExpression original, Project project2, PsiType type2) {
        PsiExpression expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)original);
        if (expression2 == null) {
            return null;
        }
        if (type2.equals(PsiType.NULL)) {
            return null;
        }
        if (type2 instanceof PsiEllipsisType) {
            type2 = ((PsiEllipsisType)type2).toArrayType();
        }
        String text2 = "(" + type2.getCanonicalText(false) + ")value";
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)original.getProject()).getElementFactory();
        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)factory.createExpressionFromText(text2, (PsiElement)original);
        typeCast = (PsiTypeCastExpression)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)typeCast);
        typeCast = (PsiTypeCastExpression)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)typeCast);
        if (expression2 instanceof PsiConditionalExpression) {
            PsiType elseType;
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2.copy();
            PsiExpression thenE = conditional.getThenExpression();
            PsiExpression elseE = conditional.getElseExpression();
            PsiType thenType = thenE == null ? null : thenE.getType();
            PsiType psiType = elseType = elseE == null ? null : elseE.getType();
            if (elseType != null && thenType != null) {
                boolean replaceElse;
                boolean replaceThen = !TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)thenType);
                boolean bl = replaceElse = !TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)elseType);
                if (replaceThen != replaceElse) {
                    if (replaceThen) {
                        ((PsiExpression)ObjectUtils.assertNotNull((Object)typeCast.getOperand())).replace((PsiElement)thenE);
                        thenE.replace((PsiElement)typeCast);
                    } else {
                        ((PsiExpression)ObjectUtils.assertNotNull((Object)typeCast.getOperand())).replace((PsiElement)elseE);
                        elseE.replace((PsiElement)typeCast);
                    }
                    return conditional;
                }
            }
        }
        ((PsiExpression)ObjectUtils.assertNotNull((Object)typeCast.getOperand())).replace((PsiElement)expression2);
        return typeCast;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

