/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.PsiNavigateUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContext;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001a\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0015\u0010\u0010\u001a\u00020\u000b2\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0004H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R&\u0010\u0002\u001a\u001a\u0012\u0016\u0012\u0014 \t*\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00040\u0003\u00a2\u0006\u0002\b\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFix;", "Lcom/intellij/codeInspection/LocalQuickFixBase;", "containingClass", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/psi/JvmCommon;", "createMethodAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "(Lcom/intellij/psi/PsiClass;Lcom/intellij/codeInsight/intention/IntentionAction;)V", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "reformatAndOpenCreatedMethod", "method", "Lcom/intellij/psi/PsiMethod;", "uastBody", "Lcom/intellij/psi/PsiElement;", "java-impl"})
public final class CreateMethodFix
extends LocalQuickFixBase {
    private final SmartPsiElementPointer<PsiClass> containingClass;
    private final IntentionAction createMethodAction;

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        PsiMethod psiMethod;
        block10: {
            block9: {
                Object object;
                block8: {
                    Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                    Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                    PsiFile psiFile = this.containingClass.getContainingFile();
                    if (psiFile == null) {
                        return;
                    }
                    PsiFile file2 = psiFile;
                    PsiMethod[] psiMethodArray = (PsiMethod[])this.containingClass.getElement();
                    if (psiMethodArray == null || (psiMethodArray = psiMethodArray.getMethods()) == null) {
                        return;
                    }
                    PsiMethod[] methodsBefore = psiMethodArray;
                    this.createMethodAction.invoke(project2, null, file2);
                    psiMethod = (PsiMethod)this.containingClass.getElement();
                    if (psiMethod == null || (psiMethod = psiMethod.getMethods()) == null) break block9;
                    Object[] $receiver$iv = (Object[])psiMethod;
                    for (int i = 0; i < $receiver$iv.length; ++i) {
                        boolean bl;
                        Object element$iv;
                        block7: {
                            element$iv = $receiver$iv[i];
                            PsiMethod method = (PsiMethod)element$iv;
                            Object[] $receiver$iv2 = methodsBefore;
                            for (int j = 0; j < $receiver$iv2.length; ++j) {
                                Object element$iv2 = $receiver$iv2[j];
                                PsiMethod it = (PsiMethod)element$iv2;
                                if (!it.isEquivalentTo((PsiElement)method)) continue;
                                bl = false;
                                break block7;
                            }
                            bl = true;
                        }
                        if (!bl) continue;
                        object = element$iv;
                        break block8;
                    }
                    object = null;
                }
                if ((psiMethod = (PsiMethod)object) != null) break block10;
            }
            return;
        }
        PsiMethod newMethod = psiMethod;
        this.reformatAndOpenCreatedMethod(newMethod);
    }

    private final void reformatAndOpenCreatedMethod(PsiMethod method) {
        CodeStyleManager.getInstance((Project)this.containingClass.getProject()).reformat((PsiElement)method);
        PsiCodeBlock psiCodeBlock = method.getBody();
        PsiElement psiElement = psiCodeBlock != null ? (PsiElement)psiCodeBlock : this.uastBody(method);
        if (psiElement == null || (psiElement = psiElement.getLastChild()) == null) {
            psiElement = (PsiElement)method;
        }
        PsiNavigateUtil.navigate((PsiElement)psiElement);
    }

    private final PsiElement uastBody(PsiMethod method) {
        Object object;
        PsiMethod psiMethod = method;
        if (psiMethod instanceof UMethod) {
            UExpression uExpression = ((UMethod)method).getUastBody();
            object = uExpression != null ? uExpression.getPsi() : null;
        } else {
            UExpression uExpression;
            UExpression uExpression2;
            PsiElement $receiver$iv;
            PsiElement psiElement = $receiver$iv = (PsiElement)method;
            if (psiElement != null) {
                PsiElement psiElement2;
                PsiElement it$iv = psiElement2 = psiElement;
                uExpression2 = (UMethod)((UastContext)ServiceManager.getService((Project)$receiver$iv.getProject(), UastContext.class)).convertElementWithParent($receiver$iv, UMethod.class);
            } else {
                uExpression2 = uExpression = null;
            }
            object = uExpression2 != null && (uExpression = uExpression.getUastBody()) != null ? uExpression.getPsi() : null;
        }
        return object;
    }

    public CreateMethodFix(@NotNull PsiClass containingClass, @NotNull IntentionAction createMethodAction) {
        Intrinsics.checkParameterIsNotNull((Object)containingClass, (String)"containingClass");
        Intrinsics.checkParameterIsNotNull((Object)createMethodAction, (String)"createMethodAction");
        super(createMethodAction.getText(), createMethodAction.getFamilyName());
        this.createMethodAction = createMethodAction;
        this.containingClass = SmartPointerManager.getInstance((Project)containingClass.getProject()).createSmartPsiElementPointer((PsiElement)containingClass);
    }
}

