/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.BringVariableIntoScopeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstantFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateEnumConstantFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateLocalFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateParameterFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToModuleFix;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyStaticConstantFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameWrongRefFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportConstantFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.PriorityIntentionActionWrapper;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.lang.java.request.CreateFieldFromUsage;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    @Override
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        if (ref == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(1);
        }
        if (PsiUtil.isModuleFile((PsiFile)ref.getContainingFile())) {
            OrderEntryFix.registerFixes(registrar, (PsiReference)ref);
            return;
        }
        registrar.register((IntentionAction)new ImportClassFix(ref));
        registrar.register((IntentionAction)new StaticImportConstantFix(ref));
        registrar.register((IntentionAction)new QualifyStaticConstantFix(ref));
        registrar.register(QuickFixFactory.getInstance().createSetupJDKFix());
        OrderEntryFix.registerFixes(registrar, (PsiReference)ref);
        MoveClassToModuleFix.registerFixes(registrar, ref);
        if (ref instanceof PsiReferenceExpression) {
            TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)ref);
            PsiReferenceExpression refExpr = (PsiReferenceExpression)ref;
            registrar.register((IntentionAction)new RenameWrongRefFix(refExpr));
            if (!ref.isQualified()) {
                registrar.register(fixRange, (IntentionAction)new BringVariableIntoScopeFix(refExpr), null);
            }
            for (IntentionAction action : DefaultQuickFixProvider.createVariableActions(refExpr)) {
                registrar.register(fixRange, action, null);
            }
        }
        registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.INTERFACE));
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)ref)) {
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.ENUM));
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.ANNOTATION));
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiNewExpression.class, PsiMethod.class});
        PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiExpressionList.class);
        if (!(!(parent instanceof PsiNewExpression) || ref.getParent() instanceof PsiTypeElement || expressionList != null && PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)expressionList, (boolean)false))) {
            registrar.register((IntentionAction)new CreateClassFromNewFix((PsiNewExpression)parent));
            registrar.register((IntentionAction)new CreateInnerClassFromNewFix((PsiNewExpression)parent));
        } else {
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.CLASS));
            registrar.register((IntentionAction)new CreateInnerClassFromUsageFix(ref, CreateClassKind.CLASS));
        }
    }

    @NotNull
    private static Collection<IntentionAction> createVariableActions(@NotNull PsiReferenceExpression refExpr) {
        VariableKind kind2;
        if (refExpr == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(2);
        }
        ArrayList<IntentionAction> result2 = new ArrayList<IntentionAction>();
        if (JvmElementActionFactories.useInterlaguageActions()) {
            result2.addAll(CreateFieldFromUsage.generateActions(refExpr));
            if (!refExpr.isQualified()) {
                result2.add((IntentionAction)new CreateLocalFromUsageFix(refExpr));
                result2.add((IntentionAction)new CreateParameterFromUsageFix(refExpr));
            }
            ArrayList<IntentionAction> arrayList = result2;
            if (arrayList == null) {
                DefaultQuickFixProvider.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)refExpr.getProject());
        EnumMap<VariableKind, CreateVarFromUsageFix> map = new EnumMap<VariableKind, CreateVarFromUsageFix>(VariableKind.class);
        map.put(VariableKind.FIELD, new CreateFieldFromUsageFix(refExpr));
        map.put(VariableKind.STATIC_FINAL_FIELD, new CreateConstantFieldFromUsageFix(refExpr));
        if (!refExpr.isQualified()) {
            map.put(VariableKind.LOCAL_VARIABLE, new CreateLocalFromUsageFix(refExpr));
            map.put(VariableKind.PARAMETER, new CreateParameterFromUsageFix(refExpr));
        }
        if (map.containsKey(kind2 = DefaultQuickFixProvider.getKind(styleManager, refExpr))) {
            map.put(kind2, (CreateVarFromUsageFix)PriorityIntentionActionWrapper.highPriority((IntentionAction)((IntentionAction)map.get(kind2))));
        }
        result2.add((IntentionAction)new CreateEnumConstantFromUsageFix(refExpr));
        result2.addAll(map.values());
        ArrayList<IntentionAction> arrayList = result2;
        if (arrayList == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private static VariableKind getKind(@NotNull JavaCodeStyleManager styleManager, @NotNull PsiReferenceExpression refExpr) {
        if (styleManager == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(5);
        }
        if (refExpr == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(6);
        }
        String reference = refExpr.getText();
        boolean upperCase = true;
        for (int i = 0; i < reference.length(); ++i) {
            if (Character.isUpperCase(reference.charAt(i))) continue;
            upperCase = false;
            break;
        }
        if (upperCase) {
            return VariableKind.STATIC_FINAL_FIELD;
        }
        for (VariableKind kind2 : VariableKind.values()) {
            String prefix = styleManager.getPrefixByVariableKind(kind2);
            String suffix = styleManager.getSuffixByVariableKind(kind2);
            if (prefix.isEmpty() && suffix.isEmpty() || !reference.startsWith(prefix) || !reference.endsWith(suffix)) continue;
            return kind2;
        }
        if (StringUtil.isCapitalized((String)reference)) {
            return null;
        }
        return VariableKind.LOCAL_VARIABLE;
    }

    @Override
    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(7);
        }
        return PsiJavaCodeReferenceElement.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVariableActions";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

