/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveRedundantArgumentsFix
implements IntentionAction {
    private final PsiMethod myTargetMethod;
    private final PsiExpression[] myArguments;
    private final PsiSubstitutor mySubstitutor;

    private RemoveRedundantArgumentsFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor substitutor) {
        if (targetMethod == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(0);
        }
        if (arguments == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(1);
        }
        if (substitutor == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(2);
        }
        this.myTargetMethod = targetMethod;
        this.myArguments = arguments;
        this.mySubstitutor = substitutor;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("remove.redundant.arguments.text", JavaHighlightUtil.formatMethod(this.myTargetMethod));
        if (string == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.redundant.arguments.family", new Object[0]);
        if (string == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(5);
        }
        if (!this.myTargetMethod.isValid() || this.myTargetMethod.getContainingClass() == null) {
            return false;
        }
        for (PsiExpression expression2 : this.myArguments) {
            if (expression2.isValid()) continue;
            return false;
        }
        if (!this.mySubstitutor.isValid()) {
            return false;
        }
        return RemoveRedundantArgumentsFix.findRedundantArgument(this.myArguments, this.myTargetMethod.getParameterList().getParameters(), this.mySubstitutor) != null;
    }

    @Nullable
    private static PsiExpression[] findRedundantArgument(@NotNull PsiExpression[] arguments, @NotNull PsiParameter[] parameters2, @NotNull PsiSubstitutor substitutor) {
        if (arguments == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(6);
        }
        if (parameters2 == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(7);
        }
        if (substitutor == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(8);
        }
        if (arguments.length <= parameters2.length) {
            return null;
        }
        for (int i = 0; i < parameters2.length; ++i) {
            PsiExpression argument = arguments[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return null;
            }
            PsiType parameterType = substitutor.substitute(parameter2.getType());
            if (TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)argumentType)) continue;
            return null;
        }
        return Arrays.copyOfRange(arguments, parameters2.length, arguments.length);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiExpression[] redundantArguments;
        if (project2 == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(9);
        }
        if ((redundantArguments = RemoveRedundantArgumentsFix.findRedundantArgument(this.myArguments, this.myTargetMethod.getParameterList().getParameters(), this.mySubstitutor)) != null) {
            for (PsiExpression argument : redundantArguments) {
                argument.delete();
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void registerIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList arguments, @Nullable HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(10);
        }
        if (arguments == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(11);
        }
        for (JavaResolveResult candidate : candidates) {
            RemoveRedundantArgumentsFix.registerIntention(arguments, highlightInfo, fixRange, candidate, (PsiElement)arguments);
        }
    }

    private static void registerIntention(@NotNull PsiExpressionList arguments, @Nullable HighlightInfo highlightInfo, TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (arguments == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(12);
        }
        if (candidate == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(13);
        }
        if (context == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(14);
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (method != null && context.getManager().isInProject((PsiElement)method)) {
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, new RemoveRedundantArgumentsFix(method, arguments.getExpressions(), substitutor));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethod";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findRedundantArgument";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentions";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

