/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceInaccessibleFieldWithGetterSetterFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myMethodName;
    private final boolean myIsSetter;

    public ReplaceInaccessibleFieldWithGetterSetterFix(@NotNull PsiElement element, @NotNull PsiMethod getter, boolean isSetter) {
        if (element == null) {
            ReplaceInaccessibleFieldWithGetterSetterFix.$$$reportNull$$$0(0);
        }
        if (getter == null) {
            ReplaceInaccessibleFieldWithGetterSetterFix.$$$reportNull$$$0(1);
        }
        super(element);
        this.myMethodName = getter.getName();
        this.myIsSetter = isSetter;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            ReplaceInaccessibleFieldWithGetterSetterFix.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ReplaceInaccessibleFieldWithGetterSetterFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            ReplaceInaccessibleFieldWithGetterSetterFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            ReplaceInaccessibleFieldWithGetterSetterFix.$$$reportNull$$$0(5);
        }
        PsiReferenceExpression place = (PsiReferenceExpression)startElement;
        String qualifier = null;
        PsiExpression qualifierExpression2 = place.getQualifierExpression();
        if (qualifierExpression2 != null) {
            qualifier = qualifierExpression2.getText();
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        String call = (qualifier != null ? qualifier + "." : "") + this.myMethodName;
        if (!this.myIsSetter) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)elementFactory.createExpressionFromText(call + "()", null);
            callExpression = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)callExpression);
            place.replace((PsiElement)callExpression);
        } else {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)place, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (parent instanceof PsiAssignmentExpression) {
                PsiExpression rExpression = ((PsiAssignmentExpression)parent).getRExpression();
                String argList = rExpression != null ? rExpression.getText() : "";
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)elementFactory.createExpressionFromText(call + "(" + argList + ")", null);
                callExpression = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)callExpression);
                parent.replace((PsiElement)callExpression);
            }
        }
    }

    @NotNull
    public String getText() {
        String string = this.myIsSetter ? "Replace with setter" : "Replace with getter";
        if (string == null) {
            ReplaceInaccessibleFieldWithGetterSetterFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Replace with getter/setter" == null) {
            ReplaceInaccessibleFieldWithGetterSetterFix.$$$reportNull$$$0(7);
        }
        return "Replace with getter/setter";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceInaccessibleFieldWithGetterSetterFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceInaccessibleFieldWithGetterSetterFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

