/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import org.jetbrains.annotations.NotNull;

public class SuperMethodReturnFix
implements IntentionAction {
    private final PsiType mySuperMethodType;
    private final PsiMethod mySuperMethod;

    public SuperMethodReturnFix(@NotNull PsiMethod superMethod, @NotNull PsiType superMethodType) {
        if (superMethod == null) {
            SuperMethodReturnFix.$$$reportNull$$$0(0);
        }
        if (superMethodType == null) {
            SuperMethodReturnFix.$$$reportNull$$$0(1);
        }
        this.mySuperMethodType = superMethodType;
        this.mySuperMethod = superMethod;
    }

    @NotNull
    public String getText() {
        String name2 = PsiFormatUtil.formatMethod((PsiMethod)this.mySuperMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
        String string = QuickFixBundle.message("fix.super.method.return.type.text", name2, JavaHighlightUtil.formatType(this.mySuperMethodType));
        if (string == null) {
            SuperMethodReturnFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.super.method.return.type.family", new Object[0]);
        if (string == null) {
            SuperMethodReturnFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            SuperMethodReturnFix.$$$reportNull$$$0(4);
        }
        return this.mySuperMethod.isValid() && this.mySuperMethod.getManager().isInProject((PsiElement)this.mySuperMethod) && this.mySuperMethodType.isValid();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            SuperMethodReturnFix.$$$reportNull$$$0(5);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.mySuperMethod.getContainingFile())) {
            return;
        }
        ChangeSignatureProcessor processor2 = new ChangeSignatureProcessor(project2, this.mySuperMethod, false, null, this.mySuperMethod.getName(), this.mySuperMethodType, ParameterInfoImpl.fromMethod(this.mySuperMethod));
        processor2.run();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

