/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeDocumentationUtil {
    private CodeDocumentationUtil() {
    }

    @Deprecated
    public static String createDocCommentLine(String lineData, Project project2, CodeDocumentationAwareCommenter commenter) {
        return CodeDocumentationUtil.createLine(lineData, commenter, DocCommentSettings.DEFAULTS);
    }

    public static String createDocCommentLine(String lineData, PsiFile file2, CodeDocumentationAwareCommenter commenter) {
        DocCommentSettings settings = CodeStyleManager.getInstance((Project)file2.getProject()).getDocCommentSettings(file2);
        return CodeDocumentationUtil.createLine(lineData, commenter, settings);
    }

    @NotNull
    private static String createLine(String lineData, CodeDocumentationAwareCommenter commenter, DocCommentSettings settings) {
        if (!settings.isLeadingAsteriskEnabled()) {
            String string = " " + lineData + " ";
            if (string == null) {
                CodeDocumentationUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (lineData.length() == 0) {
            String string = commenter.getDocumentationCommentLinePrefix() + " ";
            if (string == null) {
                CodeDocumentationUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = commenter.getDocumentationCommentLinePrefix() + " " + lineData + " ";
        if (string == null) {
            CodeDocumentationUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static String getIndentInsideJavadoc(@NotNull Document document, int offset) {
        CharSequence text2;
        if (document == null) {
            CodeDocumentationUtil.$$$reportNull$$$0(3);
        }
        if (offset >= (text2 = document.getCharsSequence()).length()) {
            return null;
        }
        int line = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        int i = CharArrayUtil.shiftForward((CharSequence)text2, (int)lineStartOffset, (String)" \t");
        if (i > lineEndOffset || text2.charAt(i) != '*') {
            return null;
        }
        int start = i + 1;
        int end = CharArrayUtil.shiftForward((CharSequence)text2, (int)start, (String)" \t");
        return (end = Math.min(end, lineEndOffset)) > start ? text2.subSequence(start, end).toString() : "";
    }

    @NotNull
    public static CommentContext tryParseCommentContext(@NotNull PsiFile file2, @NotNull CharSequence chars, int offset, int lineStartOffset) {
        if (file2 == null) {
            CodeDocumentationUtil.$$$reportNull$$$0(4);
        }
        if (chars == null) {
            CodeDocumentationUtil.$$$reportNull$$$0(5);
        }
        Commenter langCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset));
        CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(langCommenter, chars, offset, lineStartOffset);
        if (commentContext == null) {
            CodeDocumentationUtil.$$$reportNull$$$0(6);
        }
        return commentContext;
    }

    static CommentContext tryParseCommentContext(@Nullable Commenter langCommenter, @NotNull CharSequence chars, int offset, int lineStartOffset) {
        boolean isInsideCommentLikeCode;
        if (chars == null) {
            CodeDocumentationUtil.$$$reportNull$$$0(7);
        }
        if (!(isInsideCommentLikeCode = langCommenter instanceof CodeDocumentationAwareCommenter)) {
            return new CommentContext();
        }
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)langCommenter;
        int commentStartOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStartOffset, (String)" \t");
        boolean docStart = commenter.getDocumentationCommentPrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)commentStartOffset, (CharSequence)commenter.getDocumentationCommentPrefix());
        boolean cStyleStart = commenter.getBlockCommentPrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)commentStartOffset, (CharSequence)commenter.getBlockCommentPrefix());
        boolean docAsterisk = commenter.getDocumentationCommentLinePrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)commentStartOffset, (CharSequence)commenter.getDocumentationCommentLinePrefix());
        int firstNonSpaceInLine = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
        boolean slashSlash = commenter.getLineCommentPrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)commentStartOffset, (CharSequence)commenter.getLineCommentPrefix()) && firstNonSpaceInLine < chars.length() && chars.charAt(firstNonSpaceInLine) != '\n';
        return new CommentContext(commenter, docStart, cStyleStart, docAsterisk, slashSlash, commentStartOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/CodeDocumentationUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLine";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/CodeDocumentationUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tryParseCommentContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndentInsideJavadoc";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryParseCommentContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CommentContext {
        public final CodeDocumentationAwareCommenter commenter;
        public final int lineStart;
        public boolean docStart;
        public boolean cStyleStart;
        public boolean docAsterisk;
        public boolean slashSlash;

        public CommentContext() {
            this.commenter = null;
            this.lineStart = 0;
        }

        public CommentContext(CodeDocumentationAwareCommenter commenter, boolean docStart, boolean cStyleStart, boolean docAsterisk, boolean slashSlash, int lineStart) {
            this.docStart = docStart;
            this.cStyleStart = cStyleStart;
            this.docAsterisk = docAsterisk;
            this.slashSlash = slashSlash;
            this.commenter = commenter;
            this.lineStart = lineStart;
        }
    }
}

