/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.codeInsight.editorActions.wordSelection.CodeBlockOrInitializerSelectioner;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodOrClassSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return (e instanceof PsiClass && !(e instanceof PsiTypeParameter) || e instanceof PsiMethod) && e.getLanguage() == JavaLanguage.INSTANCE;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList result2 = ContainerUtil.newArrayList();
        PsiElement firstChild = e.getFirstChild();
        PsiElement[] children2 = e.getChildren();
        int i = 1;
        if (firstChild instanceof PsiDocComment) {
            while (children2[i] instanceof PsiWhiteSpace) {
                ++i;
            }
            TextRange range = new TextRange(children2[i].getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result2.add(range);
            result2.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
            range = TextRange.create((Segment)firstChild.getTextRange());
            result2.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
            firstChild = children2[i++];
        }
        if (firstChild instanceof PsiComment) {
            while (children2[i] instanceof PsiComment || children2[i] instanceof PsiWhiteSpace) {
                ++i;
            }
            PsiElement last = children2[i - 1] instanceof PsiWhiteSpace ? children2[i - 2] : children2[i - 1];
            TextRange range = new TextRange(firstChild.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
            if (range.contains(cursorOffset)) {
                result2.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
            }
            range = new TextRange(children2[i].getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result2.add(range);
            result2.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
        }
        result2.add(e.getTextRange());
        result2.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, e.getTextRange()));
        if (e instanceof PsiClass) {
            result2.addAll(MethodOrClassSelectioner.selectWithTypeParameters((PsiClass)e));
            result2.addAll(MethodOrClassSelectioner.selectBetweenBracesLines(children2, editorText));
        }
        if (e instanceof PsiAnonymousClass) {
            result2.addAll(MethodOrClassSelectioner.selectWholeBlock((PsiClass)((PsiAnonymousClass)e)));
        }
        return result2;
    }

    private static Collection<TextRange> selectWithTypeParameters(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MethodOrClassSelectioner.$$$reportNull$$$0(0);
        }
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        PsiTypeParameterList list2 = psiClass.getTypeParameterList();
        if (identifier != null && list2 != null) {
            return Collections.singletonList(new TextRange(identifier.getTextRange().getStartOffset(), list2.getTextRange().getEndOffset()));
        }
        return Collections.emptyList();
    }

    private static Collection<TextRange> selectBetweenBracesLines(@NotNull PsiElement[] children2, @NotNull CharSequence editorText) {
        int start;
        if (children2 == null) {
            MethodOrClassSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            MethodOrClassSelectioner.$$$reportNull$$$0(2);
        }
        if ((start = CodeBlockOrInitializerSelectioner.findOpeningBrace(children2)) != 0) {
            int end = CodeBlockOrInitializerSelectioner.findClosingBrace(children2, start);
            return MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, new TextRange(start, end));
        }
        return Collections.emptyList();
    }

    private static Collection<TextRange> selectWholeBlock(PsiClass c) {
        PsiJavaToken[] tokens = (PsiJavaToken[])PsiTreeUtil.getChildrenOfType((PsiElement)c, PsiJavaToken.class);
        if (tokens != null && tokens.length == 2 && tokens[0].getTokenType() == JavaTokenType.LBRACE && tokens[1].getTokenType() == JavaTokenType.RBRACE) {
            return Collections.singleton(new TextRange(tokens[0].getTextRange().getStartOffset(), tokens[1].getTextRange().getEndOffset()));
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/MethodOrClassSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectWithTypeParameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "selectBetweenBracesLines";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

