/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.AbstractElementSignatureProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementSignatureProvider
extends AbstractElementSignatureProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.XmlElementSignatureProvider");

    @Override
    public String getSignature(@NotNull PsiElement element) {
        if (element == null) {
            XmlElementSignatureProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            PsiElement parent = tag.getParent();
            StringBuilder buffer = new StringBuilder();
            buffer.append("tag").append("#");
            String name2 = tag.getName();
            buffer.append(name2.length() == 0 ? "<unnamed>" : XmlElementSignatureProvider.escape(name2));
            buffer.append("#");
            buffer.append(XmlElementSignatureProvider.getChildIndex(tag, parent, name2, XmlTag.class));
            if (!(parent instanceof PsiFile)) {
                String parentSignature = this.getSignature(parent);
                if (parentSignature == null) {
                    return null;
                }
                buffer.append(";");
                buffer.append(parentSignature);
            }
            return buffer.toString();
        }
        return null;
    }

    @Override
    protected PsiElement restoreBySignatureTokens(@NotNull PsiFile file2, @NotNull PsiElement parent, @NotNull String type2, @NotNull StringTokenizer tokenizer, @Nullable StringBuilder processingInfoStorage) {
        if (file2 == null) {
            XmlElementSignatureProvider.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            XmlElementSignatureProvider.$$$reportNull$$$0(2);
        }
        if (type2 == null) {
            XmlElementSignatureProvider.$$$reportNull$$$0(3);
        }
        if (tokenizer == null) {
            XmlElementSignatureProvider.$$$reportNull$$$0(4);
        }
        if (type2.equals("tag")) {
            String name2 = tokenizer.nextToken();
            if (parent instanceof XmlFile && (parent = ((XmlFile)parent).getDocument()) == null) {
                return null;
            }
            try {
                int index = Integer.parseInt(tokenizer.nextToken());
                String unescapedName = XmlElementSignatureProvider.unescape(name2);
                XmlTag result2 = XmlElementSignatureProvider.restoreElementInternal(parent, unescapedName, index, XmlTag.class);
                if (result2 == null && file2.getFileType() == StdFileTypes.JSP) {
                    if (parent instanceof XmlDocument) {
                        result2 = XmlElementSignatureProvider.restoreElementInternal((PsiElement)HtmlUtil.getRealXmlDocument((XmlDocument)parent), unescapedName, index, XmlTag.class);
                    } else if (name2.equals("<unnamed>") && parent != null) {
                        result2 = XmlElementSignatureProvider.restoreElementInternal(parent, "", index, XmlTag.class);
                    }
                }
                return result2;
            }
            catch (NumberFormatException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/XmlElementSignatureProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSignature";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreBySignatureTokens";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

