/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageTargetUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightUsagesHandler
extends HighlightHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.highlighting.HighlightUsagesHandler");

    public static void invoke(@NotNull Project project2, @NotNull Editor editor, PsiFile file2) {
        if (project2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (file2 == null && !selectionModel.hasSelection()) {
            selectionModel.selectWordAtCaret(false);
        }
        if (file2 == null || selectionModel.hasSelection()) {
            HighlightUsagesHandler.doRangeHighlighting(editor, project2);
            return;
        }
        HighlightUsagesHandlerBase handler2 = HighlightUsagesHandler.createCustomHandler(editor, file2);
        if (handler2 != null) {
            String featureId = handler2.getFeatureId();
            if (featureId != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
            }
            handler2.highlightUsages();
            return;
        }
        DumbService.getInstance((Project)project2).withAlternativeResolveEnabled(() -> {
            UsageTarget[] usageTargets;
            if (editor == null) {
                HighlightUsagesHandler.$$$reportNull$$$0(18);
            }
            if (project2 == null) {
                HighlightUsagesHandler.$$$reportNull$$$0(19);
            }
            if ((usageTargets = HighlightUsagesHandler.getUsageTargets(editor, file2)) == null) {
                HighlightUsagesHandler.handleNoUsageTargets(file2, editor, selectionModel, project2);
                return;
            }
            boolean clearHighlights = HighlightUsagesHandler.isClearHighlights(editor);
            for (UsageTarget target2 : usageTargets) {
                target2.highlightUsages(file2, editor, clearHighlights);
            }
        });
    }

    @Nullable
    private static UsageTarget[] getUsageTargets(@NotNull Editor editor, PsiFile file2) {
        Object[] results;
        PsiReference ref;
        PsiElement targetElement;
        UsageTarget[] usageTargets;
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(2);
        }
        if ((usageTargets = UsageTargetUtil.findUsageTargets((Editor)editor, (PsiFile)file2)) == null && (targetElement = HighlightUsagesHandler.getTargetElement(editor, file2)) != null && targetElement != file2) {
            if (!(targetElement instanceof NavigationItem)) {
                targetElement = targetElement.getNavigationElement();
            }
            if (targetElement instanceof NavigationItem) {
                usageTargets = new UsageTarget[]{new PsiElement2UsageTargetAdapter(targetElement)};
            }
        }
        if (usageTargets == null && (ref = TargetElementUtil.findReference(editor)) instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)ref).multiResolve(false)).length > 0) {
            usageTargets = (UsageTarget[])ContainerUtil.mapNotNull((Object[])results, result2 -> {
                PsiElement element = result2.getElement();
                return element == null ? null : new PsiElement2UsageTargetAdapter(element);
            }, (Object[])UsageTarget.EMPTY_ARRAY);
        }
        return usageTargets;
    }

    private static void handleNoUsageTargets(PsiFile file2, @NotNull Editor editor, SelectionModel selectionModel, @NotNull Project project2) {
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(4);
        }
        if (file2.findElementAt(editor.getCaretModel().getOffset()) instanceof PsiWhiteSpace) {
            return;
        }
        selectionModel.selectWordAtCaret(false);
        String selection = selectionModel.getSelectedText();
        LOG.assertTrue(selection != null);
        for (int i = 0; i < selection.length(); ++i) {
            if (Character.isJavaIdentifierPart(selection.charAt(i))) continue;
            selectionModel.removeSelection();
        }
        HighlightUsagesHandler.doRangeHighlighting(editor, project2);
        selectionModel.removeSelection();
    }

    @Nullable
    public static HighlightUsagesHandlerBase createCustomHandler(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(6);
        }
        for (HighlightUsagesHandlerFactory factory : (HighlightUsagesHandlerFactory[])Extensions.getExtensions(HighlightUsagesHandlerFactory.EP_NAME)) {
            HighlightUsagesHandlerBase handler2 = factory.createHighlightUsagesHandler(editor, file2);
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetElement(Editor editor, PsiFile file2) {
        int offset;
        PsiElement element;
        PsiElement target2 = TargetElementUtil.findTargetElement(editor, TargetElementUtil.getInstance().getReferenceSearchFlags());
        if (target2 == null && (element = file2.findElementAt(offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset()))) == null) {
            return null;
        }
        return target2;
    }

    private static void doRangeHighlighting(Editor editor, Project project2) {
        EditorSearchSession oldSearch;
        if (!editor.getSelectionModel().hasSelection()) {
            return;
        }
        String text2 = editor.getSelectionModel().getSelectedText();
        if (text2 == null) {
            return;
        }
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        if ((oldSearch = EditorSearchSession.get(editor)) != null && oldSearch.hasMatches()) {
            String oldText = oldSearch.getTextInField();
            if (!oldSearch.getFindModel().isRegularExpressions()) {
                oldText = StringUtil.escapeToRegexp((String)oldText);
                oldSearch.getFindModel().setRegularExpressions(true);
            }
            String newText = oldText + '|' + StringUtil.escapeToRegexp((String)text2);
            oldSearch.setTextInField(newText);
            return;
        }
        EditorSearchSession.start(editor, project2).getFindModel().setRegularExpressions(false);
    }

    public static void highlightOtherOccurrences(List<PsiElement> otherOccurrences, Editor editor, boolean clearHighlights) {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        PsiElement[] elements = PsiUtilCore.toPsiElementArray(otherOccurrences);
        HighlightUsagesHandler.doHighlightElements(editor, elements, attributes, clearHighlights);
    }

    public static void highlightReferences(@NotNull Project project2, @NotNull PsiElement element, @NotNull List<PsiReference> refs, Editor editor, PsiFile file2, boolean clearHighlights) {
        if (project2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(7);
        }
        if (element == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(8);
        }
        if (refs == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(9);
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        TextAttributes writeAttributes = manager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        HighlightUsagesHandler.setupFindModel(project2);
        ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)element);
        if (detector != null) {
            ArrayList<PsiReference> readRefs = new ArrayList<PsiReference>();
            ArrayList<PsiReference> writeRefs = new ArrayList<PsiReference>();
            for (PsiReference ref : refs) {
                if (detector.getReferenceAccess(element, ref) == ReadWriteAccessDetector.Access.Read) {
                    readRefs.add(ref);
                    continue;
                }
                writeRefs.add(ref);
            }
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, readRefs, attributes, clearHighlights);
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, writeRefs, writeAttributes, clearHighlights);
        } else {
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, refs, attributes, clearHighlights);
        }
        TextRange range = HighlightUsagesHandler.getNameIdentifierRange(file2, element);
        if (range != null) {
            TextAttributes nameAttributes = attributes;
            if (detector != null && detector.isDeclarationWriteAccess(element)) {
                nameAttributes = writeAttributes;
            }
            HighlightUsagesHandler.highlightRanges(highlightManager, editor, nameAttributes, clearHighlights, Arrays.asList(range));
        }
    }

    @Nullable
    public static TextRange getNameIdentifierRange(PsiFile file2, PsiElement element) {
        PsiDeclaredTarget declaredTarget;
        TextRange range;
        PomTarget target2;
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)element.getProject());
        if (element instanceof PomTargetPsiElement && (target2 = ((PomTargetPsiElement)element).getTarget()) instanceof PsiDeclaredTarget && (range = (declaredTarget = (PsiDeclaredTarget)target2).getNameIdentifierRange()) != null) {
            if (range.getStartOffset() < 0 || range.getLength() <= 0) {
                return null;
            }
            PsiElement navElement = declaredTarget.getNavigationElement();
            if (PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)navElement)) {
                return injectedManager.injectedToHost(navElement, range.shiftRight(navElement.getTextRange().getStartOffset()));
            }
        }
        if (!PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)element)) {
            return null;
        }
        PsiElement identifier = IdentifierUtil.getNameIdentifier(element);
        if (identifier != null && PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)identifier)) {
            TextRange range2 = identifier.getTextRange();
            return range2 == null ? null : injectedManager.injectedToHost(identifier, range2);
        }
        return null;
    }

    public static void doHighlightElements(Editor editor, PsiElement[] elements, TextAttributes attributes, boolean clearHighlights) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
        ArrayList<TextRange> textRanges = new ArrayList<TextRange>(elements.length);
        for (PsiElement element : elements) {
            TextRange range = element.getTextRange();
            range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, range);
            textRanges.add(range);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, attributes, clearHighlights, textRanges);
    }

    public static void highlightRanges(HighlightManager highlightManager, Editor editor, TextAttributes attributes, boolean clearHighlights, List<TextRange> textRanges) {
        if (clearHighlights) {
            HighlightUsagesHandler.clearHighlights(editor, highlightManager, textRanges, attributes);
            return;
        }
        ArrayList highlighters = new ArrayList();
        for (TextRange range : textRanges) {
            highlightManager.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, false, highlighters);
        }
        for (RangeHighlighter highlighter : highlighters) {
            String tooltip = HighlightUsagesHandler.getLineTextErrorStripeTooltip(editor.getDocument(), highlighter.getStartOffset(), true);
            highlighter.setErrorStripeTooltip((Object)tooltip);
        }
    }

    public static boolean isClearHighlights(@NotNull Editor editor) {
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(10);
        }
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)HighlightManager.getInstance((Project)editor.getProject())).getHighlighters(editor);
        int caretOffset = editor.getCaretModel().getOffset();
        for (RangeHighlighter highlighter : highlighters) {
            if (!TextRange.create((Segment)highlighter).grown(1).contains(caretOffset)) continue;
            return true;
        }
        return false;
    }

    private static void clearHighlights(Editor editor, HighlightManager highlightManager, List<TextRange> rangesToHighlight, TextAttributes attributes) {
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)highlightManager).getHighlighters(editor);
        Arrays.sort(highlighters, (o1, o2) -> o1.getStartOffset() - o2.getStartOffset());
        Collections.sort(rangesToHighlight, (o1, o2) -> o1.getStartOffset() - o2.getStartOffset());
        int i = 0;
        int j = 0;
        while (i < highlighters.length && j < rangesToHighlight.size()) {
            RangeHighlighter highlighter = highlighters[i];
            TextRange highlighterRange = TextRange.create((Segment)highlighter);
            TextRange refRange = rangesToHighlight.get(j);
            if (refRange.equals((Object)highlighterRange) && attributes.equals((Object)highlighter.getTextAttributes()) && highlighter.getLayer() == 5999) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
                ++i;
                continue;
            }
            if (refRange.getStartOffset() > highlighterRange.getEndOffset()) {
                ++i;
                continue;
            }
            if (refRange.getEndOffset() < highlighterRange.getStartOffset()) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
    }

    private static void doHighlightRefs(HighlightManager highlightManager, @NotNull Editor editor, @NotNull List<PsiReference> refs, TextAttributes attributes, boolean clearHighlights) {
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(11);
        }
        if (refs == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(12);
        }
        ArrayList<TextRange> textRanges = new ArrayList<TextRange>(refs.size());
        for (PsiReference ref : refs) {
            HighlightUsagesHandler.collectRangesToHighlight(ref, textRanges);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, attributes, clearHighlights, textRanges);
    }

    @Deprecated
    @NotNull
    public static List<TextRange> getRangesToHighlight(@NotNull PsiReference ref) {
        if (ref == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(13);
        }
        List<TextRange> list2 = HighlightUsagesHandler.collectRangesToHighlight(ref, new ArrayList<TextRange>());
        if (list2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    public static List<TextRange> collectRangesToHighlight(@NotNull PsiReference ref, @NotNull List<TextRange> result2) {
        if (ref == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(16);
        }
        for (TextRange relativeRange : ReferenceRange.getRanges((PsiReference)ref)) {
            PsiElement element = ref.getElement();
            TextRange range = HighlightUsagesHandler.safeCut(element.getTextRange(), relativeRange);
            if (range.isEmpty()) continue;
            result2.add(InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, range));
        }
        List<TextRange> list2 = result2;
        if (list2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(17);
        }
        return list2;
    }

    private static TextRange safeCut(TextRange range, TextRange relative) {
        int start = Math.min(range.getEndOffset(), range.getStartOffset() + relative.getStartOffset());
        int end = Math.min(range.getEndOffset(), range.getStartOffset() + relative.getEndOffset());
        return new TextRange(start, end);
    }

    public static void setStatusText(Project project2, String elementName, int refCount, boolean clearHighlights) {
        String message2 = clearHighlights ? "" : (refCount > 0 ? CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.message" : "status.bar.highlighted.usages.no.target.message"), (Object[])new Object[]{refCount, elementName, HighlightUsagesHandler.getShortcutText()}) : CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.not.found.message" : "status.bar.highlighted.usages.not.found.no.target.message"), (Object[])new Object[]{elementName}));
        WindowManager.getInstance().getStatusBar(project2).setInfo(message2);
    }

    private static String getElementName(PsiElement element) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE);
    }

    public static String getShortcutText() {
        Shortcut[] shortcuts = ActionManager.getInstance().getAction("HighlightUsagesInFile").getShortcutSet().getShortcuts();
        if (shortcuts.length == 0) {
            return "<no key assigned>";
        }
        return KeymapUtil.getShortcutText((Shortcut)shortcuts[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightUsagesHandler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightUsagesHandler";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesToHighlight";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRangesToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUsageTargets";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleNoUsageTargets";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "highlightReferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isClearHighlights";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doHighlightRefs";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRangesToHighlight";
                break;
            }
            case 14: 
            case 17: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectRangesToHighlight";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DoHighlightRunnable
    implements Runnable {
        private final List<PsiReference> myRefs;
        private final Project myProject;
        private final PsiElement myTarget;
        private final Editor myEditor;
        private final PsiFile myFile;
        private final boolean myClearHighlights;

        public DoHighlightRunnable(@NotNull List<PsiReference> refs, @NotNull Project project2, @NotNull PsiElement target2, Editor editor, PsiFile file2, boolean clearHighlights) {
            if (refs == null) {
                DoHighlightRunnable.$$$reportNull$$$0(0);
            }
            if (project2 == null) {
                DoHighlightRunnable.$$$reportNull$$$0(1);
            }
            if (target2 == null) {
                DoHighlightRunnable.$$$reportNull$$$0(2);
            }
            this.myRefs = refs;
            this.myProject = project2;
            this.myTarget = target2;
            this.myEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
            this.myFile = file2;
            this.myClearHighlights = clearHighlights;
        }

        @Override
        public void run() {
            HighlightUsagesHandler.highlightReferences(this.myProject, this.myTarget, this.myRefs, this.myEditor, this.myFile, this.myClearHighlights);
            HighlightUsagesHandler.setStatusText(this.myProject, HighlightUsagesHandler.getElementName(this.myTarget), this.myRefs.size(), this.myClearHighlights);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/highlighting/HighlightUsagesHandler$DoHighlightRunnable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

