/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class TemplateLanguageErrorFilter
extends HighlightErrorFilter {
    @NotNull
    private final TokenSet myTemplateExpressionStartTokens;
    @NotNull
    private final Class myTemplateFileViewProviderClass;
    private final Set<Language> knownLanguageSet;
    private static final Key<Class> TEMPLATE_VIEW_PROVIDER_CLASS_KEY = Key.create((String)"TEMPLATE_VIEW_PROVIDER_CLASS");

    protected TemplateLanguageErrorFilter(@NotNull TokenSet templateExpressionStartTokens, @NotNull Class templateFileViewProviderClass) {
        if (templateExpressionStartTokens == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(0);
        }
        if (templateFileViewProviderClass == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(1);
        }
        this(templateExpressionStartTokens, templateFileViewProviderClass, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    protected TemplateLanguageErrorFilter(@NotNull TokenSet templateExpressionStartTokens, @NotNull Class templateFileViewProviderClass, String ... knownSubLanguageNames) {
        if (templateExpressionStartTokens == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(2);
        }
        if (templateFileViewProviderClass == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(3);
        }
        if (knownSubLanguageNames == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(4);
        }
        this.myTemplateExpressionStartTokens = TokenSet.create((IElementType[])templateExpressionStartTokens.getTypes());
        this.myTemplateFileViewProviderClass = templateFileViewProviderClass;
        ArrayList<String> knownSubLanguageList = new ArrayList<String>(Arrays.asList(knownSubLanguageNames));
        knownSubLanguageList.add("JavaScript");
        knownSubLanguageList.add("CSS");
        this.knownLanguageSet = new HashSet<Language>();
        for (String name2 : knownSubLanguageList) {
            Language language = Language.findLanguageByID((String)name2);
            if (language == null) continue;
            this.knownLanguageSet.add(language);
        }
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(5);
        }
        if (this.isKnownSubLanguage(element.getParent().getLanguage())) {
            PsiLanguageInjectionHost host;
            Class templateClass = (Class)element.getUserData(TEMPLATE_VIEW_PROVIDER_CLASS_KEY);
            if (templateClass != null && templateClass != this.myTemplateFileViewProviderClass) {
                return true;
            }
            PsiFile psiFile = element.getContainingFile();
            int offset = element.getTextOffset();
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject());
            if (injectedLanguageManager.isInjectedFragment(psiFile) && (host = injectedLanguageManager.getInjectionHost((PsiElement)element)) != null) {
                psiFile = host.getContainingFile();
                offset = injectedLanguageManager.injectedToHost((PsiElement)element, offset);
            }
            FileViewProvider viewProvider = psiFile.getViewProvider();
            element.putUserData(TEMPLATE_VIEW_PROVIDER_CLASS_KEY, viewProvider.getClass());
            if (viewProvider.getClass() != this.myTemplateFileViewProviderClass) {
                return true;
            }
            if (this.shouldIgnoreErrorAt(viewProvider, offset) || this.shouldIgnoreErrorAt(viewProvider, offset + 1)) {
                return false;
            }
        }
        return true;
    }

    protected boolean shouldIgnoreErrorAt(@NotNull FileViewProvider viewProvider, int offset) {
        PsiElement element;
        if (viewProvider == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(6);
        }
        if ((element = viewProvider.findElementAt(offset, viewProvider.getBaseLanguage())) instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        return element != null && this.myTemplateExpressionStartTokens.contains(element.getNode().getElementType());
    }

    protected boolean isKnownSubLanguage(@NotNull Language language) {
        if (language == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(7);
        }
        for (Language knownLanguage : this.knownLanguageSet) {
            if (!language.is(knownLanguage) && !knownLanguage.getDialects().contains(language)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExpressionStartTokens";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFileViewProviderClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownSubLanguageNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/highlighting/TemplateLanguageErrorFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightErrorElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldIgnoreErrorAt";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isKnownSubLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

