/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class TooltipController {
    private LightweightHint myCurrentTooltip;
    private TooltipRenderer myCurrentTooltipObject;
    private TooltipGroup myCurrentTooltipGroup;

    public static TooltipController getInstance() {
        return (TooltipController)ServiceManager.getService(TooltipController.class);
    }

    public void cancelTooltips() {
        this.hideCurrentTooltip();
    }

    public void cancelTooltip(@NotNull TooltipGroup groupId, MouseEvent mouseEvent, boolean forced) {
        if (groupId == null) {
            TooltipController.$$$reportNull$$$0(0);
        }
        if (groupId.equals(this.myCurrentTooltipGroup)) {
            if (!forced && this.myCurrentTooltip != null && this.myCurrentTooltip.canControlAutoHide()) {
                return;
            }
            this.cancelTooltips();
        }
    }

    public void showTooltipByMouseMove(@NotNull Editor editor, @NotNull RelativePoint point, TooltipRenderer tooltipObject, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
        LightweightHint currentTooltip;
        if (editor == null) {
            TooltipController.$$$reportNull$$$0(1);
        }
        if (point == null) {
            TooltipController.$$$reportNull$$$0(2);
        }
        if (group == null) {
            TooltipController.$$$reportNull$$$0(3);
        }
        if (hintHint == null) {
            TooltipController.$$$reportNull$$$0(4);
        }
        if ((currentTooltip = this.myCurrentTooltip) == null || !currentTooltip.isVisible()) {
            if (currentTooltip != null) {
                if (!IdeTooltipManager.getInstance().isQueuedToShow(currentTooltip.getCurrentIdeTooltip())) {
                    this.myCurrentTooltipObject = null;
                }
            } else {
                this.myCurrentTooltipObject = null;
            }
        }
        if (Comparing.equal((Object)tooltipObject, (Object)this.myCurrentTooltipObject)) {
            IdeTooltipManager.getInstance().cancelAutoHide();
            return;
        }
        this.hideCurrentTooltip();
        if (tooltipObject != null) {
            Project project2;
            Point p = point.getPointOn((Component)editor.getComponent().getRootPane().getLayeredPane()).getPoint();
            if (!hintHint.isAwtTooltip()) {
                p.x = p.x + (alignToRight ? -10 : 10);
            }
            if ((project2 = editor.getProject()) != null && !project2.isOpen()) {
                return;
            }
            if (editor.getContentComponent().isShowing()) {
                this.showTooltip(editor, p, tooltipObject, alignToRight, group, hintHint);
            }
        }
    }

    private void hideCurrentTooltip() {
        if (this.myCurrentTooltip != null) {
            LightweightHint currentTooltip = this.myCurrentTooltip;
            this.myCurrentTooltip = null;
            currentTooltip.hide();
            this.myCurrentTooltipGroup = null;
            IdeTooltipManager.getInstance().hide(null);
        }
    }

    public void showTooltip(@NotNull Editor editor, @NotNull Point p, @NotNull String text2, boolean alignToRight, @NotNull TooltipGroup group) {
        if (editor == null) {
            TooltipController.$$$reportNull$$$0(5);
        }
        if (p == null) {
            TooltipController.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            TooltipController.$$$reportNull$$$0(7);
        }
        if (group == null) {
            TooltipController.$$$reportNull$$$0(8);
        }
        TooltipRenderer tooltipRenderer = ((EditorMarkupModel)editor.getMarkupModel()).getErrorStripTooltipRendererProvider().calcTooltipRenderer(text2);
        this.showTooltip(editor, p, tooltipRenderer, alignToRight, group);
    }

    public void showTooltip(@NotNull Editor editor, @NotNull Point p, @NotNull String text2, int currentWidth, boolean alignToRight, @NotNull TooltipGroup group) {
        if (editor == null) {
            TooltipController.$$$reportNull$$$0(9);
        }
        if (p == null) {
            TooltipController.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            TooltipController.$$$reportNull$$$0(11);
        }
        if (group == null) {
            TooltipController.$$$reportNull$$$0(12);
        }
        TooltipRenderer tooltipRenderer = ((EditorMarkupModel)editor.getMarkupModel()).getErrorStripTooltipRendererProvider().calcTooltipRenderer(text2, currentWidth);
        this.showTooltip(editor, p, tooltipRenderer, alignToRight, group);
    }

    public void showTooltip(@NotNull Editor editor, @NotNull Point p, @NotNull String text2, int currentWidth, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
        if (editor == null) {
            TooltipController.$$$reportNull$$$0(13);
        }
        if (p == null) {
            TooltipController.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            TooltipController.$$$reportNull$$$0(15);
        }
        if (group == null) {
            TooltipController.$$$reportNull$$$0(16);
        }
        if (hintHint == null) {
            TooltipController.$$$reportNull$$$0(17);
        }
        TooltipRenderer tooltipRenderer = ((EditorMarkupModel)editor.getMarkupModel()).getErrorStripTooltipRendererProvider().calcTooltipRenderer(text2, currentWidth);
        this.showTooltip(editor, p, tooltipRenderer, alignToRight, group, hintHint);
    }

    public void showTooltip(@NotNull Editor editor, @NotNull Point p, @NotNull TooltipRenderer tooltipRenderer, boolean alignToRight, @NotNull TooltipGroup group) {
        if (editor == null) {
            TooltipController.$$$reportNull$$$0(18);
        }
        if (p == null) {
            TooltipController.$$$reportNull$$$0(19);
        }
        if (tooltipRenderer == null) {
            TooltipController.$$$reportNull$$$0(20);
        }
        if (group == null) {
            TooltipController.$$$reportNull$$$0(21);
        }
        this.showTooltip(editor, p, tooltipRenderer, alignToRight, group, new HintHint(editor, p));
    }

    public void showTooltip(@NotNull Editor editor, @NotNull Point p, @NotNull TooltipRenderer tooltipRenderer, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintInfo) {
        if (editor == null) {
            TooltipController.$$$reportNull$$$0(22);
        }
        if (p == null) {
            TooltipController.$$$reportNull$$$0(23);
        }
        if (tooltipRenderer == null) {
            TooltipController.$$$reportNull$$$0(24);
        }
        if (group == null) {
            TooltipController.$$$reportNull$$$0(25);
        }
        if (hintInfo == null) {
            TooltipController.$$$reportNull$$$0(26);
        }
        if (this.myCurrentTooltip == null || !this.myCurrentTooltip.isVisible()) {
            this.myCurrentTooltipObject = null;
        }
        if (Comparing.equal((Object)tooltipRenderer, (Object)this.myCurrentTooltipObject)) {
            IdeTooltipManager.getInstance().cancelAutoHide();
            return;
        }
        if (this.myCurrentTooltipGroup != null && group.compareTo(this.myCurrentTooltipGroup) < 0) {
            return;
        }
        p = new Point(p);
        this.hideCurrentTooltip();
        LightweightHint hint = tooltipRenderer.show(editor, p, alignToRight, group, hintInfo);
        this.myCurrentTooltipGroup = group;
        this.myCurrentTooltip = hint;
        this.myCurrentTooltipObject = tooltipRenderer;
    }

    public boolean shouldSurvive(MouseEvent e) {
        return this.myCurrentTooltip != null && this.myCurrentTooltip.canControlAutoHide();
    }

    public void hide(LightweightHint lightweightHint) {
        if (this.myCurrentTooltip != null && this.myCurrentTooltip.equals(lightweightHint)) {
            this.hideCurrentTooltip();
        }
    }

    public void resetCurrent() {
        this.myCurrentTooltip = null;
        this.myCurrentTooltipGroup = null;
        this.myCurrentTooltipObject = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintHint";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipRenderer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintInfo";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/TooltipController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelTooltip";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showTooltipByMouseMove";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "showTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

