/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionSettingsConfigurable;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.containers.WeakStringInterner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="IntentionManagerSettings", storages={@Storage(value="intentionSettings.xml")})
public class IntentionManagerSettings
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings");
    private final Set<String> myIgnoredActions = new LinkedHashSet<String>();
    private final Map<MetaDataKey, IntentionActionMetaData> myMetaData = new LinkedHashMap<MetaDataKey, IntentionActionMetaData>();
    @NonNls
    private static final String IGNORE_ACTION_TAG = "ignoreAction";
    @NonNls
    private static final String NAME_ATT = "name";
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"loader", (int)1);

    public static IntentionManagerSettings getInstance() {
        return (IntentionManagerSettings)ServiceManager.getService(IntentionManagerSettings.class);
    }

    public void registerIntentionMetaData(@NotNull IntentionAction intentionAction, @NotNull String[] category, @NotNull String descriptionDirectoryName) {
        if (intentionAction == null) {
            IntentionManagerSettings.$$$reportNull$$$0(0);
        }
        if (category == null) {
            IntentionManagerSettings.$$$reportNull$$$0(1);
        }
        if (descriptionDirectoryName == null) {
            IntentionManagerSettings.$$$reportNull$$$0(2);
        }
        this.registerMetaData(new IntentionActionMetaData(intentionAction, IntentionManagerSettings.getClassLoader(intentionAction), category, descriptionDirectoryName));
    }

    private static ClassLoader getClassLoader(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            IntentionManagerSettings.$$$reportNull$$$0(3);
        }
        return intentionAction instanceof IntentionActionWrapper ? ((IntentionActionWrapper)intentionAction).getImplementationClassLoader() : intentionAction.getClass().getClassLoader();
    }

    public void registerIntentionMetaData(@NotNull IntentionAction intentionAction, @NotNull String[] category, @NotNull String descriptionDirectoryName, ClassLoader classLoader) {
        if (intentionAction == null) {
            IntentionManagerSettings.$$$reportNull$$$0(4);
        }
        if (category == null) {
            IntentionManagerSettings.$$$reportNull$$$0(5);
        }
        if (descriptionDirectoryName == null) {
            IntentionManagerSettings.$$$reportNull$$$0(6);
        }
        this.registerMetaData(new IntentionActionMetaData(intentionAction, classLoader, category, descriptionDirectoryName));
    }

    public synchronized boolean isShowLightBulb(@NotNull IntentionAction action) {
        if (action == null) {
            IntentionManagerSettings.$$$reportNull$$$0(7);
        }
        return !this.myIgnoredActions.contains(action.getFamilyName());
    }

    public void loadState(Element element) {
        this.myIgnoredActions.clear();
        List children2 = element.getChildren(IGNORE_ACTION_TAG);
        for (Object aChildren : children2) {
            Element e = (Element)aChildren;
            this.myIgnoredActions.add(e.getAttributeValue(NAME_ATT));
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (String name2 : this.myIgnoredActions) {
            element.addContent(new Element(IGNORE_ACTION_TAG).setAttribute(NAME_ATT, name2));
        }
        return element;
    }

    @NotNull
    public synchronized List<IntentionActionMetaData> getMetaData() {
        IntentionManager.getInstance();
        ArrayList<IntentionActionMetaData> arrayList = new ArrayList<IntentionActionMetaData>(this.myMetaData.values());
        if (arrayList == null) {
            IntentionManagerSettings.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public synchronized boolean isEnabled(@NotNull IntentionActionMetaData metaData) {
        if (metaData == null) {
            IntentionManagerSettings.$$$reportNull$$$0(9);
        }
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(metaData));
    }

    private static String getFamilyName(@NotNull IntentionActionMetaData metaData) {
        if (metaData == null) {
            IntentionManagerSettings.$$$reportNull$$$0(10);
        }
        return StringUtil.join((String[])metaData.myCategory, (String)"/") + "/" + metaData.getFamily();
    }

    private static String getFamilyName(@NotNull IntentionAction action) {
        if (action == null) {
            IntentionManagerSettings.$$$reportNull$$$0(11);
        }
        return action instanceof IntentionActionWrapper ? ((IntentionActionWrapper)action).getFullFamilyName() : action.getFamilyName();
    }

    public synchronized void setEnabled(@NotNull IntentionActionMetaData metaData, boolean enabled) {
        if (metaData == null) {
            IntentionManagerSettings.$$$reportNull$$$0(12);
        }
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(metaData));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(metaData));
        }
    }

    public synchronized boolean isEnabled(@NotNull IntentionAction action) {
        if (action == null) {
            IntentionManagerSettings.$$$reportNull$$$0(13);
        }
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(action));
    }

    public synchronized void setEnabled(@NotNull IntentionAction action, boolean enabled) {
        if (action == null) {
            IntentionManagerSettings.$$$reportNull$$$0(14);
        }
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(action));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(action));
        }
    }

    public synchronized void registerMetaData(@NotNull IntentionActionMetaData metaData) {
        MetaDataKey key2;
        if (metaData == null) {
            IntentionManagerSettings.$$$reportNull$$$0(15);
        }
        if (!this.myMetaData.containsKey((Object)(key2 = new MetaDataKey(metaData.myCategory, metaData.getFamily())))) {
            IntentionManagerSettings.processMetaData(metaData);
        }
        this.myMetaData.put(key2, metaData);
    }

    private static synchronized void processMetaData(@NotNull IntentionActionMetaData metaData) {
        Application app;
        if (metaData == null) {
            IntentionManagerSettings.$$$reportNull$$$0(16);
        }
        if ((app = ApplicationManager.getApplication()).isUnitTestMode() || app.isHeadlessEnvironment()) {
            return;
        }
        TextDescriptor description = metaData.getDescription();
        ourExecutor.execute(() -> {
            if (metaData == null) {
                IntentionManagerSettings.$$$reportNull$$$0(18);
            }
            try {
                SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
                if (registrar == null) {
                    return;
                }
                String descriptionText = description.getText().toLowerCase();
                descriptionText = HTML_PATTERN.matcher(descriptionText).replaceAll(" ");
                Set words = registrar.getProcessedWordsWithoutStemming(descriptionText);
                words.addAll(registrar.getProcessedWords(metaData.getFamily()));
                for (String word : words) {
                    registrar.addOption(word, metaData.getFamily(), metaData.getFamily(), "preferences.intentionPowerPack", IntentionSettingsConfigurable.DISPLAY_NAME);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    public synchronized void unregisterMetaData(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            IntentionManagerSettings.$$$reportNull$$$0(17);
        }
        for (Map.Entry<MetaDataKey, IntentionActionMetaData> entry : this.myMetaData.entrySet()) {
            if (entry.getValue().getAction() != intentionAction) continue;
            this.myMetaData.remove((Object)entry.getKey());
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionAction";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionDirectoryName";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentionMetaData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClassLoader";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isShowLightBulb";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFamilyName";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerMetaData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processMetaData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unregisterMetaData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMetaData$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MetaDataKey
    extends Pair<String, String> {
        private static final StringInterner ourInterner = new WeakStringInterner();

        private MetaDataKey(@NotNull String[] categoryNames, @NotNull String familyName) {
            if (categoryNames == null) {
                MetaDataKey.$$$reportNull$$$0(0);
            }
            if (familyName == null) {
                MetaDataKey.$$$reportNull$$$0(1);
            }
            super((Object)StringUtil.join((String[])categoryNames, (String)":"), ourInterner.intern((Object)familyName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "categoryNames";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "familyName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$MetaDataKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

