/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.AbstractDocumentationTooltipAction;
import com.intellij.codeInsight.navigation.DocPreviewUtil;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.ShowQuickDocAtPinnedWindowFromTooltipAction;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.codeInsight.navigation.actions.GotoTypeDeclarationAction;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CtrlMouseHandler
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.navigation.CtrlMouseHandler");
    private static final AbstractDocumentationTooltipAction[] ourTooltipActions = new AbstractDocumentationTooltipAction[]{new ShowQuickDocAtPinnedWindowFromTooltipAction()};
    private final EditorColorsManager myEditorColorsManager;
    private HighlightersSet myHighlighter;
    @JdkConstants.InputEventMask
    private int myStoredModifiers;
    private TooltipProvider myTooltipProvider;
    private final FileEditorManager myFileEditorManager;
    private final DocumentationManager myDocumentationManager;
    @Nullable
    private Point myPrevMouseLocation;
    private LightweightHint myHint;
    private final KeyListener myEditorKeyListener;
    private final FileEditorManagerListener myFileEditorManagerListener;
    private final VisibleAreaListener myVisibleAreaListener;
    private final EditorMouseAdapter myEditorMouseAdapter;
    private final EditorMouseMotionListener myEditorMouseMotionListener;
    @NotNull
    private final Alarm myDocAlarm;

    private void cancelPreviousTooltip() {
        if (this.myTooltipProvider != null) {
            this.myTooltipProvider.dispose();
            this.myTooltipProvider = null;
        }
    }

    public CtrlMouseHandler(final Project project2, StartupManager startupManager, EditorColorsManager colorsManager, FileEditorManager fileEditorManager, @NotNull DocumentationManager documentationManager, final @NotNull EditorFactory editorFactory) {
        if (documentationManager == null) {
            CtrlMouseHandler.$$$reportNull$$$0(0);
        }
        if (editorFactory == null) {
            CtrlMouseHandler.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myStoredModifiers = 0;
        this.myTooltipProvider = null;
        this.myEditorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.handleKey(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.handleKey(e);
            }

            private void handleKey(KeyEvent e) {
                int modifiers = e.getModifiers();
                if (modifiers == CtrlMouseHandler.this.myStoredModifiers) {
                    return;
                }
                BrowseMode browseMode = CtrlMouseHandler.getBrowseMode(modifiers);
                if (browseMode == BrowseMode.None) {
                    CtrlMouseHandler.this.disposeHighlighter();
                    CtrlMouseHandler.this.cancelPreviousTooltip();
                } else {
                    TooltipProvider tooltipProvider = CtrlMouseHandler.this.myTooltipProvider;
                    if (tooltipProvider != null) {
                        if (browseMode != tooltipProvider.getBrowseMode()) {
                            CtrlMouseHandler.this.disposeHighlighter();
                        }
                        CtrlMouseHandler.this.myStoredModifiers = modifiers;
                        CtrlMouseHandler.this.cancelPreviousTooltip();
                        CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider(tooltipProvider.myEditor, tooltipProvider.myPosition);
                        CtrlMouseHandler.this.myTooltipProvider.execute(browseMode);
                    }
                }
            }
        };
        this.myFileEditorManagerListener = new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.cancelPreviousTooltip();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/CtrlMouseHandler$2", "selectionChanged"));
            }
        };
        this.myVisibleAreaListener = new VisibleAreaListener(){

            public void visibleAreaChanged(VisibleAreaEvent e) {
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.cancelPreviousTooltip();
            }
        };
        this.myEditorMouseAdapter = new EditorMouseAdapter(){

            public void mouseReleased(EditorMouseEvent e) {
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.cancelPreviousTooltip();
            }
        };
        this.myEditorMouseMotionListener = new EditorMouseMotionAdapter(){

            public void mouseMoved(EditorMouseEvent e) {
                if (e.isConsumed() || !CtrlMouseHandler.this.myProject.isInitialized() || CtrlMouseHandler.this.myProject.isDisposed()) {
                    return;
                }
                MouseEvent mouseEvent = e.getMouseEvent();
                Point prevLocation = CtrlMouseHandler.this.myPrevMouseLocation;
                CtrlMouseHandler.this.myPrevMouseLocation = mouseEvent.getLocationOnScreen();
                if (CtrlMouseHandler.this.isMouseOverTooltip(mouseEvent.getLocationOnScreen()) || ScreenUtil.isMovementTowards((Point)prevLocation, (Point)mouseEvent.getLocationOnScreen(), (Rectangle)CtrlMouseHandler.this.getHintBounds())) {
                    return;
                }
                CtrlMouseHandler.this.cancelPreviousTooltip();
                CtrlMouseHandler.this.myStoredModifiers = mouseEvent.getModifiers();
                BrowseMode browseMode = CtrlMouseHandler.getBrowseMode(CtrlMouseHandler.this.myStoredModifiers);
                if (browseMode == BrowseMode.None || e.getArea() != EditorMouseEventArea.EDITING_AREA) {
                    CtrlMouseHandler.this.disposeHighlighter();
                    return;
                }
                Editor editor = e.getEditor();
                if (editor.getProject() != null && editor.getProject() != CtrlMouseHandler.this.myProject) {
                    return;
                }
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject);
                PsiFile psiFile = documentManager.getPsiFile(editor.getDocument());
                Point point = new Point(mouseEvent.getPoint());
                if (documentManager.isCommitted(editor.getDocument())) {
                    int offset = editor.logicalPositionToOffset(editor.xyToLogicalPosition(point));
                    editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile, offset);
                }
                LogicalPosition pos = editor.xyToLogicalPosition(point);
                int offset = editor.logicalPositionToOffset(pos);
                int selStart = editor.getSelectionModel().getSelectionStart();
                int selEnd = editor.getSelectionModel().getSelectionEnd();
                if (offset >= selStart && offset < selEnd) {
                    CtrlMouseHandler.this.disposeHighlighter();
                    return;
                }
                CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider(editor, pos);
                CtrlMouseHandler.this.myTooltipProvider.execute(browseMode);
            }
        };
        this.myEditorColorsManager = colorsManager;
        startupManager.registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                EditorEventMulticaster eventMulticaster = editorFactory.getEventMulticaster();
                eventMulticaster.addEditorMouseListener((EditorMouseListener)CtrlMouseHandler.this.myEditorMouseAdapter, (Disposable)project2);
                eventMulticaster.addEditorMouseMotionListener(CtrlMouseHandler.this.myEditorMouseMotionListener, (Disposable)project2);
                eventMulticaster.addCaretListener(new CaretListener(){

                    public void caretPositionChanged(CaretEvent e) {
                        if (CtrlMouseHandler.this.myHint != null) {
                            CtrlMouseHandler.this.myDocumentationManager.updateToolwindowContext();
                        }
                    }
                }, (Disposable)project2);
            }
        });
        this.myFileEditorManager = fileEditorManager;
        this.myDocumentationManager = documentationManager;
        this.myDocAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
    }

    @NotNull
    public String getComponentName() {
        if ("CtrlMouseHandler" == null) {
            CtrlMouseHandler.$$$reportNull$$$0(2);
        }
        return "CtrlMouseHandler";
    }

    private boolean isMouseOverTooltip(@NotNull Point mouseLocationOnScreen) {
        Rectangle bounds;
        if (mouseLocationOnScreen == null) {
            CtrlMouseHandler.$$$reportNull$$$0(3);
        }
        return (bounds = this.getHintBounds()) != null && bounds.contains(mouseLocationOnScreen);
    }

    @Nullable
    private Rectangle getHintBounds() {
        LightweightHint hint = this.myHint;
        if (hint == null) {
            return null;
        }
        JComponent hintComponent = hint.getComponent();
        if (!hintComponent.isShowing()) {
            return null;
        }
        return new Rectangle(hintComponent.getLocationOnScreen(), hintComponent.getSize());
    }

    @NotNull
    private static BrowseMode getBrowseMode(@JdkConstants.InputEventMask int modifiers) {
        if (modifiers != 0) {
            Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
            if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoDeclaration")) {
                BrowseMode browseMode = BrowseMode.Declaration;
                if (browseMode == null) {
                    CtrlMouseHandler.$$$reportNull$$$0(4);
                }
                return browseMode;
            }
            if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoTypeDeclaration")) {
                BrowseMode browseMode = BrowseMode.TypeDeclaration;
                if (browseMode == null) {
                    CtrlMouseHandler.$$$reportNull$$$0(5);
                }
                return browseMode;
            }
            if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoImplementation")) {
                BrowseMode browseMode = BrowseMode.Implementation;
                if (browseMode == null) {
                    CtrlMouseHandler.$$$reportNull$$$0(6);
                }
                return browseMode;
            }
        }
        BrowseMode browseMode = BrowseMode.None;
        if (browseMode == null) {
            CtrlMouseHandler.$$$reportNull$$$0(7);
        }
        return browseMode;
    }

    @Nullable
    public static String getInfo(PsiElement element, PsiElement atPointer) {
        return CtrlMouseHandler.generateInfo((PsiElement)element, (PsiElement)atPointer, (boolean)true).text;
    }

    @Nullable
    public static String getInfo(@NotNull Editor editor, BrowseMode browseMode) {
        Project project2;
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(8);
        }
        if ((project2 = editor.getProject()) == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        Info info = CtrlMouseHandler.getInfoAt(project2, editor, file2, editor.getCaretModel().getOffset(), browseMode);
        return info == null ? null : info.getInfo().text;
    }

    @NotNull
    private static DocInfo generateInfo(PsiElement element, PsiElement atPointer, boolean fallbackToBasicInfo) {
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(element, atPointer);
        String result2 = documentationProvider.getQuickNavigateInfo(element, atPointer);
        if (result2 == null && fallbackToBasicInfo) {
            result2 = CtrlMouseHandler.doGenerateInfo(element);
        }
        DocInfo docInfo = result2 == null ? DocInfo.EMPTY : new DocInfo(result2, documentationProvider, element);
        if (docInfo == null) {
            CtrlMouseHandler.$$$reportNull$$$0(9);
        }
        return docInfo;
    }

    @Nullable
    private static String doGenerateInfo(@NotNull PsiElement element) {
        ItemPresentation presentation;
        VirtualFile virtualFile;
        if (element == null) {
            CtrlMouseHandler.$$$reportNull$$$0(10);
        }
        if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null) {
            return virtualFile.getPresentableUrl();
        }
        String info = CtrlMouseHandler.getQuickNavigateInfo(element);
        if (info != null) {
            return info;
        }
        if (element instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            return presentation.getPresentableText();
        }
        return null;
    }

    @Nullable
    private static String getQuickNavigateInfo(PsiElement element) {
        String name2 = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
        if (StringUtil.isEmpty((String)name2)) {
            return null;
        }
        String typeName = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
        PsiFile file2 = element.getContainingFile();
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isNotEmpty((String)typeName)) {
            sb.append(typeName).append(" ");
        }
        sb.append("\"").append(name2).append("\"");
        if (file2 != null && file2.isPhysical()) {
            sb.append(" [").append(file2.getName()).append("]");
        }
        return sb.toString();
    }

    private static void showDumbModeNotification(@NotNull Project project2) {
        if (project2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(11);
        }
        DumbService.getInstance((Project)project2).showDumbModeNotification("Element information is not available during index update");
    }

    @Nullable
    private Info getInfoAt(@NotNull Editor editor, @NotNull PsiFile file2, int offset, @NotNull BrowseMode browseMode) {
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(13);
        }
        if (browseMode == null) {
            CtrlMouseHandler.$$$reportNull$$$0(14);
        }
        return CtrlMouseHandler.getInfoAt(this.myProject, editor, file2, offset, browseMode);
    }

    @Nullable
    private static Info getInfoAt(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2, int offset, @NotNull BrowseMode browseMode) {
        PsiElement identifier;
        PsiElement elementAtPointer;
        PsiElement element;
        if (project2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(17);
        }
        if (browseMode == null) {
            CtrlMouseHandler.$$$reportNull$$$0(18);
        }
        PsiElement targetElement = null;
        if (browseMode == BrowseMode.TypeDeclaration) {
            try {
                targetElement = GotoTypeDeclarationAction.findSymbolType(editor, offset);
            }
            catch (IndexNotReadyException e) {
                CtrlMouseHandler.showDumbModeNotification(project2);
            }
        } else if (browseMode == BrowseMode.Declaration) {
            PsiReference ref = TargetElementUtil.findReference(editor, offset);
            List<Object> resolvedElements = ref == null ? Collections.emptyList() : CtrlMouseHandler.resolve(ref);
            PsiElement resolvedElement = resolvedElements.size() == 1 ? (PsiElement)resolvedElements.get(0) : null;
            PsiElement[] targetElements = GotoDeclarationAction.findTargetElementsNoVS(project2, editor, offset, false);
            PsiElement elementAtPointer2 = file2.findElementAt(TargetElementUtil.adjustOffset(file2, editor.getDocument(), offset));
            if (targetElements != null) {
                if (targetElements.length == 0) {
                    return null;
                }
                if (targetElements.length == 1) {
                    if (targetElements[0] != resolvedElement && elementAtPointer2 != null && targetElements[0].isPhysical()) {
                        return ref != null ? new InfoSingle(ref, targetElements[0]) : new InfoSingle(elementAtPointer2, targetElements[0]);
                    }
                } else {
                    return elementAtPointer2 != null ? new InfoMultiple(elementAtPointer2) : null;
                }
            }
            if (resolvedElements.size() == 1) {
                return new InfoSingle(ref, (PsiElement)resolvedElements.get(0));
            }
            if (resolvedElements.size() > 1) {
                return elementAtPointer2 != null ? new InfoMultiple(elementAtPointer2, ref) : null;
            }
        } else if (browseMode == BrowseMode.Implementation) {
            element = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
            PsiElement[] targetElements = new ImplementationSearcher(){

                @Override
                @NotNull
                protected PsiElement[] searchDefinitions(PsiElement element, Editor editor) {
                    ArrayList found = new ArrayList(2);
                    DefinitionsScopedSearch.search((PsiElement)element, (SearchScope)7.getSearchScope(element, editor)).forEach(psiElement -> {
                        found.add(psiElement);
                        return found.size() != 2;
                    });
                    PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(found);
                    if (psiElementArray == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return psiElementArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/CtrlMouseHandler$7", "searchDefinitions"));
                }
            }.searchImplementations(editor, element, offset);
            if (targetElements == null) {
                return null;
            }
            if (targetElements.length > 1) {
                PsiElement elementAtPointer3 = file2.findElementAt(offset);
                if (elementAtPointer3 != null) {
                    return new InfoMultiple(elementAtPointer3);
                }
                return null;
            }
            if (targetElements.length == 1) {
                Navigatable descriptor2 = EditSourceUtil.getDescriptor((PsiElement)targetElements[0]);
                if (descriptor2 == null || !descriptor2.canNavigate()) {
                    return null;
                }
                targetElement = targetElements[0];
            }
        }
        if (targetElement != null && targetElement.isPhysical() && (elementAtPointer = file2.findElementAt(offset)) != null) {
            return new InfoSingle(elementAtPointer, targetElement);
        }
        element = GotoDeclarationAction.findElementToShowUsagesOf(editor, offset);
        if (element instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null && identifier.isValid()) {
            return new Info(identifier){

                @Override
                public void showDocInfo(@NotNull DocumentationManager docManager) {
                    if (docManager == null) {
                        8.$$$reportNull$$$0(0);
                    }
                }

                @Override
                @NotNull
                public DocInfo getInfo() {
                    String name2 = UsageViewUtil.getType(element) + " '" + UsageViewUtil.getShortName(element) + "'";
                    DocInfo docInfo = new DocInfo("Show usages of " + name2, null, element);
                    if (docInfo == null) {
                        8.$$$reportNull$$$0(1);
                    }
                    return docInfo;
                }

                @Override
                public boolean isValid(@NotNull Document document) {
                    if (document == null) {
                        8.$$$reportNull$$$0(2);
                    }
                    return element.isValid();
                }

                @Override
                public boolean isNavigatable() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "docManager";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$8";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "document";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$8";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getInfo";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "showDocInfo";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "isValid";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> resolve(@NotNull PsiReference ref) {
        PsiElement resolvedElement;
        if (ref == null) {
            CtrlMouseHandler.$$$reportNull$$$0(19);
        }
        if ((resolvedElement = ref.resolve()) == null && ref instanceof PsiPolyVariantReference) {
            ResolveResult[] psiElements;
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            for (ResolveResult resolveResult : psiElements = ((PsiPolyVariantReference)ref).multiResolve(false)) {
                if (resolveResult.getElement() == null) continue;
                result2.add(resolveResult.getElement());
            }
            ArrayList<PsiElement> arrayList = result2;
            if (arrayList == null) {
                CtrlMouseHandler.$$$reportNull$$$0(20);
            }
            return arrayList;
        }
        List<Object> list2 = resolvedElement == null ? Collections.emptyList() : Collections.singletonList(resolvedElement);
        if (list2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(21);
        }
        return list2;
    }

    private void disposeHighlighter() {
        if (this.myHighlighter != null) {
            HighlightersSet highlighter = this.myHighlighter;
            this.myHighlighter = null;
            highlighter.uninstall();
            HintManager.getInstance().hideAllHints();
        }
    }

    private void fulfillDocInfo(@NotNull String header, @NotNull DocumentationProvider provider, @NotNull PsiElement originalElement, @NotNull PsiElement anchorElement, @NotNull Consumer<String> newTextConsumer, @NotNull LightweightHint hint) {
        if (header == null) {
            CtrlMouseHandler.$$$reportNull$$$0(22);
        }
        if (provider == null) {
            CtrlMouseHandler.$$$reportNull$$$0(23);
        }
        if (originalElement == null) {
            CtrlMouseHandler.$$$reportNull$$$0(24);
        }
        if (anchorElement == null) {
            CtrlMouseHandler.$$$reportNull$$$0(25);
        }
        if (newTextConsumer == null) {
            CtrlMouseHandler.$$$reportNull$$$0(26);
        }
        if (hint == null) {
            CtrlMouseHandler.$$$reportNull$$$0(27);
        }
        this.myDocAlarm.cancelAllRequests();
        this.myDocAlarm.addRequest(() -> {
            if (anchorElement == null) {
                CtrlMouseHandler.$$$reportNull$$$0(31);
            }
            if (originalElement == null) {
                CtrlMouseHandler.$$$reportNull$$$0(32);
            }
            if (provider == null) {
                CtrlMouseHandler.$$$reportNull$$$0(33);
            }
            if (header == null) {
                CtrlMouseHandler.$$$reportNull$$$0(34);
            }
            if (hint == null) {
                CtrlMouseHandler.$$$reportNull$$$0(35);
            }
            if (newTextConsumer == null) {
                CtrlMouseHandler.$$$reportNull$$$0(36);
            }
            Ref fullTextRef = new Ref();
            Ref qualifiedNameRef = new Ref();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (anchorElement == null) {
                    CtrlMouseHandler.$$$reportNull$$$0(39);
                }
                if (originalElement == null) {
                    CtrlMouseHandler.$$$reportNull$$$0(40);
                }
                if (provider == null) {
                    CtrlMouseHandler.$$$reportNull$$$0(41);
                }
                if (anchorElement.isValid() && originalElement.isValid()) {
                    try {
                        fullTextRef.set((Object)provider.generateDoc(anchorElement, originalElement));
                    }
                    catch (IndexNotReadyException e) {
                        fullTextRef.set((Object)"Documentation is not available while indexing is in progress");
                    }
                    if (anchorElement instanceof PsiQualifiedNamedElement) {
                        qualifiedNameRef.set((Object)((PsiQualifiedNamedElement)anchorElement).getQualifiedName());
                    }
                }
            });
            String fullText = (String)fullTextRef.get();
            if (fullText == null) {
                return;
            }
            String updatedText = DocPreviewUtil.buildPreview(header, (String)qualifiedNameRef.get(), fullText);
            String newHtml = HintUtil.prepareHintText(updatedText, HintUtil.getInformationHint());
            UIUtil.invokeLaterIfNeeded(() -> {
                int widthIncrease;
                if (hint == null) {
                    CtrlMouseHandler.$$$reportNull$$$0(37);
                }
                if (newTextConsumer == null) {
                    CtrlMouseHandler.$$$reportNull$$$0(38);
                }
                JComponent component = hint.getComponent();
                Dimension oldSize = component.getPreferredSize();
                newTextConsumer.consume((Object)newHtml);
                if (component instanceof QuickDocInfoPane) {
                    int buttonWidth = ((QuickDocInfoPane)((Object)((Object)((Object)component)))).getButtonWidth();
                    widthIncrease = CtrlMouseHandler.calculateWidthIncrease(buttonWidth, updatedText);
                } else {
                    widthIncrease = 0;
                }
                if (oldSize == null) {
                    return;
                }
                Dimension newSize = component.getPreferredSize();
                if (newSize.width + widthIncrease == oldSize.width) {
                    return;
                }
                component.setPreferredSize(new Dimension(newSize.width + widthIncrease, newSize.height));
                if (hint.isRealPopup()) {
                    TooltipProvider tooltipProvider = this.myTooltipProvider;
                    if (tooltipProvider != null) {
                        hint.hide();
                        tooltipProvider.showHint(new LightweightHint(component));
                    } else {
                        component.setPreferredSize(new Dimension(newSize.width + widthIncrease, oldSize.height));
                        hint.pack();
                    }
                    return;
                }
                Container topLevelLayeredPaneChild = null;
                boolean adjustBounds = false;
                for (Container current = component.getParent(); current != null; current = current.getParent()) {
                    if (current instanceof JLayeredPane) {
                        adjustBounds = true;
                        break;
                    }
                    topLevelLayeredPaneChild = current;
                }
                if (adjustBounds && topLevelLayeredPaneChild != null) {
                    Rectangle bounds = topLevelLayeredPaneChild.getBounds();
                    topLevelLayeredPaneChild.setBounds(bounds.x, bounds.y, bounds.width + newSize.width + widthIncrease - oldSize.width, bounds.height);
                }
            });
        }, 0);
    }

    private static int calculateWidthIncrease(int buttonWidth, String updatedText) {
        int maxLineWidth = 0;
        TIntArrayList lineWidths = new TIntArrayList();
        for (String lineText : StringUtil.split((String)updatedText, (String)"<br/>")) {
            String html = HintUtil.prepareHintText(lineText, HintUtil.getInformationHint());
            int width = new JLabel((String)html).getPreferredSize().width;
            maxLineWidth = Math.max(maxLineWidth, width);
            lineWidths.add(width);
        }
        if (!lineWidths.isEmpty()) {
            int firstLineAvailableTrailingWidth = maxLineWidth - lineWidths.get(0);
            if (firstLineAvailableTrailingWidth >= buttonWidth) {
                return 0;
            }
            return buttonWidth - firstLineAvailableTrailingWidth;
        }
        return 0;
    }

    @NotNull
    private HighlightersSet installHighlighterSet(@NotNull Info info, @NotNull Editor editor) {
        if (info == null) {
            CtrlMouseHandler.$$$reportNull$$$0(28);
        }
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(29);
        }
        JComponent internalComponent = editor.getContentComponent();
        internalComponent.addKeyListener(this.myEditorKeyListener);
        editor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        Cursor cursor = internalComponent.getCursor();
        if (info.isNavigatable()) {
            internalComponent.setCursor(Cursor.getPredefinedCursor(12));
        }
        this.myFileEditorManager.addFileEditorManagerListener(this.myFileEditorManagerListener);
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        TextAttributes attributes = info.isNavigatable() ? this.myEditorColorsManager.getGlobalScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR) : new TextAttributes(null, HintUtil.getInformationColor(), null, null, 0);
        for (TextRange range : info.getRanges()) {
            TextAttributes attr = NavigationUtil.patchAttributesColor(attributes, range, editor);
            RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 5900, attr, HighlighterTargetArea.EXACT_RANGE);
            highlighters.add(highlighter);
        }
        HighlightersSet highlightersSet = new HighlightersSet(highlighters, editor, cursor, info);
        if (highlightersSet == null) {
            CtrlMouseHandler.$$$reportNull$$$0(30);
        }
        return highlightersSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 20: 
            case 21: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 20: 
            case 21: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentationManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorFactory";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 20: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseLocationOnScreen";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browseMode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 23: 
            case 33: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 24: 
            case 32: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 25: 
            case 31: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorElement";
                break;
            }
            case 26: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTextConsumer";
                break;
            }
            case 27: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowseMode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateInfo";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "installHighlighterSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 20: 
            case 21: 
            case 30: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMouseOverTooltip";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showDumbModeNotification";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInfoAt";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fulfillDocInfo";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "installHighlighterSet";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fulfillDocInfo$2";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 20: 
            case 21: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class QuickDocHyperlinkListener
    implements HyperlinkListener {
        @NotNull
        private final DocumentationProvider myProvider;
        @NotNull
        private final PsiElement myContext;

        QuickDocHyperlinkListener(@NotNull DocumentationProvider provider, PsiElement context) {
            if (provider == null) {
                QuickDocHyperlinkListener.$$$reportNull$$$0(0);
            }
            if (context == null) {
                QuickDocHyperlinkListener.$$$reportNull$$$0(1);
            }
            this.myProvider = provider;
            this.myContext = context;
        }

        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            if (e == null) {
                QuickDocHyperlinkListener.$$$reportNull$$$0(2);
            }
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String description = e.getDescription();
            if (StringUtil.isEmpty((String)description) || !description.startsWith("psi_element://")) {
                return;
            }
            String elementName = e.getDescription().substring("psi_element://".length());
            DumbService.getInstance((Project)CtrlMouseHandler.this.myProject).withAlternativeResolveEnabled(() -> {
                PsiElement targetElement = this.myProvider.getDocumentationElementForLink(PsiManager.getInstance((Project)CtrlMouseHandler.this.myProject), elementName, this.myContext);
                if (targetElement != null) {
                    LightweightHint hint = CtrlMouseHandler.this.myHint;
                    if (hint != null) {
                        hint.hide(true);
                    }
                    CtrlMouseHandler.this.myDocumentationManager.showJavaDocInfo(targetElement, this.myContext, null);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$QuickDocHyperlinkListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class QuickDocInfoPane
    extends JBLayeredPane {
        private static final int BUTTON_HGAP = 5;
        @NotNull
        private final List<JComponent> myButtons;
        @NotNull
        private final JComponent myBaseDocControl;
        private final int myMinWidth;
        private final int myMinHeight;
        private final int myButtonWidth;

        QuickDocInfoPane(@NotNull PsiElement documentationAnchor, @NotNull PsiElement elementUnderMouse, JComponent baseDocControl) {
            if (documentationAnchor == null) {
                QuickDocInfoPane.$$$reportNull$$$0(0);
            }
            if (elementUnderMouse == null) {
                QuickDocInfoPane.$$$reportNull$$$0(1);
            }
            if (baseDocControl == null) {
                QuickDocInfoPane.$$$reportNull$$$0(2);
            }
            this.myButtons = new ArrayList<JComponent>();
            this.myBaseDocControl = baseDocControl;
            PresentationFactory presentationFactory = new PresentationFactory();
            for (AbstractDocumentationTooltipAction action : ourTooltipActions) {
                Icon icon = action.getTemplatePresentation().getIcon();
                Dimension minSize = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                this.myButtons.add(new ActionButton(action, presentationFactory.getPresentation(action), "IdeTooltip", minSize));
                action.setDocInfo(documentationAnchor, elementUnderMouse);
            }
            Collections.reverse(this.myButtons);
            this.setPreferredSize(baseDocControl.getPreferredSize());
            this.setMaximumSize(baseDocControl.getMaximumSize());
            this.setMinimumSize(baseDocControl.getMinimumSize());
            this.setBackground(baseDocControl.getBackground());
            this.add(baseDocControl, 0);
            int minWidth = 0;
            int minHeight = 0;
            int buttonWidth = 0;
            for (JComponent button : this.myButtons) {
                button.setBorder(null);
                button.setBackground(baseDocControl.getBackground());
                this.add(button, 1);
                button.setVisible(false);
                Dimension preferredSize = button.getPreferredSize();
                minWidth += preferredSize.width;
                minHeight = Math.max(minHeight, preferredSize.height);
                buttonWidth = Math.max(buttonWidth, preferredSize.width);
            }
            this.myButtonWidth = buttonWidth;
            int margin = 2;
            this.myMinWidth = minWidth + margin * 2 + (this.myButtons.size() - 1) * 5;
            this.myMinHeight = minHeight + margin * 2;
        }

        public int getButtonWidth() {
            return this.myButtonWidth;
        }

        public Dimension getPreferredSize() {
            return this.expandIfNecessary(this.myBaseDocControl.getPreferredSize());
        }

        public void setPreferredSize(Dimension preferredSize) {
            super.setPreferredSize(preferredSize);
            this.myBaseDocControl.setPreferredSize(preferredSize);
        }

        public Dimension getMinimumSize() {
            return this.expandIfNecessary(this.myBaseDocControl.getMinimumSize());
        }

        public Dimension getMaximumSize() {
            return this.expandIfNecessary(this.myBaseDocControl.getMaximumSize());
        }

        @NotNull
        private Dimension expandIfNecessary(@NotNull Dimension base) {
            if (base == null) {
                QuickDocInfoPane.$$$reportNull$$$0(3);
            }
            if (base.width >= this.myMinWidth && base.height >= this.myMinHeight) {
                Dimension dimension = base;
                if (dimension == null) {
                    QuickDocInfoPane.$$$reportNull$$$0(4);
                }
                return dimension;
            }
            Dimension dimension = new Dimension(Math.max(this.myMinWidth, base.width), Math.max(this.myMinHeight, base.height));
            if (dimension == null) {
                QuickDocInfoPane.$$$reportNull$$$0(5);
            }
            return dimension;
        }

        public void doLayout() {
            Rectangle bounds = this.getBounds();
            this.myBaseDocControl.setBounds(new Rectangle(0, 0, bounds.width, bounds.height));
            int x = bounds.width;
            for (JComponent button : this.myButtons) {
                Dimension buttonSize = button.getPreferredSize();
                button.setBounds(x -= buttonSize.width, 0, buttonSize.width, buttonSize.height);
                x -= 5;
            }
        }

        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                QuickDocInfoPane.$$$reportNull$$$0(6);
            }
            this.processStateChangeIfNecessary(e.getLocationOnScreen(), true);
        }

        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                QuickDocInfoPane.$$$reportNull$$$0(7);
            }
            this.processStateChangeIfNecessary(e.getLocationOnScreen(), false);
        }

        private void processStateChangeIfNecessary(@NotNull Point mouseScreenLocation, boolean mouseEntered) {
            if (mouseScreenLocation == null) {
                QuickDocInfoPane.$$$reportNull$$$0(8);
            }
            if (CtrlMouseHandler.this.myDocumentationManager.hasActiveDockedDocWindow()) {
                return;
            }
            if (!mouseEntered && new Rectangle(this.getLocationOnScreen(), this.getSize()).contains(mouseScreenLocation)) {
                return;
            }
            for (JComponent button : this.myButtons) {
                button.setVisible(mouseEntered);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "documentationAnchor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementUnderMouse";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseDocControl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$QuickDocInfoPane";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mouseScreenLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$QuickDocInfoPane";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expandIfNecessary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "expandIfNecessary";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseEntered";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseExited";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "processStateChangeIfNecessary";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DocInfo {
        public static final DocInfo EMPTY = new DocInfo(null, null, null);
        @Nullable
        public final String text;
        @Nullable
        public final DocumentationProvider docProvider;
        @Nullable
        public final PsiElement documentationAnchor;

        DocInfo(@Nullable String text2, @Nullable DocumentationProvider provider, @Nullable PsiElement documentationAnchor) {
            this.text = text2;
            this.docProvider = provider;
            this.documentationAnchor = documentationAnchor;
        }
    }

    private class HighlightersSet {
        @NotNull
        private final List<RangeHighlighter> myHighlighters;
        @NotNull
        private final Editor myHighlighterView;
        @NotNull
        private final Cursor myStoredCursor;
        @NotNull
        private final Info myStoredInfo;

        private HighlightersSet(@NotNull List<RangeHighlighter> highlighters, @NotNull Editor highlighterView, @NotNull Cursor storedCursor, Info storedInfo) {
            if (highlighters == null) {
                HighlightersSet.$$$reportNull$$$0(0);
            }
            if (highlighterView == null) {
                HighlightersSet.$$$reportNull$$$0(1);
            }
            if (storedCursor == null) {
                HighlightersSet.$$$reportNull$$$0(2);
            }
            if (storedInfo == null) {
                HighlightersSet.$$$reportNull$$$0(3);
            }
            this.myHighlighters = highlighters;
            this.myHighlighterView = highlighterView;
            this.myStoredCursor = storedCursor;
            this.myStoredInfo = storedInfo;
        }

        public void uninstall() {
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlighter.dispose();
            }
            JComponent internalComponent = this.myHighlighterView.getContentComponent();
            internalComponent.setCursor(this.myStoredCursor);
            internalComponent.removeKeyListener(CtrlMouseHandler.this.myEditorKeyListener);
            this.myHighlighterView.getScrollingModel().removeVisibleAreaListener(CtrlMouseHandler.this.myVisibleAreaListener);
            CtrlMouseHandler.this.myFileEditorManager.removeFileEditorManagerListener(CtrlMouseHandler.this.myFileEditorManagerListener);
        }

        @NotNull
        public Info getStoredInfo() {
            Info info = this.myStoredInfo;
            if (info == null) {
                HighlightersSet.$$$reportNull$$$0(4);
            }
            return info;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighterView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storedCursor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storedInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$HighlightersSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$HighlightersSet";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStoredInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class TooltipProvider {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final LogicalPosition myPosition;
        private BrowseMode myBrowseMode;
        private boolean myDisposed;
        private final ProgressIndicator myProgress;

        TooltipProvider(@NotNull Editor editor, LogicalPosition pos) {
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(0);
            }
            if (pos == null) {
                TooltipProvider.$$$reportNull$$$0(1);
            }
            this.myProgress = new ProgressIndicatorBase();
            this.myEditor = editor;
            this.myPosition = pos;
        }

        void dispose() {
            this.myDisposed = true;
            this.myProgress.cancel();
        }

        public BrowseMode getBrowseMode() {
            return this.myBrowseMode;
        }

        void execute(@NotNull BrowseMode browseMode) {
            if (browseMode == null) {
                TooltipProvider.$$$reportNull$$$0(2);
            }
            this.myBrowseMode = browseMode;
            if (PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile(this.myEditor.getDocument()) == null) {
                return;
            }
            if (EditorUtil.inVirtualSpace(this.myEditor, this.myPosition)) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            final int offset = this.myEditor.logicalPositionToOffset(this.myPosition);
            int selStart = this.myEditor.getSelectionModel().getSelectionStart();
            int selEnd = this.myEditor.getSelectionModel().getSelectionEnd();
            if (offset >= selStart && offset < selEnd) {
                return;
            }
            PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).performWhenAllCommitted(() -> ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myProgress, new ReadTask(){

                @Override
                @Nullable
                public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return TooltipProvider.this.doExecute(offset);
                }

                @Override
                public void onCanceled(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    LOG.debug("Highlighting was cancelled");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "indicator";
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$TooltipProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "performInReadAction";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onCanceled";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }));
        }

        @Nullable
        private ReadTask.Continuation doExecute(int offset) {
            DocInfo docInfo;
            Info info;
            if (this.isTaskOutdated()) {
                return null;
            }
            PsiFile file2 = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile(this.myEditor.getDocument());
            if (file2 == null) {
                return null;
            }
            try {
                info = CtrlMouseHandler.this.getInfoAt(this.myEditor, file2, offset, this.myBrowseMode);
                if (info == null) {
                    return null;
                }
                docInfo = info.getInfo();
            }
            catch (IndexNotReadyException e) {
                CtrlMouseHandler.showDumbModeNotification(CtrlMouseHandler.this.myProject);
                return null;
            }
            LOG.debug("Obtained info about element under cursor");
            return new ReadTask.Continuation(() -> {
                if (this.isTaskOutdated()) {
                    return;
                }
                this.showHint(info, docInfo);
            });
        }

        private boolean isTaskOutdated() {
            return this.myDisposed || CtrlMouseHandler.this.myProject.isDisposed() || this.myEditor.isDisposed() || !this.myEditor.getComponent().isShowing();
        }

        private void showHint(@NotNull Info info, @NotNull DocInfo docInfo) {
            if (info == null) {
                TooltipProvider.$$$reportNull$$$0(3);
            }
            if (docInfo == null) {
                TooltipProvider.$$$reportNull$$$0(4);
            }
            if (this.myDisposed || this.myEditor.isDisposed()) {
                return;
            }
            JComponent internalComponent = this.myEditor.getContentComponent();
            if (CtrlMouseHandler.this.myHighlighter != null) {
                if (!info.isSimilarTo(CtrlMouseHandler.this.myHighlighter.getStoredInfo())) {
                    CtrlMouseHandler.this.disposeHighlighter();
                } else {
                    if (info.isNavigatable()) {
                        internalComponent.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    return;
                }
            }
            if (!info.isValid(this.myEditor.getDocument()) || !info.isNavigatable() && docInfo.text == null) {
                return;
            }
            CtrlMouseHandler.this.myHighlighter = CtrlMouseHandler.this.installHighlighterSet(info, this.myEditor);
            if (docInfo.text == null) {
                return;
            }
            if (CtrlMouseHandler.this.myDocumentationManager.hasActiveDockedDocWindow()) {
                info.showDocInfo(CtrlMouseHandler.this.myDocumentationManager);
            }
            QuickDocHyperlinkListener hyperlinkListener = docInfo.docProvider == null ? null : new QuickDocHyperlinkListener(docInfo.docProvider, info.myElementAtPointer);
            final Ref quickDocPaneRef = new Ref();
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    QuickDocInfoPane pane = (QuickDocInfoPane)((Object)quickDocPaneRef.get());
                    if (pane != null) {
                        pane.mouseEntered(e);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    QuickDocInfoPane pane = (QuickDocInfoPane)((Object)quickDocPaneRef.get());
                    if (pane != null) {
                        pane.mouseExited(e);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            };
            Ref newTextConsumerRef = new Ref();
            JComponent label = HintUtil.createInformationLabel(docInfo.text, hyperlinkListener, mouseListener, (Ref<Consumer<String>>)newTextConsumerRef);
            Consumer newTextConsumer = (Consumer)newTextConsumerRef.get();
            QuickDocInfoPane quickDocPane = null;
            if (docInfo.documentationAnchor != null) {
                quickDocPane = new QuickDocInfoPane(docInfo.documentationAnchor, info.myElementAtPointer, label);
                quickDocPaneRef.set((Object)quickDocPane);
            }
            JComponent hintContent = quickDocPane == null ? label : quickDocPane;
            LightweightHint hint = new LightweightHint(hintContent);
            CtrlMouseHandler.this.myHint = hint;
            hint.addHintListener(new HintListener(){

                @Override
                public void hintHidden(EventObject event) {
                    CtrlMouseHandler.this.myHint = null;
                }
            });
            CtrlMouseHandler.this.myDocAlarm.cancelAllRequests();
            if (newTextConsumer != null && docInfo.docProvider != null && docInfo.documentationAnchor != null) {
                CtrlMouseHandler.this.fulfillDocInfo(docInfo.text, docInfo.docProvider, info.myElementAtPointer, docInfo.documentationAnchor, (Consumer<String>)newTextConsumer, hint);
            }
            this.showHint(hint);
        }

        public void showHint(@NotNull LightweightHint hint) {
            if (hint == null) {
                TooltipProvider.$$$reportNull$$$0(5);
            }
            if (this.myEditor.isDisposed()) {
                return;
            }
            HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
            short constraint = 1;
            Point p = HintManagerImpl.getHintPosition(hint, this.myEditor, this.myPosition, constraint);
            if (p.y - hint.getComponent().getPreferredSize().height < 0) {
                constraint = 2;
                p = HintManagerImpl.getHintPosition(hint, this.myEditor, this.myPosition, constraint);
            }
            hintManager.showEditorHint(hint, this.myEditor, p, 42, 0, false, HintManagerImpl.createHintHint(this.myEditor, p, hint, constraint).setContentActive(false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pos";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browseMode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docInfo";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hint";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$TooltipProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showHint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InfoMultiple
    extends Info {
        public InfoMultiple(@NotNull PsiElement elementAtPointer) {
            if (elementAtPointer == null) {
                InfoMultiple.$$$reportNull$$$0(0);
            }
            super(elementAtPointer);
        }

        public InfoMultiple(@NotNull PsiElement elementAtPointer, @NotNull PsiReference ref) {
            if (elementAtPointer == null) {
                InfoMultiple.$$$reportNull$$$0(1);
            }
            if (ref == null) {
                InfoMultiple.$$$reportNull$$$0(2);
            }
            super(elementAtPointer, ReferenceRange.getAbsoluteRanges((PsiReference)ref));
        }

        @Override
        @NotNull
        public DocInfo getInfo() {
            DocInfo docInfo = new DocInfo(CodeInsightBundle.message((String)"multiple.implementations.tooltip", (Object[])new Object[0]), null, null);
            if (docInfo == null) {
                InfoMultiple.$$$reportNull$$$0(3);
            }
            return docInfo;
        }

        @Override
        public boolean isValid(@NotNull Document document) {
            if (document == null) {
                InfoMultiple.$$$reportNull$$$0(4);
            }
            return this.rangesAreCorrect(document);
        }

        @Override
        public boolean isNavigatable() {
            return true;
        }

        @Override
        public void showDocInfo(@NotNull DocumentationManager docManager) {
            if (docManager == null) {
                InfoMultiple.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementAtPointer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$InfoMultiple";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$InfoMultiple";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isValid";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showDocInfo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InfoSingle
    extends Info {
        @NotNull
        private final PsiElement myTargetElement;

        public InfoSingle(@NotNull PsiElement elementAtPointer, @NotNull PsiElement targetElement) {
            if (elementAtPointer == null) {
                InfoSingle.$$$reportNull$$$0(0);
            }
            if (targetElement == null) {
                InfoSingle.$$$reportNull$$$0(1);
            }
            super(elementAtPointer);
            this.myTargetElement = targetElement;
        }

        public InfoSingle(@NotNull PsiReference ref, @NotNull PsiElement targetElement) {
            if (ref == null) {
                InfoSingle.$$$reportNull$$$0(2);
            }
            if (targetElement == null) {
                InfoSingle.$$$reportNull$$$0(3);
            }
            super(ref.getElement(), ReferenceRange.getAbsoluteRanges((PsiReference)ref));
            this.myTargetElement = targetElement;
        }

        @Override
        @NotNull
        public DocInfo getInfo() {
            DocInfo docInfo = this.areElementsValid() ? CtrlMouseHandler.generateInfo(this.myTargetElement, this.myElementAtPointer, this.isNavigatable()) : DocInfo.EMPTY;
            if (docInfo == null) {
                InfoSingle.$$$reportNull$$$0(4);
            }
            return docInfo;
        }

        private boolean areElementsValid() {
            return this.myTargetElement.isValid() && this.myElementAtPointer.isValid();
        }

        @Override
        public boolean isValid(@NotNull Document document) {
            if (document == null) {
                InfoSingle.$$$reportNull$$$0(5);
            }
            return this.areElementsValid() && this.rangesAreCorrect(document);
        }

        @Override
        public boolean isNavigatable() {
            return this.myTargetElement != this.myElementAtPointer && this.myTargetElement != this.myElementAtPointer.getParent();
        }

        @Override
        public void showDocInfo(@NotNull DocumentationManager docManager) {
            if (docManager == null) {
                InfoSingle.$$$reportNull$$$0(6);
            }
            docManager.showJavaDocInfo(this.myTargetElement, this.myElementAtPointer, null);
            docManager.setAllowContentUpdateFromContext(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementAtPointer";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$InfoSingle";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$InfoSingle";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isValid";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "showDocInfo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class Info {
        @NotNull
        protected final PsiElement myElementAtPointer;
        @NotNull
        private final List<TextRange> myRanges;

        public Info(@NotNull PsiElement elementAtPointer, @NotNull List<TextRange> ranges) {
            if (elementAtPointer == null) {
                Info.$$$reportNull$$$0(0);
            }
            if (ranges == null) {
                Info.$$$reportNull$$$0(1);
            }
            this.myElementAtPointer = elementAtPointer;
            this.myRanges = ranges;
        }

        public Info(@NotNull PsiElement elementAtPointer) {
            if (elementAtPointer == null) {
                Info.$$$reportNull$$$0(2);
            }
            this(elementAtPointer, Info.getReferenceRanges(elementAtPointer));
        }

        @NotNull
        private static List<TextRange> getReferenceRanges(@NotNull PsiElement elementAtPointer) {
            if (elementAtPointer == null) {
                Info.$$$reportNull$$$0(3);
            }
            if (!elementAtPointer.isPhysical()) {
                List<TextRange> list2 = Collections.emptyList();
                if (list2 == null) {
                    Info.$$$reportNull$$$0(4);
                }
                return list2;
            }
            int textOffset = elementAtPointer.getTextOffset();
            TextRange range = elementAtPointer.getTextRange();
            if (range == null) {
                throw new AssertionError((Object)("Null range for " + elementAtPointer + " of " + elementAtPointer.getClass()));
            }
            if (textOffset < range.getStartOffset() || textOffset < 0) {
                LOG.error("Invalid text offset " + textOffset + " of element " + elementAtPointer + " of " + elementAtPointer.getClass());
                textOffset = range.getStartOffset();
            }
            List<TextRange> list3 = Collections.singletonList(new TextRange(textOffset, range.getEndOffset()));
            if (list3 == null) {
                Info.$$$reportNull$$$0(5);
            }
            return list3;
        }

        boolean isSimilarTo(@NotNull Info that) {
            if (that == null) {
                Info.$$$reportNull$$$0(6);
            }
            return Comparing.equal((Object)this.myElementAtPointer, (Object)that.myElementAtPointer) && this.myRanges.equals(that.myRanges);
        }

        @NotNull
        public List<TextRange> getRanges() {
            List<TextRange> list2 = this.myRanges;
            if (list2 == null) {
                Info.$$$reportNull$$$0(7);
            }
            return list2;
        }

        @NotNull
        public abstract DocInfo getInfo();

        public abstract boolean isValid(@NotNull Document var1);

        public abstract boolean isNavigatable();

        public abstract void showDocInfo(@NotNull DocumentationManager var1);

        protected boolean rangesAreCorrect(@NotNull Document document) {
            if (document == null) {
                Info.$$$reportNull$$$0(8);
            }
            TextRange docRange = new TextRange(0, document.getTextLength());
            for (TextRange range : this.getRanges()) {
                if (docRange.contains(range)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementAtPointer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$Info";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$Info";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceRanges";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferenceRanges";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSimilarTo";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "rangesAreCorrect";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum BrowseMode {
        None,
        Declaration,
        TypeDeclaration,
        Implementation;

    }
}

